/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.view.barchart;

import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.sugarandsaltsolutions.SugarAndSaltSolutionsResources;
import edu.colorado.phet.sugarandsaltsolutions.common.view.BeakerAndShakerCanvas;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bar
extends PNode {
    protected final PNode valueReadout;

    public Bar(final ObservableProperty<Color> observableProperty, String string, Option<PNode> option, final ObservableProperty<Double> observableProperty2, final ObservableProperty<Boolean> observableProperty3, final double d, final boolean bl) {
        final PhetPPath phetPPath = new PhetPPath(new BasicStroke(1.0f), Color.BLACK){
            {
                super(stroke, paint);
                observableProperty.addObserver(new VoidFunction1<Color>(){

                    @Override
                    public void apply(Color color) {
                        this.setPaint(color);
                    }
                });
            }
        };
        this.addChild(phetPPath);
        observableProperty2.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d2) {
                float f;
                float f2 = (float)(d2 * d);
                if (f2 > (f = 10000.0f) || Float.isNaN(f2) || Float.isInfinite(f2)) {
                    f2 = f;
                }
                phetPPath.setPathToRectangle(0.0f, -f2, 40.0f, f2);
            }
        });
        final HTMLNode hTMLNode = new HTMLNode(string){
            {
                this.setFont(BeakerAndShakerCanvas.CONTROL_FONT);
                this.setOffset(20.0 - this.getFullBoundsReference().width / 2.0, 0.0);
            }
        };
        this.addChild(hTMLNode);
        for (PNode pNode : option) {
            this.addChild(new ZeroOffsetNode(pNode){
                {
                    super(pNode);
                    this.setOffset(hTMLNode.getFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, hTMLNode.getFullBounds().getMaxY());
                }
            });
        }
        this.valueReadout = new HTMLNode(){
            {
                this.setFont(BeakerAndShakerCanvas.CONTROL_FONT);
                observableProperty2.addObserver(new VoidFunction1<Double>(){

                    @Override
                    public void apply(Double d) {
                        double d2 = 1000.0;
                        double d3 = d / d2;
                        String string = new DecimalFormat("0.00").format(d3);
                        this.setHTML(MessageFormat.format(bl ? SugarAndSaltSolutionsResources.Strings.PATTERN__MOLES_PER_LITER_MULTILINE : SugarAndSaltSolutionsResources.Strings.PATTERN__MOLES_PER_LITER, string));
                        this.setOffset(phetPPath.getFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, phetPPath.getFullBounds().getMinY() - this.getFullBounds().getHeight());
                    }
                });
                observableProperty3.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setVisible(bl);
                    }
                });
            }
        };
        this.addChild(this.valueReadout);
    }
}

