/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.view;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.sugarandsaltsolutions.SugarAndSaltSolutionsResources;
import edu.colorado.phet.sugarandsaltsolutions.common.view.BeakerAndShakerCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimizedConcentrationBarChart
extends PNode {
    protected final int INSET = 5;

    public MinimizedConcentrationBarChart(final Property<Boolean> property) {
        BufferedImage bufferedImage = PhetCommonResources.getMaximizeButtonImage();
        PText pText = new PText(SugarAndSaltSolutionsResources.Strings.CONCENTRATION){
            {
                this.setFont(BeakerAndShakerCanvas.TITLE_FONT);
            }
        };
        property.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                MinimizedConcentrationBarChart.this.setVisible(bl == false);
            }
        });
        PhetPPath phetPPath = new PhetPPath(new Rectangle2D.Double(0.0, 0.0, 220.0, Math.max(pText.getFullBounds().getHeight(), (double)bufferedImage.getHeight()) + 10.0), BeakerAndShakerCanvas.WATER_COLOR, new BasicStroke(1.0f), Color.BLACK);
        PImage pImage = new PImage(bufferedImage){
            {
                super(image);
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new PBasicInputEventHandler(){

                    public void mousePressed(PInputEvent pInputEvent) {
                        property.set(true);
                    }
                });
            }
        };
        this.addChild(phetPPath);
        this.addChild(pImage);
        this.addChild(pText);
        pText.setOffset(this.getFullBounds().getCenterX() - pText.getFullBounds().getWidth() / 2.0, 5.0);
        pImage.setOffset(phetPPath.getFullBounds().getWidth() - pImage.getFullBounds().getWidth() - 5.0, 5.0);
    }
}

