/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableRectangle2D;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.DoubleProperty;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.sugarandsaltsolutions.common.model.AbstractSugarAndSaltSolutionsModel;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Beaker;
import edu.colorado.phet.sugarandsaltsolutions.common.model.BeakerDimension;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Dispenser;
import edu.colorado.phet.sugarandsaltsolutions.common.model.DispenserType;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Solution;
import edu.colorado.phet.sugarandsaltsolutions.common.view.BeakerAndShakerCanvas;
import edu.colorado.phet.sugarandsaltsolutions.common.view.FaucetMetrics;
import edu.colorado.phet.sugarandsaltsolutions.common.view.VerticalRangeContains;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public abstract class SugarAndSaltSolutionModel
extends AbstractSugarAndSaltSolutionsModel {
    private final double aspectRatio = BeakerAndShakerCanvas.canvasSize.getWidth() / BeakerAndShakerCanvas.canvasSize.getHeight();
    public final Property<Double> inputFlowRate = new Property<Double>(0.0);
    public final DoubleProperty outputFlowRate = new DoubleProperty(0.0);
    public final double faucetFlowRate;
    public final double drainPipeBottomY;
    public final double drainPipeTopY;
    public final double distanceScale;
    public final Property<DispenserType> dispenserType = new Property<DispenserType>(DispenserType.SALT);
    public final Property<Boolean> showConcentrationValues = new Property<Boolean>(false);
    public final DoubleProperty waterVolume;
    public final Beaker beaker;
    public final double maxWater;
    public final VerticalRangeContains lowerFaucetCanDrain;
    public final Property<Boolean> showConcentrationBarChart;
    public final ImmutableRectangle2D visibleRegion;
    public final ImmutableRectangle2D dragRegion;
    public final ObservableProperty<Boolean> beakerFull;
    private FaucetMetrics drainFaucetMetrics = new FaucetMetrics(this, ImmutableVector2D.ZERO, ImmutableVector2D.ZERO, 0.0);
    private FaucetMetrics inputFaucetMetrics = new FaucetMetrics(this, ImmutableVector2D.ZERO, ImmutableVector2D.ZERO, 0.0);
    public final Property<Shape> inputWater = new Property<Area>(new Area());
    public final Property<Shape> outputWater = new Property<Area>(new Area());
    public final Function1<Point2D, Point2D> dragConstraint = new Function1<Point2D, Point2D>(){

        @Override
        public Point2D apply(Point2D point2D) {
            return new Point2D.Double(SugarAndSaltSolutionModel.this.dragRegion.getClosestPoint(point2D).getX(), MathUtil.clamp(SugarAndSaltSolutionModel.this.beaker.getTopY() * 1.3, point2D.getY(), SugarAndSaltSolutionModel.this.beaker.getTopY() * 2.0));
        }
    };
    public final ArrayList<Dispenser> dispensers;
    public final SettableProperty<Double> evaporationRate = new Property<Double>(0.0);
    public final double evaporationRateScale;
    protected double time;
    public final Solution solution;

    public SugarAndSaltSolutionModel(ConstantDtClock constantDtClock, final BeakerDimension beakerDimension, double d, double d2, double d3, double d4) {
        super(constantDtClock);
        this.faucetFlowRate = d;
        this.drainPipeBottomY = d2;
        this.drainPipeTopY = d3;
        this.distanceScale = d4;
        this.evaporationRateScale = d / 300.0;
        this.waterVolume = new DoubleProperty(beakerDimension.getVolume() / 2.0);
        double d5 = beakerDimension.width * 0.1;
        double d6 = beakerDimension.width + d5 * 2.0;
        this.beaker = new Beaker(beakerDimension.x, 0.0, beakerDimension.width, beakerDimension.height, beakerDimension.depth, beakerDimension.wallThickness);
        this.visibleRegion = new ImmutableRectangle2D(-d6 / 2.0, -d5, d6, d6 / this.aspectRatio);
        double d7 = this.visibleRegion.width / 6.0;
        this.dragRegion = new ImmutableRectangle2D(this.visibleRegion.x + d7, this.visibleRegion.y, this.visibleRegion.width - d7, this.visibleRegion.height);
        this.maxWater = this.beaker.getMaxFluidVolume();
        this.showConcentrationBarChart = new Property<Boolean>(true);
        this.dispensers = new ArrayList();
        this.inputFlowRate.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                double d2 = d * ((SugarAndSaltSolutionModel)SugarAndSaltSolutionModel.this).inputFaucetMetrics.faucetWidth;
                double d3 = ((SugarAndSaltSolutionModel)SugarAndSaltSolutionModel.this).inputFaucetMetrics.outputPoint.getY();
                SugarAndSaltSolutionModel.this.inputWater.set(new Rectangle2D.Double(((SugarAndSaltSolutionModel)SugarAndSaltSolutionModel.this).inputFaucetMetrics.outputPoint.getX() - d2 / 2.0, ((SugarAndSaltSolutionModel)SugarAndSaltSolutionModel.this).inputFaucetMetrics.outputPoint.getY() - d3, d2, d3));
            }
        });
        this.outputFlowRate.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                double d2 = d * ((SugarAndSaltSolutionModel)SugarAndSaltSolutionModel.this).drainFaucetMetrics.faucetWidth;
                double d3 = beakerDimension.height * 2.0;
                SugarAndSaltSolutionModel.this.outputWater.set(new Rectangle2D.Double(((SugarAndSaltSolutionModel)SugarAndSaltSolutionModel.this).drainFaucetMetrics.outputPoint.getX() - d2 / 2.0, ((SugarAndSaltSolutionModel)SugarAndSaltSolutionModel.this).drainFaucetMetrics.outputPoint.getY() - d3, d2, d3));
            }
        });
        this.solution = new Solution(this.waterVolume, this.beaker);
        this.beakerFull = this.solution.volume.greaterThanOrEqualTo(this.maxWater);
        this.lowerFaucetCanDrain = new VerticalRangeContains(this.solution.shape, d2, d3);
    }

    protected void waterEvaporated(double d) {
    }

    public void reset() {
        this.resetWater();
        for (Dispenser dispenser : this.dispensers) {
            dispenser.reset();
        }
        this.dispenserType.reset();
        this.showConcentrationValues.reset();
        this.showConcentrationBarChart.reset();
        this.notifyReset();
    }

    protected void resetWater() {
        this.waterVolume.reset();
        this.inputFlowRate.reset();
        this.outputFlowRate.reset();
    }

    public double getTime() {
        return this.time;
    }

    public FaucetMetrics getDrainFaucetMetrics() {
        return this.drainFaucetMetrics;
    }

    public void setDrainFaucetMetrics(FaucetMetrics faucetMetrics) {
        this.drainFaucetMetrics = faucetMetrics;
    }

    public void setInputFaucetMetrics(FaucetMetrics faucetMetrics) {
        this.inputFaucetMetrics = faucetMetrics;
    }

    protected double updateModel(double d) {
        this.time += d;
        for (Dispenser dispenser : this.dispensers) {
            dispenser.updateModel();
        }
        double d2 = d * this.inputFlowRate.get() * this.faucetFlowRate;
        double d3 = d * (Double)this.outputFlowRate.get() * this.faucetFlowRate;
        double d4 = d * (Double)this.evaporationRate.get() * this.evaporationRateScale;
        double d5 = (Double)this.waterVolume.get() + d2 - d3 - d4;
        if (d5 > this.maxWater) {
            d2 = this.maxWater + d3 + d4 - (Double)this.waterVolume.get();
        } else if (d5 < 0.0 && (Double)this.outputFlowRate.get() > 0.0) {
            d3 = d2 + (Double)this.waterVolume.get();
        } else if (d5 < 0.0 && (Double)this.evaporationRate.get() > 0.0) {
            d4 = d2 + (Double)this.waterVolume.get();
        }
        d5 = (Double)this.waterVolume.get() + d2 - d3 - d4;
        if (d5 >= this.maxWater) {
            this.inputFlowRate.set(0.0);
        }
        if (!((Boolean)this.lowerFaucetCanDrain.get()).booleanValue()) {
            this.outputFlowRate.set(0.0);
        }
        if (d5 <= 0.0) {
            this.evaporationRate.set(0.0);
        }
        this.waterVolume.set(d5);
        if (d4 > 0.0) {
            this.waterEvaporated(d4);
        }
        return d3;
    }
}

