/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.sugarandsaltsolutions.SugarAndSaltSolutionsApplication;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Units;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;

public class SphericalParticle
extends Particle {
    public final double radius;
    public final Color color;
    public final Color chargeColor;
    private final double charge;
    public static final Color NEUTRAL_COLOR = Color.yellow;
    public static final Color POSITIVE_COLOR = PhetColorScheme.RED_COLORBLIND;
    public static final Color NEGATIVE_COLOR = Color.blue;

    public SphericalParticle(double d, Color color, Color color2, double d2) {
        this(Units.picometersToMeters(d) * SugarAndSaltSolutionsApplication.sizeScale.get(), ImmutableVector2D.ZERO, color2, d2, color);
    }

    private SphericalParticle(double d, ImmutableVector2D immutableVector2D, Color color, double d2, Color color2) {
        super(immutableVector2D);
        this.radius = d;
        this.color = color;
        this.charge = d2;
        this.chargeColor = color2;
    }

    public Shape getShape() {
        return new Ellipse2D.Double(this.getPosition().getX() - this.radius, this.getPosition().getY() - this.radius, this.radius * 2.0, this.radius * 2.0);
    }

    public double getCharge() {
        return this.charge;
    }

    public double getPartialChargeDisplayValue() {
        return this.getCharge();
    }

    public static class Calcium
    extends SphericalParticle {
        public Calcium() {
            super(100.0, POSITIVE_COLOR, new Color(6, 98, 23), 1.0);
        }
    }

    public static class Carbon
    extends SphericalParticle {
        public Carbon() {
            super(77.0, NEUTRAL_COLOR, Color.gray, 0.0);
        }
    }

    public static class Chloride
    extends SphericalParticle {
        public Chloride() {
            super(181.0, NEGATIVE_COLOR, Color.green, -1.0);
        }
    }

    public static class FreeOxygen
    extends Oxygen {
        public FreeOxygen() {
            super(Color.blue);
        }
    }

    public static class Hydrogen
    extends SphericalParticle {
        public Hydrogen() {
            this(NEUTRAL_COLOR, 1.0);
        }

        protected Hydrogen(Color color, double d) {
            super(37.0, color, Color.white, d);
        }
    }

    public static class NeutralOxygen
    extends Oxygen {
        public NeutralOxygen() {
            super(NEUTRAL_COLOR);
        }
    }

    public static class Nitrogen
    extends SphericalParticle {
        public Nitrogen() {
            super(75.0, NEGATIVE_COLOR, Color.blue, -1.0);
        }
    }

    public static abstract class Oxygen
    extends SphericalParticle {
        public Oxygen(Color color) {
            this(color, -2.0);
        }

        protected Oxygen(Color color, double d) {
            super(73.0, color, PhetColorScheme.RED_COLORBLIND, d);
        }
    }

    public static class Sodium
    extends SphericalParticle {
        public Sodium() {
            super(102.0, POSITIVE_COLOR, Color.magenta, 1.0);
        }
    }
}

