/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.model;

import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SphericalParticle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.sucrose.Sucrose;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.glucose.Glucose;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.sodiumnitrate.Nitrate;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formula {
    public final HashMap<Class<? extends Particle>, Integer> map;
    public static final Formula SODIUM_CHLORIDE = new Formula(SphericalParticle.Sodium.class, SphericalParticle.Chloride.class);
    public static final Formula SUCROSE = new Formula(Sucrose.class);
    public static final Formula GLUCOSE = new Formula(Glucose.class);
    public static final Formula SODIUM_NITRATE = new Formula(SphericalParticle.Sodium.class, Nitrate.class);
    public static final Formula CALCIUM_CHLORIDE = new Formula(SphericalParticle.Calcium.class, SphericalParticle.Chloride.class, 2){

        @Override
        public ArrayList<Class<? extends Particle>> getTypes() {
            return new ArrayList<Class<? extends Particle>>(){
                {
                    this.add(SphericalParticle.Calcium.class);
                    this.add(SphericalParticle.Chloride.class);
                }
            };
        }
    };

    public Formula(Class<? extends Particle> clazz, Class<? extends Particle> clazz2) {
        this(clazz, clazz2, 1);
    }

    public Formula(final Class<? extends Particle> clazz, final Class<? extends Particle> clazz2, final int n) {
        this(new HashMap<Class<? extends Particle>, Integer>(){
            {
                this.put(clazz, 1);
                this.put(clazz2, n);
            }
        });
    }

    public Formula(final Class<? extends Particle> clazz) {
        this(new HashMap<Class<? extends Particle>, Integer>(){
            {
                this.put(clazz, 1);
            }
        });
    }

    public Formula(HashMap<Class<? extends Particle>, Integer> hashMap) {
        this.map = hashMap;
    }

    public ArrayList<Class<? extends Particle>> getTypes() {
        return new ArrayList<Class<? extends Particle>>(this.map.keySet());
    }

    public int getFactor(Class clazz) {
        return this.map.get(clazz);
    }

    public ArrayList<Class<? extends Particle>> getFormulaUnit() {
        ArrayList<Class<? extends Particle>> arrayList = new ArrayList<Class<? extends Particle>>();
        for (Class<? extends Particle> clazz : this.getTypes()) {
            for (int i = 0; i < this.getFactor(clazz); ++i) {
                arrayList.add(clazz);
            }
        }
        return arrayList;
    }

    public String toString() {
        return this.map.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Formula formula = (Formula)object;
        return this.map.equals(formula.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }
}

