/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.DoubleProperty;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Beaker;
import edu.colorado.phet.sugarandsaltsolutions.common.model.DispenserType;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SugarAndSaltSolutionModel;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Dispenser<T extends SugarAndSaltSolutionModel> {
    public final Property<ImmutableVector2D> center;
    public final DoubleProperty angle;
    public final Property<Boolean> enabled = new Property<Boolean>(false);
    protected final Beaker beaker;
    public final ObservableProperty<Boolean> moreAllowed;
    public final String name;
    public final double distanceScale;
    protected double dispenserHeight;
    public final T model;

    public Dispenser(double d, double d2, double d3, Beaker beaker, ObservableProperty<Boolean> observableProperty, String string, double d4, ObservableProperty<DispenserType> observableProperty2, final DispenserType dispenserType, T t) {
        this.beaker = beaker;
        this.moreAllowed = observableProperty;
        this.name = string;
        this.model = t;
        this.angle = new DoubleProperty(d3);
        this.center = new Property<ImmutableVector2D>(new ImmutableVector2D(d, d2));
        this.distanceScale = d4;
        observableProperty2.addObserver(new VoidFunction1<DispenserType>(){

            @Override
            public void apply(DispenserType dispenserType2) {
                Dispenser.this.enabled.set(dispenserType2 == dispenserType);
            }
        });
    }

    public void translate(Dimension2D dimension2D) {
        ImmutableVector2D immutableVector2D = this.center.get().plus(dimension2D);
        double d = MathUtil.clamp(this.beaker.getTopY(), immutableVector2D.getY(), Double.POSITIVE_INFINITY);
        this.center.set(new ImmutableVector2D(immutableVector2D.getX(), d));
    }

    public void reset() {
        this.center.reset();
        this.angle.reset();
    }

    protected ImmutableVector2D getCrystalVelocity(ImmutableVector2D immutableVector2D) {
        ImmutableVector2D immutableVector2D2 = immutableVector2D.minus(this.center.get());
        double d = (Double)this.angle.get() - 1.5707963267948966;
        return immutableVector2D2.getInstanceOfMagnitude(0.2 + 0.3 * Math.sin(d));
    }

    public abstract void updateModel();

    public abstract PNode createNode(ModelViewTransform var1, boolean var2, Function1<Point2D, Point2D> var3);

    public void setDispenserHeight(double d) {
        this.dispenserHeight = d;
    }
}

