/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableRectangle2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.nodes.conductivitytester.IConductivityTester;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class ConductivityTester
implements IConductivityTester {
    private final Point2D.Double negativeProbeLocation;
    private final Point2D.Double positiveProbeLocation;
    private final Point2D.Double location;
    private final double negativeProbeX;
    private final double positiveProbeX;
    final double defaultProbeY;
    private PDimension PROBE_SIZE = new PDimension(0.0125, 0.025);
    private final ArrayList<IConductivityTester.ConductivityTesterChangeListener> conductivityTesterListeners = new ArrayList();
    public final Property<Boolean> visible = new Property<Boolean>(false);
    public final Property<Double> brightness = new Property<Double>(Double.valueOf(0.0)){
        {
            this.addObserver(new SimpleObserver(){

                public void update() {
                    for (IConductivityTester.ConductivityTesterChangeListener conductivityTesterChangeListener : ConductivityTester.this.conductivityTesterListeners) {
                        conductivityTesterChangeListener.brightnessChanged();
                    }
                }
            });
        }
    };
    public final Property<Boolean> shortCircuited = new Property<Boolean>(false);
    private Shape batteryRegion;
    private Shape bulbRegion;

    public ConductivityTester(double d, double d2) {
        this.defaultProbeY = d2;
        this.negativeProbeX = -d / 3.0;
        this.positiveProbeX = d / 3.0;
        this.negativeProbeLocation = new Point2D.Double(this.negativeProbeX, this.defaultProbeY);
        this.positiveProbeLocation = new Point2D.Double(this.positiveProbeX, this.defaultProbeY);
        this.location = new Point2D.Double(0.0, this.defaultProbeY);
    }

    public boolean isVisible() {
        return this.visible.get();
    }

    public void addConductivityTesterChangeListener(IConductivityTester.ConductivityTesterChangeListener conductivityTesterChangeListener) {
        this.conductivityTesterListeners.add(conductivityTesterChangeListener);
    }

    public PDimension getProbeSizeReference() {
        return this.PROBE_SIZE;
    }

    public ImmutableRectangle2D getPositiveProbeRegion() {
        return new ImmutableRectangle2D(this.positiveProbeLocation.getX() - this.getProbeSizeReference().getWidth() / 2.0, this.positiveProbeLocation.getY(), this.getProbeSizeReference().getWidth(), this.getProbeSizeReference().getHeight());
    }

    public ImmutableRectangle2D getNegativeProbeRegion() {
        return new ImmutableRectangle2D(this.negativeProbeLocation.getX() - this.getProbeSizeReference().getWidth() / 2.0, this.negativeProbeLocation.getY(), this.getProbeSizeReference().getWidth(), this.getProbeSizeReference().getHeight());
    }

    public Point2D getPositiveProbeLocationReference() {
        return this.positiveProbeLocation;
    }

    public Point2D getLocationReference() {
        return this.location;
    }

    public void setPositiveProbeLocation(double d, double d2) {
        this.positiveProbeLocation.setLocation(d, d2);
        for (IConductivityTester.ConductivityTesterChangeListener conductivityTesterChangeListener : this.conductivityTesterListeners) {
            conductivityTesterChangeListener.positiveProbeLocationChanged();
        }
    }

    public Point2D getNegativeProbeLocationReference() {
        return this.negativeProbeLocation;
    }

    public void setNegativeProbeLocation(double d, double d2) {
        this.negativeProbeLocation.setLocation(d, d2);
        for (IConductivityTester.ConductivityTesterChangeListener conductivityTesterChangeListener : this.conductivityTesterListeners) {
            conductivityTesterChangeListener.negativeProbeLocationChanged();
        }
    }

    public double getBrightness() {
        return this.brightness.get();
    }

    public void reset() {
        this.visible.reset();
        this.brightness.reset();
        this.setNegativeProbeLocation(this.negativeProbeX, this.defaultProbeY);
        this.setPositiveProbeLocation(this.positiveProbeX, this.defaultProbeY);
    }

    public void setLocation(double d, double d2) {
        this.location.setLocation(d, d2);
        for (IConductivityTester.ConductivityTesterChangeListener conductivityTesterChangeListener : this.conductivityTesterListeners) {
            conductivityTesterChangeListener.locationChanged();
        }
    }

    public void setBatteryRegion(Shape shape) {
        this.batteryRegion = shape;
    }

    public Shape getBatteryRegion() {
        return this.batteryRegion;
    }

    public void setBulbRegion(Shape shape) {
        this.bulbRegion = shape;
    }

    public Shape getBulbRegion() {
        return this.bulbRegion;
    }
}

