/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.model;

import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Beaker {
    private final double x;
    private final double y;
    private final double width;
    private final double height;
    private final double depth;
    public final double wallThickness;
    private final double topExtension = 0.0;
    private final double topDelta;

    public Beaker(double d, double d2, double d3, double d4, double d5, double d6) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
        this.depth = d5;
        this.wallThickness = d6;
        this.topDelta = d6 * 1.2;
    }

    public double getY() {
        return this.y;
    }

    public Shape getWallShape() {
        BasicStroke basicStroke = new BasicStroke((float)this.wallThickness);
        Shape shape = basicStroke.createStrokedShape(this.getWallPath(this.topDelta).getGeneralPath());
        return new Area(shape){
            {
                this.subtract(new Area(Beaker.this.getWallPath(Beaker.this.topDelta * 2.0).getGeneralPath()));
            }
        };
    }

    private DoubleGeneralPath getWallPath(final double d) {
        return new DoubleGeneralPath(this.x - d, this.y + this.height + 0.0 + d){
            {
                super(d4, d2);
                this.lineTo(Beaker.this.x, Beaker.this.y + Beaker.this.height + 0.0);
                this.lineTo(Beaker.this.x, Beaker.this.y);
                this.lineTo(Beaker.this.x + Beaker.this.width, Beaker.this.y);
                this.lineTo(Beaker.this.x + Beaker.this.width, Beaker.this.y + Beaker.this.height + 0.0);
                this.lineTo(Beaker.this.x + Beaker.this.width + d, Beaker.this.y + Beaker.this.height + 0.0 + d);
            }
        };
    }

    private Rectangle2D.Double toRectangle() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height + 0.0);
    }

    public double getHeightForVolume(double d) {
        return d / this.width / this.depth;
    }

    public Point2D getOutputFaucetAttachmentPoint() {
        return new Point2D.Double(this.x + this.width, this.y);
    }

    public double getMaxFluidVolume() {
        return this.width * this.height * this.depth;
    }

    public double getCenterX() {
        return this.toRectangle().getCenterX();
    }

    public double getTopY() {
        return this.y + this.height;
    }

    public double getHeight() {
        return this.height;
    }

    public double getX() {
        return this.x;
    }

    public double getWallThickness() {
        return this.wallThickness;
    }

    public double getMaxX() {
        return this.x + this.width;
    }

    public Line2D.Double getLeftWall() {
        return new Line2D.Double(this.x, this.y, this.x, this.y + this.height);
    }

    public Line2D.Double getRightWall() {
        return new Line2D.Double(this.getMaxX(), this.y, this.getMaxX(), this.y + this.height);
    }

    public double getWidth() {
        return this.width;
    }

    public Line2D.Double getFloor() {
        return new Line2D.Double(this.x, this.y, this.x + this.width, this.y);
    }

    public Rectangle2D.Double getWaterShape(double d, double d2) {
        return new Rectangle2D.Double(this.getX(), this.getY() + d, this.getWidth(), this.getHeightForVolume(d2));
    }
}

