/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.slider;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.common.piccolophet.nodes.slider.KnobNode;
import edu.colorado.phet.common.piccolophet.nodes.slider.SliderNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSliderNode
extends SliderNode {
    private PhetPPath trackNode;
    private KnobNode knobNode;
    protected PNode rootNode = new PNode();

    public HSliderNode(final double d, final double d2, final SettableProperty<Double> settableProperty, final ObservableProperty<Boolean> observableProperty) {
        super(d, d2, settableProperty);
        this.addChild(this.rootNode);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 200.0, 5.0);
        this.trackNode = new PhetPPath(double_, this.getTrackFillPaint(double_), new BasicStroke(1.0f), new GradientPaint(0.0f, 0.0f, Color.gray, 0.0f, 5.0f, Color.black, false));
        this.rootNode.addChild(this.trackNode);
        this.knobNode = new KnobNode(26.0, new KnobNode.ColorScheme(new Color(115, 217, 255))){
            {
                super(d4, colorScheme);
                observableProperty.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setEnabled(bl);
                    }
                });
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new PBasicInputEventHandler(){
                    private Point2D startPoint;
                    public Double startValue;

                    public void mousePressed(PInputEvent pInputEvent) {
                        super.mousePressed(pInputEvent);
                        this.startPoint = pInputEvent.getPositionRelativeTo(HSliderNode.this);
                        this.startValue = (Double)settableProperty.get();
                    }

                    public void mouseDragged(PInputEvent pInputEvent) {
                        Point2D point2D = pInputEvent.getPositionRelativeTo(HSliderNode.this);
                        ImmutableVector2D immutableVector2D = new ImmutableVector2D(this.startPoint, point2D);
                        ImmutableVector2D immutableVector2D2 = new ImmutableVector2D(1.0, 0.0);
                        double d = immutableVector2D.dot(immutableVector2D2);
                        double d2 = (d2 - d) / HSliderNode.this.trackNode.getFullBounds().getWidth() * d;
                        if (((Boolean)observableProperty.get()).booleanValue()) {
                            settableProperty.set(MathUtil.clamp(d, this.startValue + d2, d2));
                        }
                    }
                });
            }
        };
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                double d = HSliderNode.this.getViewX((Double)settableProperty.get());
                HSliderNode.this.knobNode.setOffset(d - HSliderNode.this.knobNode.getFullBounds().getWidth() / 2.0, HSliderNode.this.trackNode.getFullBounds().getCenterY() - HSliderNode.this.knobNode.getFullBounds().getHeight() / 2.0);
            }
        };
        settableProperty.addObserver(simpleObserver);
        Rectangle2D rectangle2D = this.getKnobRect(d);
        Rectangle2D rectangle2D2 = this.getKnobRect(d2);
        PhetPPath phetPPath = new PhetPPath(rectangle2D.createUnion(rectangle2D2), null, null, null){
            {
                this.setPickable(false);
                this.setChildrenPickable(false);
            }
        };
        this.rootNode.addChild(phetPPath);
        this.rootNode.addChild(this.knobNode);
        this.adjustOrigin();
    }

    private Rectangle2D getKnobRect(double d) {
        PBounds pBounds = this.knobNode.getFullBounds();
        double d2 = this.getViewX(d) - this.knobNode.getFullBounds().getWidth() / 2.0;
        double d3 = this.trackNode.getFullBounds().getHeight() / 2.0 - this.knobNode.getFullBounds().getHeight() / 2.0;
        ((Rectangle2D)pBounds).setRect(d2, d3, ((RectangularShape)pBounds).getWidth(), ((RectangularShape)pBounds).getHeight());
        return pBounds;
    }

    protected Paint getTrackFillPaint(Rectangle2D rectangle2D) {
        return new GradientPaint((float)rectangle2D.getMinX(), (float)rectangle2D.getCenterY(), Color.white, (float)rectangle2D.getWidth(), (float)rectangle2D.getCenterY(), Color.gray, false);
    }

    protected double getViewX(double d) {
        return new Function.LinearFunction(this.min, this.max, this.trackNode.getFullBounds().getMinX(), this.trackNode.getFullBounds().getMaxX()).evaluate(d);
    }

    public void addLabel(double d, PNode pNode) {
        pNode.setOffset(this.getViewX(d) - pNode.getFullBounds().getWidth() / 2.0, this.knobNode.getFullBounds().getMaxY());
        float f = 1.5f;
        PhetPPath phetPPath = new PhetPPath(new Line2D.Double(this.getViewX(d) - (double)(f / 2.0f), 0.0, this.getViewX(d) - (double)(f / 2.0f), this.knobNode.getFullBounds().getHeight() / 2.0 + 3.0), (Stroke)new BasicStroke(f), (Paint)Color.darkGray);
        this.rootNode.addChild(phetPPath);
        this.rootNode.addChild(pNode);
        phetPPath.moveToBack();
        this.adjustOrigin();
    }

    protected void adjustOrigin() {
        this.removeAllChildren();
        this.addChild(new ZeroOffsetNode(this.rootNode));
    }
}

