/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.periodictable;

import edu.colorado.phet.common.piccolophet.nodes.periodictable.CellFactory;
import edu.colorado.phet.common.piccolophet.nodes.periodictable.ElementCell;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Point;

public class PeriodicTableNode
extends PNode {
    public PeriodicTableNode(Color color, CellFactory cellFactory) {
        int n;
        PNode pNode = new PNode();
        for (n = 1; n <= 56; ++n) {
            this.addElement(pNode, n, cellFactory, color);
        }
        this.addElement(pNode, 57, cellFactory, color);
        for (n = 72; n <= 88; ++n) {
            this.addElement(pNode, n, cellFactory, color);
        }
        this.addElement(pNode, 89, cellFactory, color);
        for (n = 104; n <= 112; ++n) {
            this.addElement(pNode, n, cellFactory, color);
        }
        for (n = 0; n < pNode.getChildrenCount(); ++n) {
            PNode pNode2 = pNode.getChild(n);
            if (!(pNode2 instanceof ElementCell)) continue;
            ((ElementCell)pNode2).tableInitComplete();
        }
        this.addChild(pNode);
    }

    private void addElement(PNode pNode, int n, CellFactory cellFactory, Color color) {
        ElementCell elementCell = cellFactory.createCellForElement(n, color);
        Point point = this.getPeriodicTableGridPoint(n);
        double d = (point.getY() - 1.0) * 20.0;
        double d2 = (point.getX() - 1.0) * 20.0;
        elementCell.setOffset(d, d2);
        pNode.addChild(elementCell);
    }

    private Point getPeriodicTableGridPoint(int n) {
        if (n == 1) {
            return new Point(1, 1);
        }
        if (n == 2) {
            return new Point(1, 18);
        }
        if (n == 3) {
            return new Point(2, 1);
        }
        if (n == 4) {
            return new Point(2, 2);
        }
        if (n >= 5 && n <= 10) {
            return new Point(2, n + 8);
        }
        if (n == 11) {
            return new Point(3, 1);
        }
        if (n == 12) {
            return new Point(3, 2);
        }
        if (n >= 13 && n <= 18) {
            return new Point(3, n);
        }
        if (n >= 19 && n <= 36) {
            return new Point(4, n - 18);
        }
        if (n >= 37 && n <= 54) {
            return new Point(5, n - 36);
        }
        if (n == 55) {
            return new Point(6, 1);
        }
        if (n == 56) {
            return new Point(6, 2);
        }
        if (n >= 57 && n <= 71) {
            return new Point(6, 3);
        }
        if (n >= 72 && n <= 86) {
            return new Point(6, n - 68);
        }
        if (n == 87) {
            return new Point(7, 1);
        }
        if (n == 88) {
            return new Point(7, 2);
        }
        if (n >= 89 && n <= 103) {
            return new Point(7, 3);
        }
        if (n >= 104 && n <= 118) {
            return new Point(7, n - 100);
        }
        return new Point(1, 1);
    }
}

