/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.kit;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.nodes.kit.BackButton;
import edu.colorado.phet.common.piccolophet.nodes.kit.ForwardButton;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KitControlNode
extends PNode {
    public KitControlNode(int n, Property<Integer> property, Option<PNode> option, double d) {
        this(n, property, option, d, Color.orange);
    }

    public KitControlNode(final int n, final Property<Integer> property, Option<PNode> option, double d, Color color) {
        final ForwardButton forwardButton = new ForwardButton(color){
            {
                super(color);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        property.set((Integer)property.get() + 1);
                    }
                });
                property.addObserver(new VoidFunction1<Integer>(){

                    @Override
                    public void apply(Integer n) {
                        this.setEnabled((Integer)property.get() < n - 1);
                    }
                });
            }
        };
        this.addChild(forwardButton);
        BackButton backButton = new BackButton(color){
            {
                super(color);
                if (this.getFullBounds().getMaxX() > forwardButton.getFullBounds().getMinX()) {
                    this.setOffset(forwardButton.getFullBounds().getMinX() - 2.0, this.getOffset().getY());
                }
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        property.set((Integer)property.get() - 1);
                    }
                });
                property.addObserver(new VoidFunction1<Integer>(){

                    @Override
                    public void apply(Integer n) {
                        this.setEnabled((Integer)property.get() > 0);
                    }
                });
            }
        };
        this.addChild(backButton);
        if (option.isSome()) {
            PNode pNode = option.get();
            this.addChild(pNode);
            pNode.setOffset(backButton.getFullBounds().getMaxX() + d, backButton.getFullBounds().getCenterY() - pNode.getFullBounds().getHeight() / 2.0);
            forwardButton.setOffset(pNode.getFullBounds().getMaxX() + d, 0.0);
        } else {
            forwardButton.setOffset(backButton.getFullBounds().getMaxX() + d * 2.0, 0.0);
        }
        if (n == 1) {
            backButton.setVisible(false);
            backButton.setPickable(false);
            backButton.setChildrenPickable(false);
            forwardButton.setVisible(false);
            forwardButton.setPickable(false);
            forwardButton.setChildrenPickable(false);
        }
    }
}

