/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.faucet;

import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.view.Dimension2DDouble;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.faucet.FaucetSliderNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaucetNode
extends PNode {
    public static final BufferedImage FAUCET_FRONT = PiccoloPhetApplication.RESOURCES.getImage("faucet_front.png");
    public static final BufferedImage FAUCET_PIPE = PiccoloPhetApplication.RESOURCES.getImage("faucet_pipe.png");
    private final double inputPipeY1 = 32.0;
    private final double inputPipeY2 = 77.0;
    private final double inputPipeX = 0.0;
    private final double outputPipeX1 = 57.0;
    private final double outputPipeX2 = 109.0;
    private final double outputPipeY = 133.0;
    public final PImage faucetImageNode;
    public final FaucetSliderNode faucetSliderNode;

    public FaucetNode(Property<Double> property, ObservableProperty<Boolean> observableProperty, final double d, boolean bl) {
        this.faucetSliderNode = new FaucetSliderNode(observableProperty, property, bl){
            {
                this.setOffset(6.0, 2.5);
            }
        };
        this.faucetImageNode = new PImage(FAUCET_FRONT){
            {
                super(image);
                this.setScale(1.2);
                this.addChild(FaucetNode.this.faucetSliderNode);
                Rectangle2D.Double double_ = new Rectangle2D.Double(-d + 1.0, 31.5, d, 46.5);
                this.addChild(new PhetPPath((Shape)double_, (Paint)new TexturePaint(FAUCET_PIPE, new Rectangle2D.Double(0.0, double_.getY(), FAUCET_PIPE.getWidth(), FAUCET_PIPE.getHeight()))));
            }
        };
        this.addChild(this.faucetImageNode);
    }

    public Point2D getInputGlobalViewPoint() {
        return this.faucetImageNode.localToGlobal(new Point2D.Double(0.0, 54.5));
    }

    public Point2D getOutputGlobalViewPoint() {
        return this.faucetImageNode.localToGlobal(new Point2D.Double(83.0, 133.0));
    }

    public Dimension2D getGlobalFaucetWidthDimension() {
        return this.faucetImageNode.localToGlobal(new Dimension2DDouble(52.0, 0.0));
    }
}

