/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.jmolphet;

import edu.colorado.phet.common.jmolphet.Molecule;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolViewer;
import org.jmol.util.Logger;

public class JmolPanel
extends JPanel {
    private JmolViewer viewer = null;
    private final JLabel loadingText;

    public JmolPanel(final Molecule molecule, String string) {
        super(new GridBagLayout());
        this.loadingText = new JLabel(string){
            {
                this.setFont(new PhetFont(20));
                this.setForeground(Color.WHITE);
            }
        };
        this.add((Component)this.loadingText, new GridBagConstraints());
        final JPanel jPanel = new JPanel(){

            public void paint(Graphics graphics) {
                Dimension dimension = new Dimension();
                this.getSize(dimension);
                Rectangle rectangle = new Rectangle();
                graphics.getClipBounds(rectangle);
                JmolPanel.this.viewer.renderScreenImage(graphics, dimension, rectangle);
            }

            public boolean isShowing() {
                return true;
            }
        };
        Logger.setLogLevel(3);
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                JmolViewer jmolViewer = JmolViewer.allocateViewer(jPanel, new SmarterJmolAdapter(), null, null, null, "-applet", null);
                jmolViewer.setBooleanProperty("antialiasDisplay", true);
                jmolViewer.setBooleanProperty("autoBond", false);
                String string = jmolViewer.openStringInline(molecule.getData());
                if (string != null) {
                    throw new RuntimeException("Jmol problem: " + string);
                }
                molecule.fixJmolColors(jmolViewer);
                JmolPanel.this.viewer = jmolViewer;
                JmolPanel.this.doScript("unbind \"_popupMenu\"");
                JmolPanel.this.doScript("frank off");
                JmolPanel.this.setSpaceFill();
                jmolViewer.scriptWait("spin on");
                while (jmolViewer.isScriptExecuting()) {
                    try {
                        System.out.println("Waiting...");
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            JmolPanel.this.remove(JmolPanel.this.loadingText);
                            JmolPanel.this.setLayout(new GridLayout(1, 1));
                            JmolPanel.this.add(jPanel);
                            JmolPanel.this.validate();
                            JmolPanel.this.repaint();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            }
        }.start();
        this.setBackground(Color.BLACK);
        this.setPreferredSize(new Dimension(400, 400));
        this.repaint();
        this.paintImmediately(this.getBounds());
    }

    private void doScript(String string) {
        this.viewer.script(string);
    }

    public void setSpaceFill() {
        this.doScript("wireframe off; spacefill 60%");
    }

    public void setBallAndStick() {
        this.doScript("wireframe 0.2; spacefill 25%");
    }

    public JLabel getLoadingText() {
        return this.loadingText;
    }
}

