/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.view.instruments;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.LiquidExpansionThermometerNode;
import edu.colorado.phet.statesofmatter.StatesOfMatterStrings;
import edu.colorado.phet.statesofmatter.view.TemperatureUnits;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeThermometerNode
extends PNode {
    private final LiquidExpansionThermometerNode m_liquidThermometer;
    private final double m_maxTemp;
    private final DigitalReadoutNode m_digitalReadout;

    public CompositeThermometerNode(double d, double d2, double d3, Property<TemperatureUnits> property) {
        this.m_maxTemp = d3;
        this.m_digitalReadout = new DigitalReadoutNode(d, property.get());
        this.addChild(this.m_digitalReadout);
        this.m_liquidThermometer = new LiquidExpansionThermometerNode(new PDimension(d * 0.38 / 20.0, d2 / 20.0));
        this.m_liquidThermometer.setTicks(d2 / 10.0 / 20.0, Color.BLACK, (float)d2 / 3500.0f);
        this.m_liquidThermometer.scale(20.0);
        this.m_liquidThermometer.setOffset(0.0, this.m_digitalReadout.getFullBoundsReference().height * 1.1);
        this.addChild(this.m_liquidThermometer);
        property.addObserver(new VoidFunction1<TemperatureUnits>(){

            @Override
            public void apply(TemperatureUnits temperatureUnits) {
                CompositeThermometerNode.this.m_digitalReadout.setTemperatureUnits(temperatureUnits);
            }
        });
    }

    public void setTemperatureInDegreesKelvin(double d) {
        this.m_digitalReadout.setValueKelvin(d);
        this.m_liquidThermometer.setLiquidHeight(Math.min(d / this.m_maxTemp, 1.0));
    }

    private class DigitalReadoutNode
    extends PNode {
        private final Color BACKGROUND_COLOR = Color.YELLOW;
        private final Color FOREGROUND_COLOR = Color.WHITE;
        private final DecimalFormat numberFormatter = new DecimalFormat("##0");
        private TemperatureUnits m_temperatureUnits = TemperatureUnits.KELVIN;
        private double m_valueInKelvin = 0.0;
        private final PText m_text;
        private String m_units;
        private final PPath m_foregroundNode;
        private double m_defaultTextScale = 1.0;

        public DigitalReadoutNode(double d, TemperatureUnits temperatureUnits) {
            double d2 = d / 2.2;
            PPath pPath = new PPath(new RoundRectangle2D.Double(0.0, 0.0, d, d2, d2 / 5.0, d2 / 5.0));
            pPath.setPaint(this.BACKGROUND_COLOR);
            this.addChild(pPath);
            double d3 = d * 0.050000000000000044;
            this.m_foregroundNode = new PPath(new RoundRectangle2D.Double(0.0, 0.0, d - d3 * 2.0, d2 - d3 * 2.0, d2 / 5.0, d2 / 5.0));
            this.m_foregroundNode.setPaint(this.FOREGROUND_COLOR);
            this.addChild(this.m_foregroundNode);
            this.m_foregroundNode.setOffset(d3, d3);
            this.m_text = new PText("0");
            this.m_text.setFont(new PhetFont(12, true));
            this.m_defaultTextScale = this.m_foregroundNode.getFullBoundsReference().height * 0.8 / this.m_text.getFullBoundsReference().height;
            this.addChild(this.m_text);
            this.setTemperatureUnits(temperatureUnits);
            this.update();
        }

        public void setTemperatureUnits(TemperatureUnits temperatureUnits) {
            assert (temperatureUnits == TemperatureUnits.KELVIN || temperatureUnits == TemperatureUnits.CELSIUS);
            this.m_temperatureUnits = temperatureUnits;
            switch (this.m_temperatureUnits) {
                case KELVIN: {
                    this.m_units = StatesOfMatterStrings.UNITS_K;
                    break;
                }
                case CELSIUS: {
                    this.m_units = StatesOfMatterStrings.UNITS_C;
                    break;
                }
                default: {
                    assert (false);
                    this.m_units = "X";
                }
            }
            this.update();
        }

        public void setValueKelvin(double d) {
            this.m_valueInKelvin = d;
            this.update();
        }

        private void update() {
            String string = this.m_temperatureUnits == TemperatureUnits.CELSIUS ? this.numberFormatter.format(Math.round(this.m_valueInKelvin - 273.15)) : this.numberFormatter.format(Math.round(this.m_valueInKelvin));
            if (this.m_units != null) {
                string = string + " ";
                string = string + this.m_units;
            }
            this.m_text.setScale(this.m_defaultTextScale);
            this.m_text.setText(string);
            if (this.m_text.getFullBoundsReference().width > this.m_foregroundNode.getFullBoundsReference().width * 0.95) {
                this.m_text.setScale(1.0);
                this.m_text.setScale(this.m_foregroundNode.getFullBoundsReference().width * 0.95 / this.m_text.getFullBoundsReference().width);
            }
            this.m_text.setOffset(this.m_foregroundNode.getFullBoundsReference().getCenterX() - this.m_text.getFullBoundsReference().width / 2.0, this.m_foregroundNode.getFullBoundsReference().getCenterY() - this.m_text.getFullBoundsReference().height / 2.0);
        }
    }
}

