/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.view;

import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.phetcommon.view.graphics.RoundGradientPaint;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.piccolophet.nodes.SphericalNode;
import edu.colorado.phet.statesofmatter.model.particle.ArgonAtom;
import edu.colorado.phet.statesofmatter.model.particle.ConfigurableStatesOfMatterAtom;
import edu.colorado.phet.statesofmatter.model.particle.HydrogenAtom;
import edu.colorado.phet.statesofmatter.model.particle.HydrogenAtom2;
import edu.colorado.phet.statesofmatter.model.particle.NeonAtom;
import edu.colorado.phet.statesofmatter.model.particle.OxygenAtom;
import edu.colorado.phet.statesofmatter.model.particle.StatesOfMatterAtom;
import edu.colorado.phet.statesofmatter.view.ModelViewTransform;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class ParticleNode
extends PNode {
    private static final Stroke STROKE = new BasicStroke(20.0f);
    protected StatesOfMatterAtom m_particle;
    private ModelViewTransform m_mvt;
    private Point2D.Double m_position;
    private SphericalNode m_sphere;
    private boolean m_useGradient = false;
    private boolean m_overlapEnabled = false;

    public ParticleNode(StatesOfMatterAtom statesOfMatterAtom, ModelViewTransform modelViewTransform) {
        this(statesOfMatterAtom, modelViewTransform, false, false, false);
    }

    public ParticleNode(StatesOfMatterAtom statesOfMatterAtom, ModelViewTransform modelViewTransform, boolean bl, boolean bl2, boolean bl3) {
        if (modelViewTransform == null || statesOfMatterAtom == null) {
            throw new IllegalArgumentException();
        }
        this.m_particle = statesOfMatterAtom;
        this.m_mvt = modelViewTransform;
        this.m_useGradient = bl;
        this.m_overlapEnabled = bl3;
        this.m_position = new Point2D.Double();
        statesOfMatterAtom.addListener(new StatesOfMatterAtom.Adapter(){

            public void positionChanged() {
                ParticleNode.this.updatePosition();
            }

            public void particleRemoved(StatesOfMatterAtom statesOfMatterAtom) {
                ParticleNode.this.handleParticleRemoved();
            }

            public void radiusChanged() {
                ParticleNode.this.handleParticleRadiusChanged();
            }
        });
        double d = statesOfMatterAtom.getRadius() * 2.0;
        if (this.m_overlapEnabled) {
            d *= 1.25;
        }
        this.m_sphere = new SphericalNode(d, this.choosePaint(statesOfMatterAtom), bl);
        this.addChild(this.m_sphere);
        this.setStrokeEnabled(bl2);
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.updatePosition();
    }

    public boolean getGradientEnabled() {
        return this.m_useGradient;
    }

    public void setGradientEnabled(boolean bl) {
        if (this.m_useGradient != bl) {
            this.m_useGradient = bl;
            if (this.m_useGradient) {
                this.m_sphere.setConvertToImage(true);
                this.m_sphere.setPaint(this.choosePaint(this.m_particle));
            } else {
                this.m_sphere.setConvertToImage(false);
                this.m_sphere.setPaint(this.chooseColor(this.m_particle));
            }
        }
    }

    public void setStrokeEnabled(boolean bl) {
        if (bl) {
            this.m_sphere.setStroke(STROKE);
            this.m_sphere.setStrokePaint(Color.BLACK);
        } else {
            this.m_sphere.setStroke(null);
            this.m_sphere.setStrokePaint(null);
        }
    }

    private void updatePosition() {
        if (this.m_particle != null) {
            this.m_mvt.modelToView(this.m_particle.getPositionReference(), this.m_position);
            this.setOffset(this.m_position);
        }
    }

    private void handleParticleRemoved() {
        PNode pNode = this.getParent();
        if (pNode != null) {
            pNode.removeChild(this);
        }
        this.removeAllChildren();
        this.m_particle = null;
    }

    protected void handleParticleRadiusChanged() {
        if (this.m_useGradient) {
            this.m_sphere.setPaint(this.choosePaint(this.m_particle));
        }
        double d = this.m_particle.getRadius() * 2.0;
        if (this.m_overlapEnabled) {
            d *= 1.25;
        }
        this.m_sphere.setDiameter(d);
    }

    protected Paint choosePaint(StatesOfMatterAtom statesOfMatterAtom) {
        Color color = this.chooseColor(statesOfMatterAtom);
        Color color2 = ColorUtils.darkerColor(color, 0.9);
        Color color3 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), 20);
        if (this.m_useGradient) {
            double d = this.m_overlapEnabled ? statesOfMatterAtom.getRadius() * 1.25 : statesOfMatterAtom.getRadius();
            return new RoundGradientPaint(0.0, 0.0, color, new Point2D.Double(-d, d), color3);
        }
        return color;
    }

    protected Color chooseColor(StatesOfMatterAtom statesOfMatterAtom) {
        Color color = statesOfMatterAtom instanceof ArgonAtom ? Color.pink : (statesOfMatterAtom instanceof NeonAtom ? new Color(112, 212, 255) : (statesOfMatterAtom instanceof OxygenAtom ? PhetColorScheme.RED_COLORBLIND : (statesOfMatterAtom instanceof HydrogenAtom ? Color.WHITE : (statesOfMatterAtom instanceof HydrogenAtom2 ? Color.WHITE : (statesOfMatterAtom instanceof ConfigurableStatesOfMatterAtom ? new Color(204, 102, 204) : Color.PINK)))));
        return color;
    }
}

