/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.module.phasechanges;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.AbstractSlider;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.AbstractValueControl;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.ILayoutStrategy;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.statesofmatter.StatesOfMatterConstants;
import edu.colorado.phet.statesofmatter.StatesOfMatterResources;
import edu.colorado.phet.statesofmatter.StatesOfMatterStrings;
import edu.colorado.phet.statesofmatter.model.MultipleParticleModel;
import edu.colorado.phet.statesofmatter.module.CloseRequestListener;
import edu.colorado.phet.statesofmatter.module.phasechanges.EpsilonControlInteractionPotentialDiagram;
import edu.colorado.phet.statesofmatter.module.phasechanges.PhaseChangesModule;
import edu.colorado.phet.statesofmatter.module.phasechanges.PhaseDiagram;
import edu.colorado.phet.statesofmatter.module.solidliquidgas.MoleculeImageLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PhaseChangesControlPanel
extends ControlPanel {
    private static final Font BUTTON_LABEL_FONT = new PhetFont(14);
    private static final Color ENABLED_TITLE_COLOR = Color.BLACK;
    private final MultipleParticleModel m_model;
    private final JPanel m_phaseDiagramPanel;
    private boolean m_phaseDiagramVisible;
    private final JButton m_phaseDiagramCtrlButton;
    private final PhaseDiagram m_phaseDiagram;
    private MoleculeSelectionPanel m_moleculeSelectionPanel;
    private final JPanel m_interactionDiagramPanel;
    private boolean m_interactionDiagramVisible;
    private final JButton m_interactionDiagramCtrlButton;
    private EpsilonControlInteractionPotentialDiagram m_interactionPotentialDiagram;
    private final InteractionStrengthControlPanel m_interactionStrengthControlPanel;
    private final JPanel m_preInteractionButtonSpacer;
    private final JPanel m_postInteractionButtonSpacer;
    private final JPanel m_prePhaseButtonSpacer;
    private final JPanel m_postPhaseButtonSpacer;
    private final boolean m_advanced;
    private final List<Double> m_modelTemperatureHistory = new ArrayList<Double>(100);

    public PhaseChangesControlPanel(PhaseChangesModule phaseChangesModule, boolean bl) {
        this.m_model = phaseChangesModule.getMultiParticleModel();
        this.m_advanced = bl;
        this.m_phaseDiagramVisible = bl;
        this.m_interactionDiagramVisible = bl;
        this.m_model.getClock().addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                PhaseChangesControlPanel.this.updatePhaseDiagram();
            }
        });
        this.m_model.addListener(new MultipleParticleModel.Adapter(){

            public void moleculeTypeChanged() {
                PhaseChangesControlPanel.this.m_interactionPotentialDiagram.setLjPotentialParameters(PhaseChangesControlPanel.this.m_model.getSigma(), PhaseChangesControlPanel.this.m_model.getEpsilon());
                PhaseChangesControlPanel.this.m_moleculeSelectionPanel.setMolecule(PhaseChangesControlPanel.this.m_model.getMoleculeType());
                PhaseChangesControlPanel.this.m_modelTemperatureHistory.clear();
            }

            public void resetOccurred() {
                PhaseChangesControlPanel.this.m_phaseDiagramVisible = PhaseChangesControlPanel.this.m_advanced;
                PhaseChangesControlPanel.this.m_interactionDiagramVisible = PhaseChangesControlPanel.this.m_advanced;
                PhaseChangesControlPanel.this.m_modelTemperatureHistory.clear();
                PhaseChangesControlPanel.this.updateVisibilityStates();
            }
        });
        int n = StatesOfMatterResources.getInt("int.minControlPanelWidth", 215);
        this.setMinimumWidth(n);
        this.m_moleculeSelectionPanel = new MoleculeSelectionPanel(bl);
        this.addControlFullWidth(this.m_moleculeSelectionPanel);
        this.m_interactionStrengthControlPanel = new InteractionStrengthControlPanel(this.m_model);
        this.addControlFullWidth(this.m_interactionStrengthControlPanel);
        this.addVerticalSpace(10);
        this.m_preInteractionButtonSpacer = this.createVerticalSpacerPanel(20);
        this.addControlFullWidth(this.m_preInteractionButtonSpacer);
        this.m_preInteractionButtonSpacer.setVisible(!this.m_interactionDiagramVisible);
        this.m_interactionDiagramCtrlButton = new JButton();
        this.m_interactionDiagramCtrlButton.setFont(BUTTON_LABEL_FONT);
        this.m_interactionDiagramCtrlButton.setText(StatesOfMatterStrings.INTERACTION_POTENTIAL_BUTTON_LABEL);
        this.addControl(this.m_interactionDiagramCtrlButton);
        this.m_interactionDiagramCtrlButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhaseChangesControlPanel.this.m_interactionDiagramVisible = true;
                PhaseChangesControlPanel.this.updateVisibilityStates();
            }
        });
        this.m_interactionDiagramCtrlButton.setVisible(!this.m_interactionDiagramVisible);
        double d = this.m_interactionDiagramCtrlButton.getPreferredSize().getWidth();
        double d2 = this.m_interactionDiagramCtrlButton.getPreferredSize().getHeight();
        this.m_postInteractionButtonSpacer = this.createVerticalSpacerPanel(20);
        this.addControlFullWidth(this.m_postInteractionButtonSpacer);
        this.m_postInteractionButtonSpacer.setVisible(!this.m_interactionDiagramVisible);
        this.m_interactionDiagramPanel = new JPanel();
        PhetPCanvas phetPCanvas = new PhetPCanvas();
        phetPCanvas.setPreferredSize(new Dimension(200, 160));
        phetPCanvas.setBackground(StatesOfMatterConstants.CONTROL_PANEL_COLOR);
        phetPCanvas.setBorder(null);
        this.m_interactionPotentialDiagram = new EpsilonControlInteractionPotentialDiagram(this.m_model.getSigma(), this.m_model.getEpsilon(), false, this.m_model);
        this.m_interactionPotentialDiagram.setBackgroundColor(StatesOfMatterConstants.CONTROL_PANEL_COLOR);
        phetPCanvas.addWorldChild(this.m_interactionPotentialDiagram);
        this.m_interactionDiagramPanel.add(phetPCanvas);
        this.addControlFullWidth(this.m_interactionDiagramPanel);
        this.m_interactionDiagramPanel.setVisible(this.m_interactionDiagramVisible);
        CloseRequestListener closeRequestListener = new CloseRequestListener(){

            public void closeRequestReceived() {
                PhaseChangesControlPanel.this.m_interactionDiagramVisible = false;
                PhaseChangesControlPanel.this.updateVisibilityStates();
            }
        };
        this.m_interactionPotentialDiagram.addListener(closeRequestListener);
        this.m_prePhaseButtonSpacer = this.createVerticalSpacerPanel(20);
        this.addControlFullWidth(this.m_prePhaseButtonSpacer);
        this.m_prePhaseButtonSpacer.setVisible(!this.m_phaseDiagramVisible);
        this.m_phaseDiagramCtrlButton = new JButton();
        this.m_phaseDiagramCtrlButton.setFont(BUTTON_LABEL_FONT);
        this.m_phaseDiagramCtrlButton.setText(StatesOfMatterStrings.PHASE_DIAGRAM_BUTTON_LABEL);
        this.addControl(this.m_phaseDiagramCtrlButton);
        this.m_phaseDiagramCtrlButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhaseChangesControlPanel.this.m_phaseDiagramVisible = true;
                PhaseChangesControlPanel.this.updateVisibilityStates();
            }
        });
        this.m_phaseDiagramCtrlButton.setVisible(!this.m_phaseDiagramVisible);
        d = Math.max(d, this.m_phaseDiagramCtrlButton.getPreferredSize().getWidth());
        d2 = Math.max(d2, this.m_phaseDiagramCtrlButton.getPreferredSize().getHeight());
        Dimension dimension = new Dimension((int)Math.round(d), (int)Math.round(d2));
        this.m_phaseDiagramCtrlButton.setPreferredSize(dimension);
        this.m_interactionDiagramCtrlButton.setPreferredSize(dimension);
        this.m_postPhaseButtonSpacer = this.createVerticalSpacerPanel(20);
        this.addControlFullWidth(this.m_postPhaseButtonSpacer);
        this.m_postInteractionButtonSpacer.setVisible(!this.m_phaseDiagramVisible);
        this.m_phaseDiagramPanel = new JPanel();
        this.m_phaseDiagram = new PhaseDiagram();
        this.m_phaseDiagramPanel.add(this.m_phaseDiagram);
        this.addControlFullWidth(this.m_phaseDiagramPanel);
        this.m_phaseDiagramPanel.setVisible(this.m_phaseDiagramVisible);
        CloseRequestListener closeRequestListener2 = new CloseRequestListener(){

            public void closeRequestReceived() {
                PhaseChangesControlPanel.this.m_phaseDiagramVisible = false;
                PhaseChangesControlPanel.this.updateVisibilityStates();
            }
        };
        this.m_phaseDiagram.addListener(closeRequestListener2);
        this.updateVisibilityStates();
    }

    private void updatePhaseDiagram() {
        if (this.m_model.getContainerExploded()) {
            this.m_phaseDiagram.setStateMarkerVisible(false);
        } else {
            this.m_phaseDiagram.setStateMarkerVisible(true);
            double d = this.updateMovingAverageTemperature(this.m_model.getTemperatureSetPoint());
            double d2 = this.m_model.getModelPressure();
            double d3 = this.mapModelTemperatureToPhaseDiagramTemperature(d);
            double d4 = this.mapModelTempAndPressureToPhaseDiagramPressureAlternative1(d2, d);
            this.m_phaseDiagram.setStateMarkerPos(d3, d4);
        }
    }

    private double updateMovingAverageTemperature(double d) {
        if (this.m_modelTemperatureHistory.size() == 100) {
            this.m_modelTemperatureHistory.remove(0);
        }
        this.m_modelTemperatureHistory.add(d);
        double d2 = 0.0;
        for (Double d3 : this.m_modelTemperatureHistory) {
            d2 += d3.doubleValue();
        }
        return d2 / (double)this.m_modelTemperatureHistory.size();
    }

    private double mapModelTemperatureToPhaseDiagramTemperature(double d) {
        double d2 = d < 0.26 ? 1.4423076923076923 * d : d * 0.7870370370370371 + 0.17037037037037034;
        return Math.min(d2, 1.0);
    }

    private double mapModelTempAndPressureToPhaseDiagramPressureAlternative1(double d, double d2) {
        double d3 = 0.35;
        double d4 = this.mapModelTemperatureToPhaseDiagramTemperature(d2);
        double d5 = d4 < d3 ? Math.pow(d4, 1.5) : Math.pow(d4 - d3, 1.8) + 0.2;
        return Math.min(d5, 1.0);
    }

    private JPanel createVerticalSpacerPanel(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Can't have zero or negative space in spacer panel.");
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(n));
        return jPanel;
    }

    private void updateVisibilityStates() {
        this.m_interactionDiagramPanel.setVisible(this.m_interactionDiagramVisible && this.m_advanced);
        this.m_interactionDiagramCtrlButton.setVisible(!this.m_interactionDiagramVisible && this.m_advanced);
        this.m_preInteractionButtonSpacer.setVisible(!this.m_interactionDiagramVisible);
        this.m_postInteractionButtonSpacer.setVisible(!this.m_interactionDiagramVisible);
        boolean bl = this.m_model.getMoleculeType() == 6;
        this.m_interactionStrengthControlPanel.setVisible(bl);
        if (bl) {
            this.m_phaseDiagramPanel.setVisible(false);
            this.m_phaseDiagramCtrlButton.setVisible(false);
            this.m_preInteractionButtonSpacer.setVisible(false);
            this.m_postInteractionButtonSpacer.setVisible(false);
        } else {
            this.m_phaseDiagramPanel.setVisible(this.m_phaseDiagramVisible);
            this.m_phaseDiagramCtrlButton.setVisible(!this.m_phaseDiagramVisible);
            this.m_prePhaseButtonSpacer.setVisible(!this.m_phaseDiagramVisible);
            this.m_postPhaseButtonSpacer.setVisible(!this.m_phaseDiagramVisible);
        }
    }

    private class InteractionStrengthControlPanel
    extends JPanel {
        private final Font LABEL_FONT = new PhetFont(14, false);
        private final LinearValueControl m_interactionStrengthControl;
        private final MultipleParticleModel m_model;
        private final TitledBorder m_titledBorder;
        private final JLabel m_leftLabel;
        private final JLabel m_rightLabel;

        public InteractionStrengthControlPanel(MultipleParticleModel multipleParticleModel) {
            this.m_model = multipleParticleModel;
            this.setLayout(new GridLayout(0, 1));
            BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
            this.m_titledBorder = BorderFactory.createTitledBorder(bevelBorder, StatesOfMatterStrings.INTERACTION_STRENGTH_CONTROL_TITLE, 1, 2, new PhetFont(1, 14), ENABLED_TITLE_COLOR);
            this.setBorder(this.m_titledBorder);
            this.m_interactionStrengthControl = new LinearValueControl(49.199999999999996, 200.0, "", "0", "", new SliderLayoutStrategy());
            this.m_interactionStrengthControl.setUpDownArrowDelta(0.01);
            this.m_interactionStrengthControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (InteractionStrengthControlPanel.this.m_model.getMoleculeType() == 6) {
                        InteractionStrengthControlPanel.this.m_model.setEpsilon(InteractionStrengthControlPanel.this.m_interactionStrengthControl.getValue());
                    }
                }
            });
            this.m_interactionStrengthControl.getSlider().addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }
            });
            Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
            this.m_leftLabel = new JLabel(StatesOfMatterStrings.INTERACTION_STRENGTH_WEAK);
            this.m_leftLabel.setFont(this.LABEL_FONT);
            hashtable.put(this.m_interactionStrengthControl.getMinimum(), this.m_leftLabel);
            this.m_rightLabel = new JLabel(StatesOfMatterStrings.INTERACTION_STRENGTH_STRONG);
            this.m_rightLabel.setFont(this.LABEL_FONT);
            hashtable.put(this.m_interactionStrengthControl.getMaximum(), this.m_rightLabel);
            this.m_interactionStrengthControl.setTickLabels(hashtable);
            this.m_model.addListener(new MultipleParticleModel.Adapter(){

                public void interactionStrengthChanged() {
                    double d = InteractionStrengthControlPanel.this.m_model.getEpsilon();
                    d = Math.min(d, 200.0);
                    d = Math.max(d, 49.199999999999996);
                    InteractionStrengthControlPanel.this.m_interactionStrengthControl.setValue(d);
                    PhaseChangesControlPanel.this.updatePhaseDiagram();
                }
            });
            this.add(this.m_interactionStrengthControl);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.m_interactionStrengthControl.setEnabled(bl);
            this.m_leftLabel.setEnabled(bl);
            this.m_rightLabel.setEnabled(bl);
            if (bl) {
                this.m_titledBorder.setTitleColor(ENABLED_TITLE_COLOR);
            } else {
                this.m_titledBorder.setTitleColor(Color.LIGHT_GRAY);
            }
        }
    }

    private class MoleculeSelectionPanel
    extends JPanel {
        private final JRadioButton m_neonRadioButton;
        private final JRadioButton m_argonRadioButton;
        private final JRadioButton m_oxygenRadioButton;
        private final JRadioButton m_waterRadioButton;
        private final JRadioButton m_configurableRadioButton;

        MoleculeSelectionPanel(boolean bl) {
            BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, StatesOfMatterStrings.MOLECULE_TYPE_SELECT_LABEL, 1, 2, new PhetFont(1, 14), Color.BLACK);
            this.setBorder(titledBorder);
            this.m_oxygenRadioButton = new MoleculeSelectorButton(StatesOfMatterStrings.OXYGEN_SELECTION_LABEL, PhaseChangesControlPanel.this.m_model, 4, true);
            final MoleculeImageLabel moleculeImageLabel = new MoleculeImageLabel(4, PhaseChangesControlPanel.this.m_model);
            this.m_neonRadioButton = new MoleculeSelectorButton(StatesOfMatterStrings.NEON_SELECTION_LABEL, PhaseChangesControlPanel.this.m_model, 1, false);
            final MoleculeImageLabel moleculeImageLabel2 = new MoleculeImageLabel(1, PhaseChangesControlPanel.this.m_model);
            this.m_argonRadioButton = new MoleculeSelectorButton(StatesOfMatterStrings.ARGON_SELECTION_LABEL, PhaseChangesControlPanel.this.m_model, 2, false);
            final MoleculeImageLabel moleculeImageLabel3 = new MoleculeImageLabel(2, PhaseChangesControlPanel.this.m_model);
            this.m_waterRadioButton = new MoleculeSelectorButton(StatesOfMatterStrings.WATER_SELECTION_LABEL, PhaseChangesControlPanel.this.m_model, 5, true);
            final MoleculeImageLabel moleculeImageLabel4 = new MoleculeImageLabel(5, PhaseChangesControlPanel.this.m_model);
            this.m_configurableRadioButton = new MoleculeSelectorButton(StatesOfMatterStrings.ADJUSTABLE_ATTRACTION_SELECTION_LABEL, PhaseChangesControlPanel.this.m_model, 6, true);
            final MoleculeImageLabel moleculeImageLabel5 = new MoleculeImageLabel(6, PhaseChangesControlPanel.this.m_model);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.m_neonRadioButton);
            buttonGroup.add(this.m_argonRadioButton);
            buttonGroup.add(this.m_oxygenRadioButton);
            buttonGroup.add(this.m_waterRadioButton);
            buttonGroup.add(this.m_configurableRadioButton);
            this.m_neonRadioButton.setSelected(true);
            this.setLayout(new GridLayout(5, 1));
            this.add(new JPanel(new FlowLayout(0)){
                {
                    super(layoutManager);
                    this.add(MoleculeSelectionPanel.this.m_neonRadioButton);
                    this.add(moleculeImageLabel2);
                }
            });
            this.add(new JPanel(new FlowLayout(0)){
                {
                    super(layoutManager);
                    this.add(MoleculeSelectionPanel.this.m_argonRadioButton);
                    this.add(moleculeImageLabel3);
                }
            });
            this.add(new JPanel(new FlowLayout(0)){
                {
                    super(layoutManager);
                    this.add(MoleculeSelectionPanel.this.m_oxygenRadioButton);
                    this.add(moleculeImageLabel);
                }
            });
            this.add(new JPanel(new FlowLayout(0)){
                {
                    super(layoutManager);
                    this.add(MoleculeSelectionPanel.this.m_waterRadioButton);
                    this.add(moleculeImageLabel4);
                }
            });
            if (bl) {
                this.add(new JPanel(new FlowLayout(0)){
                    {
                        super(layoutManager);
                        this.add(MoleculeSelectionPanel.this.m_configurableRadioButton);
                        this.add(moleculeImageLabel5);
                    }
                });
            }
        }

        public void setMolecule(int n) {
            switch (n) {
                case 2: {
                    this.m_argonRadioButton.setSelected(true);
                    break;
                }
                case 1: {
                    this.m_neonRadioButton.setSelected(true);
                    break;
                }
                case 4: {
                    this.m_oxygenRadioButton.setSelected(true);
                    break;
                }
                case 5: {
                    this.m_waterRadioButton.setSelected(true);
                    break;
                }
                case 6: {
                    this.m_configurableRadioButton.setSelected(true);
                }
            }
        }
    }

    private class MoleculeSelectorButton
    extends JRadioButton {
        private final Font LABEL_FONT;

        private MoleculeSelectorButton(String string, final MultipleParticleModel multipleParticleModel, final int n, final boolean bl) {
            super(string);
            this.LABEL_FONT = new PhetFont(0, 14);
            this.setFont(this.LABEL_FONT);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (multipleParticleModel.getMoleculeType() != n) {
                        multipleParticleModel.setMoleculeType(n);
                        PhaseChangesControlPanel.this.m_interactionPotentialDiagram.setMolecular(bl);
                        PhaseChangesControlPanel.this.m_phaseDiagram.setDepictingWater(n == 5);
                        PhaseChangesControlPanel.this.updateVisibilityStates();
                    }
                }
            });
        }
    }

    public class SliderLayoutStrategy
    implements ILayoutStrategy {
        public void doLayout(AbstractValueControl abstractValueControl) {
            AbstractSlider abstractSlider = abstractValueControl.getSlider();
            EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(abstractValueControl);
            abstractValueControl.setLayout(easyGridBagLayout);
            easyGridBagLayout.addFilledComponent(abstractSlider, 1, 0, 2);
        }
    }
}

