/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.module.atomicinteractions;

import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.ResizeArrowNode;
import edu.colorado.phet.statesofmatter.model.AtomType;
import edu.colorado.phet.statesofmatter.model.DualAtomModel;
import edu.colorado.phet.statesofmatter.model.particle.StatesOfMatterAtom;
import edu.colorado.phet.statesofmatter.module.InteractionPotentialDiagramNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class InteractiveInteractionPotentialDiagram
extends InteractionPotentialDiagramNode {
    private static final Color RESIZE_HANDLE_NORMAL_COLOR = new Color(51, 204, 51);
    private static final Color RESIZE_HANDLE_HIGHLIGHTED_COLOR = new Color(153, 255, 0);
    private static final Stroke EPSILON_LINE_STROKE = new BasicStroke(1.0f);
    private static final Color EPSILON_LINE_COLOR = RESIZE_HANDLE_NORMAL_COLOR;
    private final DualAtomModel m_model;
    private final ResizeArrowNode m_sigmaResizeHandle;
    private final ResizeArrowNode m_epsilonResizeHandle;
    private final PPath m_epsilonLine;
    private boolean m_interactionEnabled;

    public InteractiveInteractionPotentialDiagram(double d, double d2, boolean bl, final DualAtomModel dualAtomModel) {
        super(d, d2, bl, false);
        this.m_model = dualAtomModel;
        dualAtomModel.addListener(new DualAtomModel.Adapter(){

            public void interactionPotentialChanged() {
                InteractiveInteractionPotentialDiagram.this.setLjPotentialParameters(dualAtomModel.getSigma(), dualAtomModel.getEpsilon());
            }

            public void fixedAtomAdded(StatesOfMatterAtom statesOfMatterAtom) {
                InteractiveInteractionPotentialDiagram.this.updateInteractivityState();
                InteractiveInteractionPotentialDiagram.this.drawPotentialCurve();
            }

            public void movableAtomAdded(StatesOfMatterAtom statesOfMatterAtom) {
                InteractiveInteractionPotentialDiagram.this.updateInteractivityState();
                InteractiveInteractionPotentialDiagram.this.drawPotentialCurve();
            }
        });
        PBasicInputEventHandler pBasicInputEventHandler = new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                InteractiveInteractionPotentialDiagram.this.m_model.setMotionPaused(true);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                InteractiveInteractionPotentialDiagram.this.m_model.setMotionPaused(false);
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                PNode pNode = pInputEvent.getPickedNode();
                PDimension pDimension = pInputEvent.getDeltaRelativeTo(pNode);
                pNode.localToParent(pDimension);
                double d = 450.0 / (InteractiveInteractionPotentialDiagram.this.getGraphHeight() / 2.0);
                InteractiveInteractionPotentialDiagram.this.m_model.setEpsilon(InteractiveInteractionPotentialDiagram.this.m_model.getEpsilon() + pDimension.getHeight() * d);
            }
        };
        double d3 = 0.08 * this.m_width * 2.2;
        this.m_epsilonLine = new PPath(new Line2D.Double(-d3 / 3.0, 0.0, d3 / 2.2, 0.0));
        this.m_epsilonLine.setStroke(EPSILON_LINE_STROKE);
        this.m_epsilonLine.setStrokePaint(EPSILON_LINE_COLOR);
        this.m_epsilonLine.addInputEventListener(new CursorHandler(8));
        this.m_epsilonLine.addInputEventListener(pBasicInputEventHandler);
        this.m_ljPotentialGraph.addChild(this.m_epsilonLine);
        this.m_epsilonResizeHandle = new ResizeArrowNode(0.05 * this.m_width, 1.5707963267948966, RESIZE_HANDLE_NORMAL_COLOR, RESIZE_HANDLE_HIGHLIGHTED_COLOR);
        this.m_ljPotentialGraph.addChild(this.m_epsilonResizeHandle);
        this.m_epsilonResizeHandle.addInputEventListener(pBasicInputEventHandler);
        this.m_sigmaResizeHandle = new ResizeArrowNode(0.05 * this.m_width, 0.0, RESIZE_HANDLE_NORMAL_COLOR, RESIZE_HANDLE_HIGHLIGHTED_COLOR);
        this.m_ljPotentialGraph.addChild(this.m_sigmaResizeHandle);
        this.m_sigmaResizeHandle.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                InteractiveInteractionPotentialDiagram.this.m_model.setMotionPaused(true);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                InteractiveInteractionPotentialDiagram.this.m_model.setMotionPaused(false);
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                PNode pNode = pInputEvent.getPickedNode();
                PDimension pDimension = pInputEvent.getDeltaRelativeTo(pNode);
                pNode.localToParent(pDimension);
                double d = 1200.0 / InteractiveInteractionPotentialDiagram.this.getGraphWidth();
                InteractiveInteractionPotentialDiagram.this.m_model.setAdjustableAtomSigma(InteractiveInteractionPotentialDiagram.this.m_model.getSigma() + pDimension.getWidth() * d);
            }
        });
        this.m_positionMarker.setPickable(true);
        this.m_positionMarker.setChildrenPickable(true);
        this.m_positionMarker.addInputEventListener(new CursorHandler(12));
        this.m_positionMarker.addInputEventListener(new PDragEventHandler(){

            public void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                InteractiveInteractionPotentialDiagram.this.m_model.setMotionPaused(true);
            }

            public void drag(PInputEvent pInputEvent) {
                PNode pNode = pInputEvent.getPickedNode();
                PDimension pDimension = pInputEvent.getDeltaRelativeTo(pNode);
                pNode.localToParent(pDimension);
                StatesOfMatterAtom statesOfMatterAtom = InteractiveInteractionPotentialDiagram.this.m_model.getMovableAtomRef();
                double d = 1200.0 / InteractiveInteractionPotentialDiagram.this.getGraphWidth();
                double d2 = Math.max(statesOfMatterAtom.getX() + pDimension.width * d, statesOfMatterAtom.getRadius() * 1.8);
                statesOfMatterAtom.setPosition(d2, statesOfMatterAtom.getY());
            }

            public void endDrag(PInputEvent pInputEvent) {
                super.endDrag(pInputEvent);
                InteractiveInteractionPotentialDiagram.this.m_model.setMotionPaused(false);
            }
        });
        this.drawPotentialCurve();
        this.updateInteractivityState();
    }

    protected void drawPotentialCurve() {
        Point2D point2D;
        super.drawPotentialCurve();
        if (this.m_epsilonResizeHandle != null) {
            point2D = this.getGraphMin();
            this.m_epsilonResizeHandle.setOffset(point2D.getX() + this.m_width * 0.08, point2D.getY());
            this.m_epsilonResizeHandle.setVisible(this.m_interactionEnabled);
            this.m_epsilonResizeHandle.setPickable(this.m_interactionEnabled);
            this.m_epsilonResizeHandle.setChildrenPickable(this.m_interactionEnabled);
            this.m_epsilonLine.setOffset(point2D.getX(), point2D.getY() + 1.0);
            this.m_epsilonLine.setVisible(this.m_interactionEnabled);
            this.m_epsilonLine.setPickable(this.m_interactionEnabled);
        }
        if (this.m_sigmaResizeHandle != null) {
            point2D = this.getZeroCrossingPoint();
            this.m_sigmaResizeHandle.setOffset(point2D.getX(), this.getGraphHeight() / 2.0 - 0.08 * this.m_height);
            this.m_sigmaResizeHandle.setVisible(this.m_interactionEnabled);
            this.m_sigmaResizeHandle.setPickable(this.m_interactionEnabled);
            this.m_sigmaResizeHandle.setChildrenPickable(this.m_interactionEnabled);
        }
    }

    private void updateInteractivityState() {
        this.m_interactionEnabled = this.m_model.getFixedAtomType() == AtomType.ADJUSTABLE;
    }
}

