/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.module.atomicinteractions;

import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.AbstractSlider;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.AbstractValueControl;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.ILayoutStrategy;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.statesofmatter.StatesOfMatterResources;
import edu.colorado.phet.statesofmatter.StatesOfMatterStrings;
import edu.colorado.phet.statesofmatter.model.AtomType;
import edu.colorado.phet.statesofmatter.model.DualAtomModel;
import edu.colorado.phet.statesofmatter.model.particle.StatesOfMatterAtom;
import edu.colorado.phet.statesofmatter.module.atomicinteractions.AtomicInteractionsCanvas;
import edu.colorado.phet.statesofmatter.module.atomicinteractions.AtomicInteractionsModule;
import edu.colorado.phet.statesofmatter.view.ParticleForceNode;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AtomicInteractionsControlPanel
extends ControlPanel {
    private static final Font LABEL_FONT = new PhetFont(0, 14);
    private static final Font BOLD_LABEL_FONT = new PhetFont(1, 14);
    private static final Color ENABLED_TITLE_COLOR = Color.BLACK;
    private final DualAtomModel m_model;
    private final AtomicInteractionsCanvas m_canvas;
    private AtomSelectionPanel m_moleculeSelectionPanel;
    private final AtomDiameterControlPanel m_atomDiameterControlPanel;
    private final InteractionStrengthControlPanel m_interactionStrengthControlPanel;
    private final ForceControlPanel m_forceControlPanel;

    public AtomicInteractionsControlPanel(AtomicInteractionsModule atomicInteractionsModule, boolean bl) {
        this.m_model = atomicInteractionsModule.getDualParticleModel();
        this.m_canvas = atomicInteractionsModule.getCanvas();
        this.m_model.addListener(new DualAtomModel.Adapter(){

            public void fixedAtomAdded(StatesOfMatterAtom statesOfMatterAtom) {
                AtomicInteractionsControlPanel.this.m_moleculeSelectionPanel.updateMoleculeType();
            }

            public void movableAtomAdded(StatesOfMatterAtom statesOfMatterAtom) {
                AtomicInteractionsControlPanel.this.m_moleculeSelectionPanel.updateMoleculeType();
            }
        });
        int n = StatesOfMatterResources.getInt("int.minControlPanelWidth", 215);
        this.setMinimumWidth(n);
        this.m_atomDiameterControlPanel = new AtomDiameterControlPanel(this.m_model);
        this.m_interactionStrengthControlPanel = new InteractionStrengthControlPanel(this.m_model);
        this.m_moleculeSelectionPanel = bl ? new HeterogeneousAtomSelectionPanel() : new HomogeneousAtomSelectionPanel();
        this.m_forceControlPanel = new ForceControlPanel();
        this.addControlFullWidth((JPanel)((Object)this.m_moleculeSelectionPanel));
        this.addControlFullWidth(this.m_atomDiameterControlPanel);
        this.addControlFullWidth(this.m_interactionStrengthControlPanel);
        this.addControlFullWidth(this.m_forceControlPanel);
        this.addVerticalSpace(10);
        JButton jButton = new JButton(StatesOfMatterStrings.RESET);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AtomicInteractionsControlPanel.this.m_model.reset();
                if (AtomicInteractionsControlPanel.this.m_model.getClock().isPaused()) {
                    AtomicInteractionsControlPanel.this.m_model.getClock().setPaused(false);
                }
                AtomicInteractionsControlPanel.this.m_forceControlPanel.reset();
            }
        });
        this.addControl(jButton);
    }

    private class AtomDiameterControlPanel
    extends JPanel {
        private final Font LABEL_FONT = new PhetFont(14, false);
        private final LinearValueControl m_atomDiameterControl;
        private final DualAtomModel m_model;
        private final TitledBorder m_titledBorder;
        private final JLabel m_leftLabel;
        private final JLabel m_rightLabel;

        public AtomDiameterControlPanel(DualAtomModel dualAtomModel) {
            this.m_model = dualAtomModel;
            this.setLayout(new GridLayout(0, 1));
            BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
            this.m_titledBorder = BorderFactory.createTitledBorder(bevelBorder, StatesOfMatterStrings.ATOM_DIAMETER_CONTROL_TITLE, 1, 2, new PhetFont(1, 14), ENABLED_TITLE_COLOR);
            this.setBorder(this.m_titledBorder);
            this.m_atomDiameterControl = new LinearValueControl(75.0, 500.0, "", "0", "", new SliderLayoutStrategy());
            this.m_atomDiameterControl.setValue(this.m_model.getSigma());
            this.m_atomDiameterControl.setUpDownArrowDelta(0.01);
            this.m_atomDiameterControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    AtomDiameterControlPanel.this.m_model.setAdjustableAtomSigma(AtomDiameterControlPanel.this.m_atomDiameterControl.getValue());
                }
            });
            this.m_atomDiameterControl.getSlider().addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    AtomDiameterControlPanel.this.m_model.setMotionPaused(true);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    AtomDiameterControlPanel.this.m_model.setMotionPaused(false);
                }
            });
            Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
            this.m_leftLabel = new JLabel(StatesOfMatterStrings.ATOM_DIAMETER_SMALL);
            this.m_leftLabel.setFont(this.LABEL_FONT);
            hashtable.put(this.m_atomDiameterControl.getMinimum(), this.m_leftLabel);
            this.m_rightLabel = new JLabel(StatesOfMatterStrings.ATOM_DIAMETER_LARGE);
            this.m_rightLabel.setFont(this.LABEL_FONT);
            hashtable.put(this.m_atomDiameterControl.getMaximum(), this.m_rightLabel);
            this.m_atomDiameterControl.setTickLabels(hashtable);
            this.m_atomDiameterControl.setValue(this.m_model.getSigma());
            this.add(this.m_atomDiameterControl);
            this.m_model.addListener(new DualAtomModel.Adapter(){

                public void fixedAtomDiameterChanged() {
                    AtomDiameterControlPanel.this.m_atomDiameterControl.setValue(AtomDiameterControlPanel.this.m_model.getSigma());
                }

                public void movableAtomDiameterChanged() {
                    AtomDiameterControlPanel.this.m_atomDiameterControl.setValue(AtomDiameterControlPanel.this.m_model.getSigma());
                }
            });
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.m_atomDiameterControl.setEnabled(bl);
            this.m_leftLabel.setEnabled(bl);
            this.m_rightLabel.setEnabled(bl);
            if (bl) {
                this.m_titledBorder.setTitleColor(ENABLED_TITLE_COLOR);
            } else {
                this.m_titledBorder.setTitleColor(Color.LIGHT_GRAY);
            }
        }
    }

    private static interface AtomSelectionPanel {
        public void updateMoleculeType();
    }

    private class ForceControlPanel
    extends VerticalLayoutPanel {
        private final JRadioButton m_noForcesButton;
        private final JRadioButton m_totalForcesButton;
        private final JRadioButton m_componentForceButton;
        private final JLabel m_attractiveForceLegendEntry;
        private final JLabel m_repulsiveForceLegendEntry;

        public ForceControlPanel() {
            BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, StatesOfMatterStrings.INTERACTION_POTENTIAL_SHOW_FORCES, 1, 2, new PhetFont(1, 14), Color.BLACK);
            this.setBorder(titledBorder);
            this.m_noForcesButton = new JRadioButton(StatesOfMatterStrings.INTERACTION_POTENTIAL_HIDE_FORCES);
            this.m_noForcesButton.setFont(LABEL_FONT);
            this.m_noForcesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AtomicInteractionsControlPanel.this.m_canvas.setShowAttractiveForces(false);
                    AtomicInteractionsControlPanel.this.m_canvas.setShowRepulsiveForces(false);
                    AtomicInteractionsControlPanel.this.m_canvas.setShowTotalForces(false);
                }
            });
            this.m_totalForcesButton = new JRadioButton(StatesOfMatterStrings.INTERACTION_POTENTIAL_TOTAL_FORCES);
            this.m_totalForcesButton.setFont(LABEL_FONT);
            this.m_totalForcesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AtomicInteractionsControlPanel.this.m_canvas.setShowAttractiveForces(false);
                    AtomicInteractionsControlPanel.this.m_canvas.setShowRepulsiveForces(false);
                    AtomicInteractionsControlPanel.this.m_canvas.setShowTotalForces(true);
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0, 0, 0));
            jPanel.add(this.m_totalForcesButton);
            jPanel.add(new JLabel(this.createArrowIcon(ParticleForceNode.TOTAL_FORCE_COLOR, false)));
            this.m_componentForceButton = new JRadioButton(StatesOfMatterStrings.INTERACTION_POTENTIAL_COMPONENT_FORCES);
            this.m_componentForceButton.setFont(LABEL_FONT);
            this.m_componentForceButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AtomicInteractionsControlPanel.this.m_canvas.setShowAttractiveForces(true);
                    AtomicInteractionsControlPanel.this.m_canvas.setShowRepulsiveForces(true);
                    AtomicInteractionsControlPanel.this.m_canvas.setShowTotalForces(false);
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.m_noForcesButton);
            buttonGroup.add(this.m_totalForcesButton);
            buttonGroup.add(this.m_componentForceButton);
            this.m_noForcesButton.setSelected(true);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(Box.createHorizontalStrut(14));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout(0));
            this.m_attractiveForceLegendEntry = new JLabel(StatesOfMatterStrings.ATTRACTIVE_FORCE_KEY, this.createArrowIcon(ParticleForceNode.ATTRACTIVE_FORCE_COLOR, false), 2);
            jPanel3.add(jPanel2);
            jPanel3.add(this.m_attractiveForceLegendEntry);
            jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(Box.createHorizontalStrut(14));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new FlowLayout(0));
            this.m_repulsiveForceLegendEntry = new JLabel(StatesOfMatterStrings.REPULSIVE_FORCE_KEY, this.createArrowIcon(ParticleForceNode.REPULSIVE_FORCE_COLOR, true), 2);
            jPanel4.add(jPanel2);
            jPanel4.add(this.m_repulsiveForceLegendEntry);
            this.add(this.m_noForcesButton);
            this.add(jPanel);
            this.add(this.m_componentForceButton);
            this.add(jPanel3);
            this.add(jPanel4);
        }

        private void reset() {
            this.m_noForcesButton.setSelected(true);
            AtomicInteractionsControlPanel.this.m_canvas.setShowAttractiveForces(false);
            AtomicInteractionsControlPanel.this.m_canvas.setShowRepulsiveForces(false);
            AtomicInteractionsControlPanel.this.m_canvas.setShowTotalForces(false);
        }

        private ImageIcon createArrowIcon(Color color, boolean bl) {
            ArrowNode arrowNode = new ArrowNode(new Point2D.Double(0.0, 0.0), new Point2D.Double(20.0, 0.0), 10.0, 15.0, 6.0);
            arrowNode.setPaint(color);
            Image image = arrowNode.toImage();
            if (!bl) {
                image = BufferedImageUtils.flipX(BufferedImageUtils.toBufferedImage(image));
            }
            return new ImageIcon(image);
        }
    }

    private class HeterogeneousAtomSelectionPanel
    extends VerticalLayoutPanel
    implements AtomSelectionPanel {
        private final JRadioButton m_neonNeonRadioButton;
        private final JRadioButton m_argonArgonRadioButton;
        private final JRadioButton m_oxygenOxygenRadioButton;
        private final JRadioButton m_neonArgonRadioButton;
        private final JRadioButton m_neonOxygenRadioButton;
        private final JRadioButton m_argonOxygenRadioButton;
        private final JRadioButton m_adjustableInteractionRadioButton;

        HeterogeneousAtomSelectionPanel() {
            BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, StatesOfMatterStrings.INTERACTION_POTENTIAL_ATOM_SELECT_LABEL, 1, 2, new PhetFont(1, 14), Color.BLACK);
            this.setBorder(titledBorder);
            this.m_neonNeonRadioButton = new JRadioButton(StatesOfMatterStrings.NEON_SELECTION_LABEL);
            this.m_neonNeonRadioButton.setFont(LABEL_FONT);
            this.m_neonNeonRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HeterogeneousAtomSelectionPanel.this.setFixedAtom(AtomType.NEON);
                    HeterogeneousAtomSelectionPanel.this.setMovableAtom(AtomType.NEON);
                    HeterogeneousAtomSelectionPanel.this.updateLjControlSliderState();
                }
            });
            this.m_neonArgonRadioButton = new JRadioButton(StatesOfMatterStrings.NEON_SELECTION_LABEL);
            this.m_neonArgonRadioButton.setFont(LABEL_FONT);
            this.m_neonArgonRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HeterogeneousAtomSelectionPanel.this.setFixedAtom(AtomType.NEON);
                    HeterogeneousAtomSelectionPanel.this.setMovableAtom(AtomType.ARGON);
                    HeterogeneousAtomSelectionPanel.this.updateLjControlSliderState();
                }
            });
            this.m_neonOxygenRadioButton = new JRadioButton(StatesOfMatterStrings.NEON_SELECTION_LABEL);
            this.m_neonOxygenRadioButton.setFont(LABEL_FONT);
            this.m_neonOxygenRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HeterogeneousAtomSelectionPanel.this.setFixedAtom(AtomType.NEON);
                    HeterogeneousAtomSelectionPanel.this.setMovableAtom(AtomType.OXYGEN);
                    HeterogeneousAtomSelectionPanel.this.updateLjControlSliderState();
                }
            });
            this.m_argonArgonRadioButton = new JRadioButton(StatesOfMatterStrings.ARGON_SELECTION_LABEL);
            this.m_argonArgonRadioButton.setFont(LABEL_FONT);
            this.m_argonArgonRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AtomicInteractionsControlPanel.this.m_model.setBothAtomTypes(AtomType.ARGON);
                    HeterogeneousAtomSelectionPanel.this.updateLjControlSliderState();
                }
            });
            this.m_argonOxygenRadioButton = new JRadioButton(StatesOfMatterStrings.ARGON_SELECTION_LABEL);
            this.m_argonOxygenRadioButton.setFont(LABEL_FONT);
            this.m_argonOxygenRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HeterogeneousAtomSelectionPanel.this.setFixedAtom(AtomType.ARGON);
                    HeterogeneousAtomSelectionPanel.this.setMovableAtom(AtomType.OXYGEN);
                    HeterogeneousAtomSelectionPanel.this.updateLjControlSliderState();
                }
            });
            this.m_oxygenOxygenRadioButton = new JRadioButton(StatesOfMatterStrings.OXYGEN_SELECTION_LABEL);
            this.m_oxygenOxygenRadioButton.setFont(LABEL_FONT);
            this.m_oxygenOxygenRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AtomicInteractionsControlPanel.this.m_model.setBothAtomTypes(AtomType.OXYGEN);
                    HeterogeneousAtomSelectionPanel.this.updateLjControlSliderState();
                }
            });
            this.m_adjustableInteractionRadioButton = new JRadioButton(StatesOfMatterStrings.ADJUSTABLE_ATTRACTION_SELECTION_LABEL);
            this.m_adjustableInteractionRadioButton.setFont(LABEL_FONT);
            this.m_adjustableInteractionRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AtomicInteractionsControlPanel.this.m_model.setBothAtomTypes(AtomType.ADJUSTABLE);
                    HeterogeneousAtomSelectionPanel.this.updateLjControlSliderState();
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.m_neonNeonRadioButton);
            buttonGroup.add(this.m_argonArgonRadioButton);
            buttonGroup.add(this.m_oxygenOxygenRadioButton);
            buttonGroup.add(this.m_neonArgonRadioButton);
            buttonGroup.add(this.m_neonOxygenRadioButton);
            buttonGroup.add(this.m_argonOxygenRadioButton);
            buttonGroup.add(this.m_adjustableInteractionRadioButton);
            this.m_neonNeonRadioButton.setSelected(true);
            BufferedImage bufferedImage = StatesOfMatterResources.getImage("push-pin.png");
            Image image = bufferedImage.getScaledInstance(30, 32, 4);
            ImageIcon imageIcon = new ImageIcon(image);
            JLabel jLabel = new JLabel(StatesOfMatterStrings.FIXED_ATOM_LABEL, imageIcon, 2);
            jLabel.setFont(BOLD_LABEL_FONT);
            JLabel jLabel2 = new JLabel(StatesOfMatterStrings.MOVABLE_ATOM_LABEL);
            jLabel2.setFont(BOLD_LABEL_FONT);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(1, 2, 0, 0));
            jPanel.add(jLabel);
            jPanel.add(jLabel2);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(0, 2));
            jPanel2.add(this.m_neonNeonRadioButton);
            jPanel2.add(new PhetJLabel(StatesOfMatterStrings.NEON_SELECTION_LABEL));
            jPanel2.add(this.m_argonArgonRadioButton);
            jPanel2.add(new PhetJLabel(StatesOfMatterStrings.ARGON_SELECTION_LABEL));
            jPanel2.add(this.m_oxygenOxygenRadioButton);
            jPanel2.add(new PhetJLabel(StatesOfMatterStrings.OXYGEN_SELECTION_LABEL));
            jPanel2.add(this.m_neonArgonRadioButton);
            jPanel2.add(new PhetJLabel(StatesOfMatterStrings.ARGON_SELECTION_LABEL));
            jPanel2.add(this.m_neonOxygenRadioButton);
            jPanel2.add(new PhetJLabel(StatesOfMatterStrings.OXYGEN_SELECTION_LABEL));
            jPanel2.add(this.m_argonOxygenRadioButton);
            jPanel2.add(new PhetJLabel(StatesOfMatterStrings.OXYGEN_SELECTION_LABEL));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 1));
            jPanel3.add(Box.createVerticalStrut(12));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridLayout(0, 1));
            jPanel4.add(this.m_adjustableInteractionRadioButton);
            this.add(jPanel);
            this.add(jPanel2);
            this.add(jPanel3);
            this.add(jPanel4);
            this.updateMoleculeType();
            this.updateLjControlSliderState();
        }

        public void updateMoleculeType() {
            AtomType atomType = AtomicInteractionsControlPanel.this.m_model.getFixedAtomType();
            AtomType atomType2 = AtomicInteractionsControlPanel.this.m_model.getMovableAtomType();
            if (atomType == AtomType.NEON && atomType2 == AtomType.NEON) {
                this.m_neonNeonRadioButton.setSelected(true);
            } else if (atomType == AtomType.NEON && atomType2 == AtomType.ARGON) {
                this.m_neonArgonRadioButton.setSelected(true);
            } else if (atomType == AtomType.NEON && atomType2 == AtomType.OXYGEN) {
                this.m_neonOxygenRadioButton.setSelected(true);
            } else if (atomType == AtomType.ARGON && atomType2 == AtomType.ARGON) {
                this.m_argonArgonRadioButton.setSelected(true);
            } else if (atomType == AtomType.ARGON && atomType2 == AtomType.OXYGEN) {
                this.m_argonOxygenRadioButton.setSelected(true);
            } else if (atomType == AtomType.OXYGEN && atomType2 == AtomType.OXYGEN) {
                this.m_oxygenOxygenRadioButton.setSelected(true);
            } else if (atomType == AtomType.ADJUSTABLE && atomType2 == AtomType.ADJUSTABLE) {
                this.m_adjustableInteractionRadioButton.setSelected(true);
            }
            this.updateLjControlSliderState();
        }

        private void updateLjControlSliderState() {
            AtomicInteractionsControlPanel.this.m_atomDiameterControlPanel.setVisible(AtomicInteractionsControlPanel.this.m_model.getFixedAtomType() == AtomType.ADJUSTABLE);
            AtomicInteractionsControlPanel.this.m_interactionStrengthControlPanel.setVisible(AtomicInteractionsControlPanel.this.m_model.getFixedAtomType() == AtomType.ADJUSTABLE);
        }

        private void setFixedAtom(AtomType atomType) {
            if (AtomicInteractionsControlPanel.this.m_model.getMovableAtomType() == AtomType.ADJUSTABLE) {
                AtomicInteractionsControlPanel.this.m_model.setBothAtomTypes(atomType);
            } else {
                AtomicInteractionsControlPanel.this.m_model.setFixedAtomType(atomType);
            }
        }

        private void setMovableAtom(AtomType atomType) {
            if (AtomicInteractionsControlPanel.this.m_model.getFixedAtomType() == AtomType.ADJUSTABLE) {
                AtomicInteractionsControlPanel.this.m_model.setBothAtomTypes(atomType);
            } else {
                AtomicInteractionsControlPanel.this.m_model.setMovableAtomType(atomType);
            }
        }
    }

    private class HomogeneousAtomSelectionPanel
    extends JPanel
    implements AtomSelectionPanel {
        private final JRadioButton m_neonRadioButton;
        private final JRadioButton m_argonRadioButton;
        private final JRadioButton m_adjustableAttractionRadioButton;

        HomogeneousAtomSelectionPanel() {
            this.setLayout(new GridLayout(0, 1));
            BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, StatesOfMatterStrings.INTERACTION_POTENTIAL_ATOM_SELECT_LABEL, 1, 2, new PhetFont(1, 14), Color.BLACK);
            this.setBorder(titledBorder);
            this.m_neonRadioButton = new JRadioButton(StatesOfMatterStrings.NEON_SELECTION_LABEL);
            this.m_neonRadioButton.setFont(LABEL_FONT);
            this.m_neonRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AtomicInteractionsControlPanel.this.m_model.getFixedAtomType() != AtomType.NEON) {
                        AtomicInteractionsControlPanel.this.m_model.setBothAtomTypes(AtomType.NEON);
                        HomogeneousAtomSelectionPanel.this.updateLjControlSliderState();
                    }
                }
            });
            this.m_argonRadioButton = new JRadioButton(StatesOfMatterStrings.ARGON_SELECTION_LABEL);
            this.m_argonRadioButton.setFont(LABEL_FONT);
            this.m_argonRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AtomicInteractionsControlPanel.this.m_model.getFixedAtomType() != AtomType.ARGON) {
                        AtomicInteractionsControlPanel.this.m_model.setBothAtomTypes(AtomType.ARGON);
                        HomogeneousAtomSelectionPanel.this.updateLjControlSliderState();
                    }
                }
            });
            this.m_adjustableAttractionRadioButton = new JRadioButton(StatesOfMatterStrings.ADJUSTABLE_ATTRACTION_SELECTION_LABEL);
            this.m_adjustableAttractionRadioButton.setFont(LABEL_FONT);
            this.m_adjustableAttractionRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AtomicInteractionsControlPanel.this.m_model.getFixedAtomType() != AtomType.ADJUSTABLE) {
                        AtomicInteractionsControlPanel.this.m_model.setBothAtomTypes(AtomType.ADJUSTABLE);
                        HomogeneousAtomSelectionPanel.this.updateLjControlSliderState();
                    }
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.m_neonRadioButton);
            buttonGroup.add(this.m_argonRadioButton);
            buttonGroup.add(this.m_adjustableAttractionRadioButton);
            this.m_neonRadioButton.setSelected(true);
            this.add(this.m_neonRadioButton);
            this.add(this.m_argonRadioButton);
            this.add(this.m_adjustableAttractionRadioButton);
            this.updateLjControlSliderState();
        }

        public void updateMoleculeType() {
            AtomType atomType = AtomicInteractionsControlPanel.this.m_model.getFixedAtomType();
            if (atomType == AtomType.NEON) {
                this.m_neonRadioButton.setSelected(true);
            } else if (atomType == AtomType.ARGON) {
                this.m_argonRadioButton.setSelected(true);
            } else {
                this.m_adjustableAttractionRadioButton.setSelected(true);
            }
            this.updateLjControlSliderState();
        }

        private void updateLjControlSliderState() {
            AtomicInteractionsControlPanel.this.m_atomDiameterControlPanel.setVisible(AtomicInteractionsControlPanel.this.m_model.getFixedAtomType() == AtomType.ADJUSTABLE);
            AtomicInteractionsControlPanel.this.m_interactionStrengthControlPanel.setVisible(AtomicInteractionsControlPanel.this.m_model.getFixedAtomType() == AtomType.ADJUSTABLE);
        }
    }

    private class InteractionStrengthControlPanel
    extends JPanel {
        private final Font LABEL_FONT = new PhetFont(14, false);
        private final LinearValueControl m_interactionStrengthControl;
        private final DualAtomModel m_model;
        private final TitledBorder m_titledBorder;
        private final JLabel m_leftLabel;
        private final JLabel m_rightLabel;

        public InteractionStrengthControlPanel(DualAtomModel dualAtomModel) {
            this.m_model = dualAtomModel;
            this.setLayout(new GridLayout(0, 1));
            BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
            this.m_titledBorder = BorderFactory.createTitledBorder(bevelBorder, StatesOfMatterStrings.INTERACTION_STRENGTH_CONTROL_TITLE, 1, 2, new PhetFont(1, 14), ENABLED_TITLE_COLOR);
            this.setBorder(this.m_titledBorder);
            this.m_interactionStrengthControl = new LinearValueControl(20.0, 450.0, "", "0", "", new SliderLayoutStrategy());
            this.m_interactionStrengthControl.setValue(this.m_model.getEpsilon());
            this.m_interactionStrengthControl.setUpDownArrowDelta(0.01);
            this.m_interactionStrengthControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    InteractionStrengthControlPanel.this.m_model.setEpsilon(InteractionStrengthControlPanel.this.m_interactionStrengthControl.getValue());
                }
            });
            this.m_interactionStrengthControl.getSlider().addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    InteractionStrengthControlPanel.this.m_model.setMotionPaused(true);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    InteractionStrengthControlPanel.this.m_model.setMotionPaused(false);
                }
            });
            Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
            this.m_leftLabel = new JLabel(StatesOfMatterStrings.INTERACTION_STRENGTH_WEAK);
            this.m_leftLabel.setFont(this.LABEL_FONT);
            hashtable.put(this.m_interactionStrengthControl.getMinimum(), this.m_leftLabel);
            this.m_rightLabel = new JLabel(StatesOfMatterStrings.INTERACTION_STRENGTH_STRONG);
            this.m_rightLabel.setFont(this.LABEL_FONT);
            hashtable.put(this.m_interactionStrengthControl.getMaximum(), this.m_rightLabel);
            this.m_interactionStrengthControl.setTickLabels(hashtable);
            this.m_model.addListener(new DualAtomModel.Adapter(){

                public void interactionPotentialChanged() {
                    InteractionStrengthControlPanel.this.m_interactionStrengthControl.setValue(InteractionStrengthControlPanel.this.m_model.getEpsilon());
                }
            });
            this.add(this.m_interactionStrengthControl);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.m_interactionStrengthControl.setEnabled(bl);
            this.m_leftLabel.setEnabled(bl);
            this.m_rightLabel.setEnabled(bl);
            if (bl) {
                this.m_titledBorder.setTitleColor(ENABLED_TITLE_COLOR);
            } else {
                this.m_titledBorder.setTitleColor(Color.LIGHT_GRAY);
            }
        }
    }

    public class PhetJLabel
    extends JLabel {
        public PhetJLabel(String string) {
            super(string);
            this.setFont(LABEL_FONT);
        }
    }

    public class SliderLayoutStrategy
    implements ILayoutStrategy {
        public void doLayout(AbstractValueControl abstractValueControl) {
            AbstractSlider abstractSlider = abstractValueControl.getSlider();
            EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(abstractValueControl);
            abstractValueControl.setLayout(easyGridBagLayout);
            easyGridBagLayout.addFilledComponent(abstractSlider, 1, 0, 2);
        }
    }
}

