/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.model.engine.kinetic;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.statesofmatter.model.MoleculeForceAndMotionDataSet;
import edu.colorado.phet.statesofmatter.model.engine.kinetic.Thermostat;

public class IsokineticThermostat
implements Thermostat {
    final MoleculeForceAndMotionDataSet m_moleculeDataSet;
    final Vector2D[] m_moleculeVelocities;
    final double[] m_moleculeRotationRates;
    double m_targetTemperature;
    final double m_minModelTemperature;

    public IsokineticThermostat(MoleculeForceAndMotionDataSet moleculeForceAndMotionDataSet, double d) {
        this.m_moleculeDataSet = moleculeForceAndMotionDataSet;
        this.m_targetTemperature = 0.15;
        this.m_minModelTemperature = d;
        this.m_moleculeVelocities = moleculeForceAndMotionDataSet.getMoleculeVelocities();
        this.m_moleculeRotationRates = moleculeForceAndMotionDataSet.getMoleculeRotationRates();
    }

    public void setTargetTemperature(double d) {
        this.m_targetTemperature = d;
    }

    public void adjustTemperature() {
        double d;
        int n = this.m_moleculeDataSet.getNumberOfMolecules();
        if (this.m_moleculeDataSet.getAtomsPerMolecule() > 1) {
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = 0; i < n; ++i) {
                d2 += 0.5 * this.m_moleculeDataSet.getMoleculeMass() * (Math.pow(this.m_moleculeVelocities[i].getX(), 2.0) + Math.pow(this.m_moleculeVelocities[i].getY(), 2.0));
                d3 += 0.5 * this.m_moleculeDataSet.getMoleculeRotationalInertia() * Math.pow(this.m_moleculeRotationRates[i], 2.0);
            }
            d = (d2 + d3) / (double)n / 1.5;
        } else {
            double d4 = 0.0;
            for (int i = 0; i < this.m_moleculeDataSet.getNumberOfMolecules(); ++i) {
                d4 += 0.5 * this.m_moleculeDataSet.getMoleculeMass() * (Math.pow(this.m_moleculeVelocities[i].getX(), 2.0) + Math.pow(this.m_moleculeVelocities[i].getY(), 2.0));
            }
            d = d4 / (double)n;
        }
        this.adjustTemperature(d);
    }

    public void adjustTemperature(double d) {
        double d2 = this.m_targetTemperature <= this.m_minModelTemperature ? 0.0 : Math.sqrt(this.m_targetTemperature / d);
        int n = 0;
        while (n < this.m_moleculeDataSet.getNumberOfMolecules()) {
            this.m_moleculeVelocities[n].setComponents(this.m_moleculeVelocities[n].getX() * d2, this.m_moleculeVelocities[n].getY() * d2);
            int n2 = n++;
            this.m_moleculeRotationRates[n2] = this.m_moleculeRotationRates[n2] * d2;
        }
    }
}

