/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.model.engine;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.statesofmatter.model.MoleculeForceAndMotionDataSet;
import edu.colorado.phet.statesofmatter.model.MultipleParticleModel;
import edu.colorado.phet.statesofmatter.model.engine.AbstractVerletAlgorithm;
import edu.colorado.phet.statesofmatter.model.engine.AtomPositionUpdater;
import edu.colorado.phet.statesofmatter.model.engine.MonatomicAtomPositionUpdater;
import java.awt.geom.Point2D;

public class MonatomicVerletAlgorithm
extends AbstractVerletAlgorithm {
    private final AtomPositionUpdater m_positionUpdater = new MonatomicAtomPositionUpdater();
    private double m_epsilon = 1.0;

    public MonatomicVerletAlgorithm(MultipleParticleModel multipleParticleModel) {
        super(multipleParticleModel);
    }

    public double getPressure() {
        return this.m_pressure;
    }

    public double getTemperature() {
        return this.m_temperature;
    }

    public void setScaledEpsilon(double d) {
        this.m_epsilon = d;
    }

    public double getScaledEpsilon() {
        return this.m_epsilon;
    }

    public void updateForcesAndMotion() {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        MoleculeForceAndMotionDataSet moleculeForceAndMotionDataSet = this.m_model.getMoleculeDataSetRef();
        int n2 = moleculeForceAndMotionDataSet.getNumberOfAtoms();
        Point2D[] point2DArray = moleculeForceAndMotionDataSet.getMoleculeCenterOfMassPositions();
        Vector2D[] vector2DArray = moleculeForceAndMotionDataSet.getMoleculeVelocities();
        Vector2D[] vector2DArray2 = moleculeForceAndMotionDataSet.getMoleculeForces();
        Vector2D[] vector2DArray3 = moleculeForceAndMotionDataSet.getNextMoleculeForces();
        for (int i = 0; i < n2; ++i) {
            double d3 = point2DArray[i].getX() + 0.02 * vector2DArray[i].getX() + 2.0E-4 * vector2DArray2[i].getX();
            double d4 = point2DArray[i].getY() + 0.02 * vector2DArray[i].getY() + 2.0E-4 * vector2DArray2[i].getY();
            point2DArray[i].setLocation(d3, d4);
        }
        double d5 = 0.0;
        for (int i = 0; i < n2; ++i) {
            vector2DArray3[i].setComponents(0.0, 0.0);
            this.calculateWallForce(point2DArray[i], this.m_model.getNormalizedContainerWidth(), this.m_model.getNormalizedContainerHeight(), vector2DArray3[i]);
            if (vector2DArray3[i].getY() < 0.0) {
                d5 += -vector2DArray3[i].getY();
            } else if (point2DArray[i].getY() > this.m_model.getNormalizedContainerHeight() / 2.0) {
                d5 += Math.abs(vector2DArray3[i].getX());
            }
            vector2DArray3[i].setY(vector2DArray3[i].getY() - this.m_model.getGravitationalAcceleration());
        }
        this.updatePressure(d5);
        if (moleculeForceAndMotionDataSet.getNumberOfSafeMolecules() < n2) {
            this.updateMoleculeSafety();
        }
        double d6 = moleculeForceAndMotionDataSet.getNumberOfSafeMolecules();
        Vector2D vector2D = new Vector2D();
        int n3 = 0;
        while ((double)n3 < d6) {
            n = n3 + 1;
            while ((double)n < d6) {
                double d7;
                double d8 = point2DArray[n3].getX() - point2DArray[n].getX();
                double d9 = d8 * d8 + (d7 = point2DArray[n3].getY() - point2DArray[n].getY()) * d7;
                if (d9 == 0.0) {
                    d8 = 1.0;
                    d7 = 1.0;
                    d9 = 2.0;
                }
                if (d9 < 6.25) {
                    if (d9 < 0.7225) {
                        d9 = 0.7225;
                    }
                    double d10 = 1.0 / d9;
                    double d11 = d10 * d10 * d10;
                    double d12 = 48.0 * d10 * d11 * (d11 - 0.5) * this.m_epsilon;
                    vector2D.setX(d8 * d12);
                    vector2D.setY(d7 * d12);
                    vector2DArray3[n3].add(vector2D);
                    vector2DArray3[n].subtract(vector2D);
                    d2 += 4.0 * d11 * (d11 - 1.0) + 0.016316891136;
                }
                ++n;
            }
            ++n3;
        }
        Vector2D vector2D2 = new Vector2D();
        for (n = 0; n < n2; ++n) {
            vector2D2.setX(0.01 * (vector2DArray2[n].getX() + vector2DArray3[n].getX()));
            vector2D2.setY(0.01 * (vector2DArray2[n].getY() + vector2DArray3[n].getY()));
            vector2DArray[n].add(vector2D2);
            d += (vector2DArray[n].getX() * vector2DArray[n].getX() + vector2DArray[n].getY() * vector2DArray[n].getY()) / 2.0;
        }
        this.m_temperature = d / (double)n2;
        this.m_positionUpdater.updateAtomPositions(moleculeForceAndMotionDataSet);
        for (n = 0; n < n2; ++n) {
            vector2DArray2[n].setComponents(vector2DArray3[n].getX(), vector2DArray3[n].getY());
        }
    }
}

