/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.model.engine;

import edu.colorado.phet.statesofmatter.model.MoleculeForceAndMotionDataSet;
import edu.colorado.phet.statesofmatter.model.engine.AtomPositionUpdater;
import java.awt.geom.Point2D;

public class DiatomicAtomPositionUpdater
implements AtomPositionUpdater {
    public void updateAtomPositions(MoleculeForceAndMotionDataSet moleculeForceAndMotionDataSet) {
        assert (moleculeForceAndMotionDataSet.getAtomsPerMolecule() == 2);
        Point2D[] point2DArray = moleculeForceAndMotionDataSet.getAtomPositions();
        Point2D[] point2DArray2 = moleculeForceAndMotionDataSet.getMoleculeCenterOfMassPositions();
        double[] dArray = moleculeForceAndMotionDataSet.getMoleculeRotationAngles();
        for (int i = 0; i < moleculeForceAndMotionDataSet.getNumberOfMolecules(); ++i) {
            double d = Math.cos(dArray[i]);
            double d2 = Math.sin(dArray[i]);
            double d3 = point2DArray2[i].getX() + d * 0.45;
            double d4 = point2DArray2[i].getY() + d2 * 0.45;
            point2DArray[i * 2].setLocation(d3, d4);
            d3 = point2DArray2[i].getX() - d * 0.45;
            d4 = point2DArray2[i].getY() - d2 * 0.45;
            point2DArray[i * 2 + 1].setLocation(d3, d4);
        }
    }
}

