/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.statesofmatter.StatesOfMatterConstants;
import edu.colorado.phet.statesofmatter.model.AtomType;
import edu.colorado.phet.statesofmatter.model.InteractionStrengthTable;
import edu.colorado.phet.statesofmatter.model.MoleculeForceAndMotionDataSet;
import edu.colorado.phet.statesofmatter.model.engine.AtomPositionUpdater;
import edu.colorado.phet.statesofmatter.model.engine.DiatomicAtomPositionUpdater;
import edu.colorado.phet.statesofmatter.model.engine.DiatomicPhaseStateChanger;
import edu.colorado.phet.statesofmatter.model.engine.DiatomicVerletAlgorithm;
import edu.colorado.phet.statesofmatter.model.engine.MoleculeForceAndMotionCalculator;
import edu.colorado.phet.statesofmatter.model.engine.MonatomicAtomPositionUpdater;
import edu.colorado.phet.statesofmatter.model.engine.MonatomicPhaseStateChanger;
import edu.colorado.phet.statesofmatter.model.engine.MonatomicVerletAlgorithm;
import edu.colorado.phet.statesofmatter.model.engine.NullMoleculeForceAndMotionCalculator;
import edu.colorado.phet.statesofmatter.model.engine.PhaseStateChanger;
import edu.colorado.phet.statesofmatter.model.engine.WaterAtomPositionUpdater;
import edu.colorado.phet.statesofmatter.model.engine.WaterPhaseStateChanger;
import edu.colorado.phet.statesofmatter.model.engine.WaterVerletAlgorithm;
import edu.colorado.phet.statesofmatter.model.engine.kinetic.AndersenThermostat;
import edu.colorado.phet.statesofmatter.model.engine.kinetic.IsokineticThermostat;
import edu.colorado.phet.statesofmatter.model.engine.kinetic.Thermostat;
import edu.colorado.phet.statesofmatter.model.particle.ArgonAtom;
import edu.colorado.phet.statesofmatter.model.particle.ConfigurableStatesOfMatterAtom;
import edu.colorado.phet.statesofmatter.model.particle.HydrogenAtom;
import edu.colorado.phet.statesofmatter.model.particle.HydrogenAtom2;
import edu.colorado.phet.statesofmatter.model.particle.NeonAtom;
import edu.colorado.phet.statesofmatter.model.particle.OxygenAtom;
import edu.colorado.phet.statesofmatter.model.particle.StatesOfMatterAtom;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class MultipleParticleModel
implements Resettable {
    private AtomPositionUpdater m_atomPositionUpdater;
    private MoleculeForceAndMotionCalculator m_moleculeForceAndMotionCalculator = new NullMoleculeForceAndMotionCalculator();
    private PhaseStateChanger m_phaseStateChanger;
    private Thermostat m_isoKineticThermostat;
    private Thermostat m_andersenThermostat;
    private double m_particleContainerHeight;
    private double m_targetContainerHeight;
    private double m_minAllowableContainerHeight;
    private final List m_particles = new ArrayList();
    private boolean m_isExploded = false;
    final ConstantDtClock m_clock;
    private final ArrayList m_listeners = new ArrayList();
    private MoleculeForceAndMotionDataSet m_moleculeDataSet;
    private double m_normalizedContainerWidth;
    private double m_normalizedContainerHeight;
    private final Random m_rand = new Random();
    private double m_temperatureSetPoint;
    private double m_gravitationalAcceleration;
    private double m_heatingCoolingAmount;
    private int m_tempAdjustTickCounter;
    private int m_currentMolecule;
    private double m_particleDiameter;
    private int m_thermostatType;
    private int m_heightChangeCounter;
    private double m_minModelTemperature;

    public MultipleParticleModel(ConstantDtClock constantDtClock) {
        this.m_clock = constantDtClock;
        this.m_heightChangeCounter = 0;
        this.setThermostatType(3);
        constantDtClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                MultipleParticleModel.this.step();
            }

            public void simulationTimeReset(ClockEvent clockEvent) {
                MultipleParticleModel.this.reset();
            }
        });
        this.m_particleDiameter = 1.0;
        this.resetContainerSize();
        this.m_currentMolecule = 1;
    }

    public ConstantDtClock getClock() {
        return this.m_clock;
    }

    public int getNumMolecules() {
        return this.m_particles.size() / this.m_moleculeDataSet.getAtomsPerMolecule();
    }

    public Rectangle2D getParticleContainerRect() {
        return new Rectangle2D.Double(0.0, 0.0, 10000.0, this.m_particleContainerHeight);
    }

    public void setTemperature(double d) {
        this.m_temperatureSetPoint = d > 50.0 ? 50.0 : (d < 1.0E-4 ? 1.0E-4 : d);
        if (this.m_isoKineticThermostat != null) {
            this.m_isoKineticThermostat.setTargetTemperature(d);
        }
        if (this.m_andersenThermostat != null) {
            this.m_andersenThermostat.setTargetTemperature(d);
        }
        this.notifyTemperatureChanged();
    }

    public double getTemperatureSetPoint() {
        return this.m_temperatureSetPoint;
    }

    public double getTemperatureInKelvin() {
        return this.convertInternalTemperatureToKelvin();
    }

    public double getGravitationalAcceleration() {
        return this.m_gravitationalAcceleration;
    }

    public void setGravitationalAcceleration(double d) {
        if (d > 0.4) {
            System.err.println("WARNING: Attempt to set out-of-range value for gravitational acceleration.");
            assert (false);
            this.m_gravitationalAcceleration = 0.4;
        } else if (d < 0.0) {
            System.err.println("WARNING: Attempt to set out-of-range value for gravitational acceleration.");
            assert (false);
            this.m_gravitationalAcceleration = 0.0;
        } else {
            this.m_gravitationalAcceleration = d;
        }
    }

    public double getModelPressure() {
        return this.m_moleculeForceAndMotionCalculator.getPressure();
    }

    public int getMoleculeType() {
        return this.m_currentMolecule;
    }

    public boolean getContainerExploded() {
        return this.m_isExploded;
    }

    public void explodeContainer() {
        this.setContainerExploded(true);
    }

    private void setContainerExploded(boolean bl) {
        if (this.m_isExploded != bl) {
            this.m_isExploded = bl;
            this.notifyContainerExplodedStateChanged(this.m_isExploded);
            if (!this.m_isExploded) {
                this.resetContainerSize();
            }
        }
    }

    public void returnLid() {
        Cloneable cloneable;
        int n;
        if (!this.m_isExploded) {
            System.out.println(this.getClass().getName() + " - Warning: Ignoring attempt to return lid when container hadn't exploded.");
            return;
        }
        do {
            for (n = 0; !(n >= this.m_moleculeDataSet.getNumberOfMolecules() || ((Point2D)(cloneable = this.m_moleculeDataSet.getMoleculeCenterOfMassPositions()[n])).getX() < 0.0 || ((Point2D)cloneable).getX() > this.m_normalizedContainerWidth || ((Point2D)cloneable).getY() < 0.0 || ((Point2D)cloneable).getY() > 10000.0 / this.m_particleDiameter); ++n) {
            }
            if (n >= this.m_moleculeDataSet.getNumberOfMolecules()) continue;
            this.m_moleculeDataSet.removeMolecule(n);
        } while (n != this.m_moleculeDataSet.getNumberOfMolecules());
        cloneable = new ArrayList(this.m_particles);
        for (int i = 0; i < ((ArrayList)cloneable).size() - this.m_moleculeDataSet.getNumberOfAtoms(); ++i) {
            StatesOfMatterAtom statesOfMatterAtom = (StatesOfMatterAtom)((ArrayList)cloneable).get(i);
            this.m_particles.remove(statesOfMatterAtom);
            statesOfMatterAtom.removedFromModel();
        }
        this.setContainerExploded(false);
        this.m_phaseStateChanger.setPhase(3);
    }

    public void setMoleculeType(int n) {
        if (n != 4 && n != 1 && n != 2 && n != 5 && n != 6) {
            System.err.println("ERROR: Unsupported molecule type.");
            assert (false);
            n = 1;
        }
        int n2 = this.mapTemperatureToPhase();
        this.removeAllParticles();
        this.initializeModelParameters();
        this.m_currentMolecule = n;
        switch (this.m_currentMolecule) {
            case 4: {
                this.m_particleDiameter = 324.0;
                this.m_minModelTemperature = 0.0024074074074074076;
                break;
            }
            case 1: {
                this.m_particleDiameter = 308.0;
                this.m_minModelTemperature = 0.005652173913043478;
                break;
            }
            case 2: {
                this.m_particleDiameter = 362.0;
                this.m_minModelTemperature = 0.0017333333333333335;
                break;
            }
            case 5: {
                this.m_particleDiameter = 469.8;
                this.m_minModelTemperature = 4.761904761904762E-4;
                break;
            }
            case 6: {
                this.m_particleDiameter = 350.0;
                this.m_minModelTemperature = 0.0017333333333333335;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.resetContainerSize();
        this.initializeParticles(n2);
        this.notifyMoleculeTypeChanged();
        this.notifyInteractionStrengthChanged();
    }

    public int getThermostatType() {
        return this.m_thermostatType;
    }

    public void setThermostatType(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Thermostat type setting out of range: " + n);
        }
        this.m_thermostatType = n;
    }

    public double getNormalizedContainerWidth() {
        return this.m_normalizedContainerWidth;
    }

    public double getNormalizedContainerHeight() {
        return this.m_normalizedContainerHeight;
    }

    public double getParticleContainerHeight() {
        return this.m_particleContainerHeight;
    }

    public void setTargetParticleContainerHeight(double d) {
        this.m_targetContainerHeight = d = MathUtil.clamp(this.m_minAllowableContainerHeight, d, 10000.0);
    }

    public double getSigma() {
        double d;
        switch (this.m_currentMolecule) {
            case 1: {
                d = 308.0;
                break;
            }
            case 2: {
                d = 362.0;
                break;
            }
            case 4: {
                d = 365.0;
                break;
            }
            case 3: {
                d = 324.0;
                break;
            }
            case 5: {
                d = 444.0;
                break;
            }
            case 6: {
                d = 350.0;
                break;
            }
            default: {
                System.err.println("Error: Unrecognized molecule type when setting sigma value.");
                d = 0.0;
            }
        }
        return d;
    }

    public double getEpsilon() {
        double d;
        switch (this.m_currentMolecule) {
            case 1: {
                d = InteractionStrengthTable.getInteractionPotential(AtomType.NEON, AtomType.NEON);
                break;
            }
            case 2: {
                d = InteractionStrengthTable.getInteractionPotential(AtomType.ARGON, AtomType.ARGON);
                break;
            }
            case 4: {
                d = 113.0;
                break;
            }
            case 3: {
                d = InteractionStrengthTable.getInteractionPotential(AtomType.OXYGEN, AtomType.OXYGEN);
                break;
            }
            case 5: {
                d = 200.0;
                break;
            }
            case 6: {
                d = this.convertScaledEpsilonToEpsilon(this.m_moleculeForceAndMotionCalculator.getScaledEpsilon());
                break;
            }
            default: {
                System.err.println("Error: Unrecognized molecule type when getting epsilon value.");
                d = 0.0;
            }
        }
        return d;
    }

    public void setEpsilon(double d) {
        if (this.m_currentMolecule == 6) {
            if (d < 49.199999999999996) {
                d = 49.199999999999996;
            } else if (d > 200.0) {
                d = 200.0;
            }
            this.m_moleculeForceAndMotionCalculator.setScaledEpsilon(this.convertEpsilonToScaledEpsilon(d));
            this.notifyInteractionStrengthChanged();
        } else {
            System.err.println("Error: Epsilon cannot be set when non-configurable molecule is in use.");
        }
    }

    public MoleculeForceAndMotionDataSet getMoleculeDataSetRef() {
        return this.m_moleculeDataSet;
    }

    public void reset() {
        this.initializeModelParameters();
        this.setMoleculeType(1);
        this.notifyResetOccurred();
    }

    public void setPhase(int n) {
        switch (n) {
            case 1: {
                this.m_phaseStateChanger.setPhase(1);
                break;
            }
            case 2: {
                this.m_phaseStateChanger.setPhase(2);
                break;
            }
            case 3: {
                this.m_phaseStateChanger.setPhase(3);
                break;
            }
            default: {
                System.err.println("Error: Invalid state specified.");
                this.m_phaseStateChanger.setPhase(1);
            }
        }
        this.syncParticlePositions();
    }

    public void setHeatingCoolingAmount(double d) {
        assert (d <= 1.0 && d >= -1.0);
        this.m_heatingCoolingAmount = d * 0.025;
    }

    public void injectMolecule() {
        double d = StatesOfMatterConstants.CONTAINER_BOUNDS.width / this.m_particleDiameter * 0.95;
        double d2 = StatesOfMatterConstants.CONTAINER_BOUNDS.height / this.m_particleDiameter * 0.5;
        if (this.m_moleculeDataSet.getNumberOfRemainingSlots() > 1 && this.m_normalizedContainerHeight > d2 * 1.05 && !this.m_isExploded) {
            int n;
            double d3 = Math.PI + (this.m_rand.nextDouble() - 0.5) * 2.5132741228718345;
            double d4 = 0.5 + this.m_rand.nextDouble() * 1.5;
            double d5 = Math.cos(d3) * d4;
            double d6 = Math.sin(d3) * d4;
            int n2 = this.m_moleculeDataSet.getAtomsPerMolecule();
            Point2D.Double double_ = new Point2D.Double(d, d2);
            Vector2D vector2D = new Vector2D(d5, d6);
            double d7 = (this.m_rand.nextDouble() - 0.5) * 1.5707963267948966;
            Point2D[] point2DArray = new Point2D[n2];
            for (n = 0; n < n2; ++n) {
                point2DArray[n] = new Point2D.Double();
            }
            this.m_moleculeDataSet.addMolecule(point2DArray, double_, vector2D, d7);
            this.m_atomPositionUpdater.updateAtomPositions(this.m_moleculeDataSet);
            if (this.m_moleculeDataSet.getAtomsPerMolecule() == 1) {
                StatesOfMatterAtom statesOfMatterAtom;
                switch (this.m_currentMolecule) {
                    case 2: {
                        statesOfMatterAtom = new ArgonAtom(0.0, 0.0);
                        break;
                    }
                    case 1: {
                        statesOfMatterAtom = new NeonAtom(0.0, 0.0);
                        break;
                    }
                    case 6: {
                        statesOfMatterAtom = new ConfigurableStatesOfMatterAtom(0.0, 0.0);
                        break;
                    }
                    default: {
                        statesOfMatterAtom = new NeonAtom(0.0, 0.0);
                    }
                }
                this.m_particles.add(statesOfMatterAtom);
                this.notifyParticleAdded(statesOfMatterAtom);
            } else if (this.m_moleculeDataSet.getAtomsPerMolecule() == 2) {
                assert (this.m_currentMolecule == 4);
                for (n = 0; n < n2; ++n) {
                    OxygenAtom oxygenAtom = new OxygenAtom(0.0, 0.0);
                    this.m_particles.add(oxygenAtom);
                    this.notifyParticleAdded(oxygenAtom);
                    point2DArray[n] = new Point2D.Double();
                }
            } else if (n2 == 3) {
                assert (this.m_currentMolecule == 5);
                StatesOfMatterAtom statesOfMatterAtom = new OxygenAtom(0.0, 0.0);
                this.m_particles.add(statesOfMatterAtom);
                this.notifyParticleAdded(statesOfMatterAtom);
                point2DArray[0] = new Point2D.Double();
                statesOfMatterAtom = new HydrogenAtom(0.0, 0.0);
                this.m_particles.add(statesOfMatterAtom);
                this.notifyParticleAdded(statesOfMatterAtom);
                point2DArray[1] = new Point2D.Double();
                statesOfMatterAtom = new HydrogenAtom(0.0, 0.0);
                this.m_particles.add(statesOfMatterAtom);
                this.notifyParticleAdded(statesOfMatterAtom);
                point2DArray[2] = new Point2D.Double();
            }
            if (this.m_particles.size() == 1) {
                this.notifyTemperatureChanged();
            }
            this.syncParticlePositions();
        }
        this.calculateMinAllowableContainerHeight();
    }

    public void addListener(Listener listener) {
        if (this.m_listeners.contains(listener)) {
            return;
        }
        this.m_listeners.add(listener);
    }

    private void removeAllParticles() {
        for (Object e : this.m_particles) {
            StatesOfMatterAtom statesOfMatterAtom = (StatesOfMatterAtom)e;
            statesOfMatterAtom.removedFromModel();
        }
        this.m_particles.clear();
        this.m_moleculeDataSet = null;
    }

    private void calculateMinAllowableContainerHeight() {
        this.m_minAllowableContainerHeight = (double)this.m_moleculeDataSet.getNumberOfMolecules() / this.m_normalizedContainerWidth * this.m_particleDiameter;
    }

    private void initializeParticles(int n) {
        switch (this.m_currentMolecule) {
            case 4: {
                this.initializeDiatomic(this.m_currentMolecule, n);
                break;
            }
            case 1: {
                this.initializeMonatomic(this.m_currentMolecule, n);
                break;
            }
            case 2: {
                this.initializeMonatomic(this.m_currentMolecule, n);
                break;
            }
            case 6: {
                this.initializeMonatomic(this.m_currentMolecule, n);
                break;
            }
            case 5: {
                this.initializeTriatomic(this.m_currentMolecule, n);
                break;
            }
            default: {
                System.err.println("ERROR: Unrecognized particle type, using default.");
            }
        }
        this.notifyPressureChanged();
        this.calculateMinAllowableContainerHeight();
    }

    private void initializeModelParameters() {
        this.m_gravitationalAcceleration = 0.045;
        this.m_heatingCoolingAmount = 0.0;
        this.m_tempAdjustTickCounter = 0;
        this.m_temperatureSetPoint = 0.15;
        this.setContainerExploded(false);
    }

    private void resetContainerSize() {
        this.m_particleContainerHeight = 10000.0;
        this.m_targetContainerHeight = 10000.0;
        this.m_normalizedContainerHeight = this.m_particleContainerHeight / this.m_particleDiameter;
        this.m_normalizedContainerWidth = 10000.0 / this.m_particleDiameter;
        this.notifyContainerSizeChanged();
    }

    public void step() {
        double d;
        if (!this.m_isExploded) {
            if (this.m_targetContainerHeight != this.m_particleContainerHeight) {
                this.m_heightChangeCounter = 25;
                d = this.m_targetContainerHeight - this.m_particleContainerHeight;
                this.m_particleContainerHeight = d > 0.0 ? (this.m_particleContainerHeight + d <= 10000.0 ? (this.m_particleContainerHeight += Math.min(d, 200.0)) : 10000.0) : (this.m_particleContainerHeight - d >= this.m_minAllowableContainerHeight ? (this.m_particleContainerHeight += Math.max(d, -50.0)) : this.m_minAllowableContainerHeight);
                this.m_normalizedContainerHeight = this.m_particleContainerHeight / this.m_particleDiameter;
                this.notifyContainerSizeChanged();
            } else if (this.m_heightChangeCounter > 0) {
                --this.m_heightChangeCounter;
            }
        } else if (this.m_particleContainerHeight < 100000.0) {
            this.m_particleContainerHeight += 200.0;
            this.notifyContainerSizeChanged();
        }
        d = this.getModelPressure();
        for (int i = 0; i < 8; ++i) {
            this.m_moleculeForceAndMotionCalculator.updateForcesAndMotion();
            this.runThermostat();
        }
        this.syncParticlePositions();
        if (this.getModelPressure() != d) {
            this.notifyPressureChanged();
        }
        ++this.m_tempAdjustTickCounter;
        if (this.m_tempAdjustTickCounter > 10 && this.m_heatingCoolingAmount != 0.0) {
            this.m_tempAdjustTickCounter = 0;
            double d2 = this.m_temperatureSetPoint + this.m_heatingCoolingAmount;
            if (d2 >= 50.0) {
                d2 = 50.0;
            } else if (d2 <= 0.135 && this.m_heatingCoolingAmount < 0.0) {
                d2 = this.m_temperatureSetPoint * 0.95;
            } else if (d2 <= this.m_minModelTemperature) {
                d2 = this.m_minModelTemperature;
            }
            this.m_temperatureSetPoint = d2;
            this.m_isoKineticThermostat.setTargetTemperature(this.m_temperatureSetPoint);
            this.m_andersenThermostat.setTargetTemperature(this.m_temperatureSetPoint);
            this.notifyTemperatureChanged();
        }
    }

    private void runThermostat() {
        if (this.m_isExploded) {
            return;
        }
        double d = this.m_moleculeForceAndMotionCalculator.getTemperature();
        boolean bl = false;
        if (this.m_heatingCoolingAmount != 0.0 || this.m_temperatureSetPoint + 0.15 < d || this.m_temperatureSetPoint - 0.15 > d) {
            bl = true;
        }
        if (this.m_heightChangeCounter != 0 && this.particlesNearTop()) {
            this.setTemperature(this.m_moleculeDataSet.calculateTemperatureFromKineticEnergy());
        } else if (this.m_thermostatType == 1 || this.m_thermostatType == 3 && (bl || this.m_temperatureSetPoint > 0.34)) {
            this.m_isoKineticThermostat.adjustTemperature();
        } else if (this.m_thermostatType == 2 || this.m_thermostatType == 3 && !bl) {
            this.m_andersenThermostat.adjustTemperature();
        }
    }

    private void initializeMonatomic(int n, int n2) {
        double d;
        assert (n == 1 || n == 2 || n == 6);
        if (n == 1) {
            d = 308.0;
        } else if (n == 2) {
            d = 362.0;
        } else if (n == 6) {
            d = 350.0;
        } else {
            n = 1;
            d = 308.0;
        }
        int n3 = (int)Math.pow(Math.round(StatesOfMatterConstants.CONTAINER_BOUNDS.width / (d * 1.05 * 3.0)), 2.0);
        this.m_moleculeDataSet = new MoleculeForceAndMotionDataSet(1);
        this.m_phaseStateChanger = new MonatomicPhaseStateChanger(this);
        this.m_atomPositionUpdater = new MonatomicAtomPositionUpdater();
        this.m_moleculeForceAndMotionCalculator = new MonatomicVerletAlgorithm(this);
        this.m_isoKineticThermostat = new IsokineticThermostat(this.m_moleculeDataSet, this.m_minModelTemperature);
        this.m_andersenThermostat = new AndersenThermostat(this.m_moleculeDataSet, this.m_minModelTemperature);
        for (int i = 0; i < n3; ++i) {
            Point2D.Double double_ = new Point2D.Double();
            Vector2D vector2D = new Vector2D();
            Point2D[] point2DArray = new Point2D[]{new Point2D.Double()};
            this.m_moleculeDataSet.addMolecule(point2DArray, double_, vector2D, 0.0);
            StatesOfMatterAtom statesOfMatterAtom = n == 1 ? new NeonAtom(0.0, 0.0) : (n == 2 ? new ArgonAtom(0.0, 0.0) : (n == 6 ? new ConfigurableStatesOfMatterAtom(0.0, 0.0) : new NeonAtom(0.0, 0.0)));
            this.m_particles.add(statesOfMatterAtom);
            this.notifyParticleAdded(statesOfMatterAtom);
        }
        this.setPhase(n2);
        if (this.getMoleculeType() == 6) {
            this.setTemperature(0.33);
        }
    }

    private void initializeDiatomic(int n, int n2) {
        assert (n == 4);
        int n3 = (int)Math.pow(Math.round(StatesOfMatterConstants.CONTAINER_BOUNDS.width / 1020.5999999999999), 2.0);
        if (n3 % 2 != 0) {
            --n3;
        }
        int n4 = n3 / 2;
        this.m_moleculeDataSet = new MoleculeForceAndMotionDataSet(2);
        this.m_phaseStateChanger = new DiatomicPhaseStateChanger(this);
        this.m_atomPositionUpdater = new DiatomicAtomPositionUpdater();
        this.m_moleculeForceAndMotionCalculator = new DiatomicVerletAlgorithm(this);
        this.m_isoKineticThermostat = new IsokineticThermostat(this.m_moleculeDataSet, this.m_minModelTemperature);
        this.m_andersenThermostat = new AndersenThermostat(this.m_moleculeDataSet, this.m_minModelTemperature);
        for (int i = 0; i < n4; ++i) {
            Point2D.Double double_ = new Point2D.Double();
            Vector2D vector2D = new Vector2D();
            Point2D[] point2DArray = new Point2D[]{new Point2D.Double(), new Point2D.Double()};
            this.m_moleculeDataSet.addMolecule(point2DArray, double_, vector2D, 0.0);
            OxygenAtom oxygenAtom = new OxygenAtom(0.0, 0.0);
            this.m_particles.add(oxygenAtom);
            this.notifyParticleAdded(oxygenAtom);
            oxygenAtom = new OxygenAtom(0.0, 0.0);
            this.m_particles.add(oxygenAtom);
            this.notifyParticleAdded(oxygenAtom);
        }
        this.setPhase(n2);
    }

    private void initializeTriatomic(int n, int n2) {
        assert (n == 5);
        double d = 340.2;
        int n3 = (int)Math.round(StatesOfMatterConstants.CONTAINER_BOUNDS.width / (d * 1.2));
        int n4 = (int)Math.pow(n3 / 3, 2.0);
        this.m_moleculeDataSet = new MoleculeForceAndMotionDataSet(3);
        this.m_phaseStateChanger = new WaterPhaseStateChanger(this);
        this.m_atomPositionUpdater = new WaterAtomPositionUpdater();
        this.m_moleculeForceAndMotionCalculator = new WaterVerletAlgorithm(this);
        this.m_isoKineticThermostat = new IsokineticThermostat(this.m_moleculeDataSet, this.m_minModelTemperature);
        this.m_andersenThermostat = new AndersenThermostat(this.m_moleculeDataSet, this.m_minModelTemperature);
        for (int i = 0; i < n4; ++i) {
            Point2D.Double double_ = new Point2D.Double();
            Vector2D vector2D = new Vector2D();
            Point2D[] point2DArray = new Point2D[]{new Point2D.Double(), new Point2D.Double(), new Point2D.Double()};
            this.m_moleculeDataSet.addMolecule(point2DArray, double_, vector2D, 0.0);
            StatesOfMatterAtom statesOfMatterAtom = new OxygenAtom(0.0, 0.0);
            this.m_particles.add(statesOfMatterAtom);
            this.notifyParticleAdded(statesOfMatterAtom);
            statesOfMatterAtom = new HydrogenAtom(0.0, 0.0);
            this.m_particles.add(statesOfMatterAtom);
            this.notifyParticleAdded(statesOfMatterAtom);
            if (i % 2 == 0) {
                statesOfMatterAtom = new HydrogenAtom(0.0, 0.0);
                this.m_particles.add(statesOfMatterAtom);
                this.notifyParticleAdded(statesOfMatterAtom);
                continue;
            }
            statesOfMatterAtom = new HydrogenAtom2(0.0, 0.0);
            this.m_particles.add(statesOfMatterAtom);
            this.notifyParticleAdded(statesOfMatterAtom);
        }
        this.setPhase(n2);
    }

    private void notifyResetOccurred() {
        for (Object e : this.m_listeners) {
            ((Listener)e).resetOccurred();
        }
    }

    private void notifyParticleAdded(StatesOfMatterAtom statesOfMatterAtom) {
        for (Object e : this.m_listeners) {
            ((Listener)e).particleAdded(statesOfMatterAtom);
        }
    }

    private void notifyTemperatureChanged() {
        for (Object e : this.m_listeners) {
            ((Listener)e).temperatureChanged();
        }
    }

    private void notifyPressureChanged() {
        for (Object e : this.m_listeners) {
            ((Listener)e).pressureChanged();
        }
    }

    private void notifyContainerSizeChanged() {
        for (Object e : this.m_listeners) {
            ((Listener)e).containerSizeChanged();
        }
    }

    private void notifyMoleculeTypeChanged() {
        for (Object e : this.m_listeners) {
            ((Listener)e).moleculeTypeChanged();
        }
    }

    private void notifyContainerExplodedStateChanged(boolean bl) {
        for (Object e : this.m_listeners) {
            ((Listener)e).containerExplodedStateChanged(bl);
        }
    }

    private void notifyInteractionStrengthChanged() {
        for (Object e : this.m_listeners) {
            ((Listener)e).interactionStrengthChanged();
        }
    }

    private void syncParticlePositions() {
        double d = this.m_particleDiameter;
        Point2D[] point2DArray = this.m_moleculeDataSet.getAtomPositions();
        for (int i = 0; i < this.m_moleculeDataSet.getNumberOfAtoms(); ++i) {
            ((StatesOfMatterAtom)this.m_particles.get(i)).setPosition(point2DArray[i].getX() * d, point2DArray[i].getY() * d);
        }
        if (this.m_moleculeDataSet.getNumberOfAtoms() != this.m_particles.size()) {
            System.out.println("Inconsistent number of normalized versus non-normalized particles.");
        }
    }

    private double convertInternalTemperatureToKelvin() {
        double d;
        if (this.m_particles.size() == 0) {
            return 0.0;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        switch (this.m_currentMolecule) {
            case 1: {
                d2 = 23.0;
                d3 = 44.0;
                break;
            }
            case 2: {
                d2 = 75.0;
                d3 = 151.0;
                break;
            }
            case 6: {
                d2 = 75.0;
                d3 = 140.0;
                break;
            }
            case 5: {
                d2 = 273.0;
                d3 = 647.0;
                break;
            }
            case 4: {
                d2 = 54.0;
                d3 = 155.0;
                break;
            }
        }
        if (this.m_temperatureSetPoint <= this.m_minModelTemperature) {
            d = 0.0;
        } else if (this.m_temperatureSetPoint < 0.26) {
            d = this.m_temperatureSetPoint * d2 / 0.26;
            if (d < 0.5) {
                d = 0.5;
            }
        } else if (this.m_temperatureSetPoint < 0.8) {
            double d4 = (d3 - d2) / 0.54;
            double d5 = d2 - d4 * 0.26;
            d = this.m_temperatureSetPoint * d4 + d5;
        } else {
            d = this.m_temperatureSetPoint * d3 / 0.8;
        }
        return d;
    }

    public double getPressureInAtmospheres() {
        double d;
        switch (this.m_currentMolecule) {
            case 1: {
                d = 200.0 * this.getModelPressure();
                break;
            }
            case 2: {
                d = 125.0 * this.getModelPressure();
                break;
            }
            case 6: {
                d = 125.0 * this.getModelPressure();
                break;
            }
            case 5: {
                d = 200.0 * this.getModelPressure();
                break;
            }
            case 4: {
                d = 125.0 * this.getModelPressure();
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    private boolean particlesNearTop() {
        Point2D[] point2DArray = this.m_moleculeDataSet.getMoleculeCenterOfMassPositions();
        double d = this.m_normalizedContainerHeight - 2.5;
        boolean bl = false;
        for (int i = 0; i < this.m_moleculeDataSet.getNumberOfMolecules(); ++i) {
            if (!(point2DArray[i].getY() > d)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private int mapTemperatureToPhase() {
        int n = this.m_temperatureSetPoint < 0.245 ? 1 : (this.m_temperatureSetPoint < 0.6699999999999999 ? 2 : 3);
        return n;
    }

    private double convertEpsilonToScaledEpsilon(double d) {
        return d / 225.0;
    }

    private double convertScaledEpsilonToEpsilon(double d) {
        double d2 = d * 450.0 / 2.0;
        return d2;
    }

    public static class Adapter
    implements Listener {
        public void resetOccurred() {
        }

        public void particleAdded(StatesOfMatterAtom statesOfMatterAtom) {
        }

        public void temperatureChanged() {
        }

        public void pressureChanged() {
        }

        public void containerSizeChanged() {
        }

        public void moleculeTypeChanged() {
        }

        public void containerExplodedStateChanged(boolean bl) {
        }

        public void interactionStrengthChanged() {
        }
    }

    public static interface Listener {
        public void resetOccurred();

        public void particleAdded(StatesOfMatterAtom var1);

        public void temperatureChanged();

        public void pressureChanged();

        public void containerSizeChanged();

        public void moleculeTypeChanged();

        public void containerExplodedStateChanged(boolean var1);

        public void interactionStrengthChanged();
    }
}

