/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.model;

import edu.colorado.phet.statesofmatter.model.AtomType;

public class InteractionStrengthTable {
    static double getInteractionPotential(AtomType atomType, AtomType atomType2) {
        if (atomType == atomType2) {
            if (atomType == AtomType.NEON) {
                return 35.8;
            }
            if (atomType == AtomType.ARGON) {
                return 111.84;
            }
            if (atomType == AtomType.OXYGEN) {
                return 423.3;
            }
            if (atomType == AtomType.ADJUSTABLE) {
                return 225.0;
            }
            System.err.println("Error: Interaction potential not available for requested atom: " + atomType);
            assert (false);
            return 225.0;
        }
        if (atomType == AtomType.NEON && atomType2 == AtomType.ARGON || atomType == AtomType.ARGON && atomType2 == AtomType.NEON) {
            return 59.5;
        }
        if (atomType == AtomType.NEON && atomType2 == AtomType.OXYGEN || atomType == AtomType.OXYGEN && atomType2 == AtomType.NEON) {
            return 51.0;
        }
        if (atomType == AtomType.ARGON && atomType2 == AtomType.OXYGEN || atomType == AtomType.OXYGEN && atomType2 == AtomType.ARGON) {
            return 85.0;
        }
        if (atomType == AtomType.ADJUSTABLE || atomType2 == AtomType.ADJUSTABLE) {
            return 215.0;
        }
        System.err.println("Error: Do not have data for this combination of molecules, using default.");
        System.err.println("       atomType1 = " + atomType + ", atomType2 = " + atomType2);
        return 215.0;
    }
}

