/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.statesofmatter.model.AtomFactory;
import edu.colorado.phet.statesofmatter.model.AtomType;
import edu.colorado.phet.statesofmatter.model.InteractionStrengthTable;
import edu.colorado.phet.statesofmatter.model.LjPotentialCalculator;
import edu.colorado.phet.statesofmatter.model.SigmaTable;
import edu.colorado.phet.statesofmatter.model.particle.ConfigurableStatesOfMatterAtom;
import edu.colorado.phet.statesofmatter.model.particle.StatesOfMatterAtom;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;

public class DualAtomModel {
    private static final AtomType DEFAULT_ATOM_TYPE = AtomType.NEON;
    private final ArrayList<Listener> m_listeners = new ArrayList();
    private StatesOfMatterAtom m_fixedAtom;
    private StatesOfMatterAtom m_movableAtom;
    private StatesOfMatterAtom m_shadowMovableAtom;
    private double m_attractiveForce;
    private double m_repulsiveForce;
    private boolean m_motionPaused;
    private final LjPotentialCalculator m_ljPotentialCalculator;
    private double m_timeStep;
    private final StatesOfMatterAtom.Adapter m_movableAtomListener;
    private boolean m_settingBothAtomTypes = false;
    private int m_bondingState = 0;
    private int m_vibrationCounter = 0;
    private double m_potentialWhenAtomReleased = 0.0;
    private final Random m_rand = new Random();
    private double m_bondedOscillationRightDistance;
    private double m_bondedOscillationLeftDistance;
    private double m_minPotentialDistance;
    private final ConstantDtClock m_clock;

    public DualAtomModel(ConstantDtClock constantDtClock) {
        this.m_clock = constantDtClock;
        this.m_motionPaused = false;
        this.m_ljPotentialCalculator = new LjPotentialCalculator(75.0, 20.0);
        this.updateTimeStep();
        constantDtClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                DualAtomModel.this.handleClockTicked(clockEvent);
            }

            public void simulationTimeReset(ClockEvent clockEvent) {
                DualAtomModel.this.reset();
            }
        });
        this.m_movableAtomListener = new StatesOfMatterAtom.Adapter(){

            public void positionChanged() {
                if (DualAtomModel.this.m_motionPaused) {
                    try {
                        DualAtomModel.this.m_shadowMovableAtom = (StatesOfMatterAtom)DualAtomModel.this.m_movableAtom.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        cloneNotSupportedException.printStackTrace();
                        return;
                    }
                    DualAtomModel.this.updateForces();
                }
            }
        };
        this.reset();
    }

    public StatesOfMatterAtom getFixedAtomRef() {
        return this.m_fixedAtom;
    }

    public StatesOfMatterAtom getMovableAtomRef() {
        return this.m_movableAtom;
    }

    public double getAttractiveForce() {
        return this.m_attractiveForce;
    }

    public double getRepulsiveForce() {
        return this.m_repulsiveForce;
    }

    public AtomType getFixedAtomType() {
        return this.m_fixedAtom.getType();
    }

    public AtomType getMovableAtomType() {
        return this.m_movableAtom.getType();
    }

    public void setFixedAtomType(AtomType atomType) {
        if (this.m_fixedAtom == null || this.m_fixedAtom.getType() != atomType) {
            if (!this.m_settingBothAtomTypes && (atomType == AtomType.ADJUSTABLE && this.m_movableAtom.getType() != AtomType.ADJUSTABLE || atomType != AtomType.ADJUSTABLE && this.m_movableAtom.getType() == AtomType.ADJUSTABLE)) {
                System.err.println(this.getClass().getName() + " - Error: Cannot set just one atom to be adjustable, ignoring request.");
                return;
            }
            this.ensureValidAtomType(atomType);
            this.m_bondingState = 0;
            if (this.m_fixedAtom != null) {
                this.notifyFixedAtomRemoved(this.m_fixedAtom);
                this.m_fixedAtom = null;
            }
            this.m_fixedAtom = AtomFactory.createAtom(atomType);
            if (this.m_movableAtom != null) {
                this.m_ljPotentialCalculator.setSigma(SigmaTable.getSigma(this.getFixedAtomType(), this.getMovableAtomType()));
            }
            if (this.m_movableAtom != null) {
                this.m_ljPotentialCalculator.setEpsilon(InteractionStrengthTable.getInteractionPotential(this.m_fixedAtom.getType(), this.m_movableAtom.getType()));
            }
            this.notifyFixedAtomAdded(this.m_fixedAtom);
            this.notifyInteractionPotentialChanged();
            this.notifyFixedAtomDiameterChanged();
            this.m_fixedAtom.setPosition(0.0, 0.0);
            this.resetMovableAtomPos();
        }
    }

    public void setMovableAtomType(AtomType atomType) {
        if (this.m_movableAtom == null || this.m_movableAtom.getType() != atomType) {
            if (!this.m_settingBothAtomTypes && (atomType == AtomType.ADJUSTABLE && this.m_movableAtom.getType() != AtomType.ADJUSTABLE || atomType != AtomType.ADJUSTABLE && this.m_movableAtom.getType() == AtomType.ADJUSTABLE)) {
                System.err.println(this.getClass().getName() + " - Error: Cannot set just one atom to be adjustable, ignoring request.");
                return;
            }
            this.ensureValidAtomType(atomType);
            this.m_bondingState = 0;
            if (this.m_movableAtom != null) {
                this.notifyMovableAtomRemoved(this.m_movableAtom);
                this.m_movableAtom.removeListener(this.m_movableAtomListener);
                this.m_movableAtom = null;
            }
            this.m_movableAtom = AtomFactory.createAtom(atomType);
            this.m_movableAtom.addListener(this.m_movableAtomListener);
            if (this.m_movableAtom != null) {
                this.m_ljPotentialCalculator.setSigma(SigmaTable.getSigma(this.getFixedAtomType(), this.getMovableAtomType()));
            }
            if (this.m_fixedAtom != null) {
                this.m_ljPotentialCalculator.setEpsilon(InteractionStrengthTable.getInteractionPotential(this.m_fixedAtom.getType(), this.m_movableAtom.getType()));
            }
            this.notifyMovableAtomAdded(this.m_movableAtom);
            this.notifyInteractionPotentialChanged();
            this.notifyMovableAtomDiameterChanged();
            this.resetMovableAtomPos();
        }
    }

    private void ensureValidAtomType(AtomType atomType) {
        if (atomType != AtomType.NEON && atomType != AtomType.ARGON && atomType != AtomType.OXYGEN && atomType != AtomType.ADJUSTABLE) {
            System.err.println("Error: Unsupported atom type.");
            assert (false);
        }
    }

    public void setBothAtomTypes(AtomType atomType) {
        if (this.m_fixedAtom == null || this.m_movableAtom == null || this.m_fixedAtom.getType() != atomType || this.m_movableAtom.getType() != atomType) {
            this.m_settingBothAtomTypes = true;
            this.setFixedAtomType(atomType);
            this.setMovableAtomType(atomType);
            this.m_settingBothAtomTypes = false;
        }
    }

    public void setAdjustableAtomSigma(double d) {
        if (this.m_fixedAtom.getType() == AtomType.ADJUSTABLE && this.m_movableAtom.getType() == AtomType.ADJUSTABLE && d != this.m_ljPotentialCalculator.getSigma()) {
            if (d > 500.0) {
                d = 500.0;
            } else if (d < 75.0) {
                d = 75.0;
            }
            this.m_ljPotentialCalculator.setSigma(d);
            this.notifyInteractionPotentialChanged();
            this.m_movableAtom.setPosition(this.m_ljPotentialCalculator.calculateMinimumForceDistance(), 0.0);
            ((ConfigurableStatesOfMatterAtom)this.m_fixedAtom).setRadius(d / 2.0);
            this.notifyFixedAtomDiameterChanged();
            ((ConfigurableStatesOfMatterAtom)this.m_movableAtom).setRadius(d / 2.0);
            this.notifyMovableAtomDiameterChanged();
        }
    }

    public double getSigma() {
        return this.m_ljPotentialCalculator.getSigma();
    }

    public void setEpsilon(double d) {
        if (d < 20.0) {
            d = 20.0;
        } else if (d > 450.0) {
            d = 450.0;
        }
        if (this.m_fixedAtom.getType() == AtomType.ADJUSTABLE && this.m_movableAtom.getType() == AtomType.ADJUSTABLE) {
            this.m_ljPotentialCalculator.setEpsilon(d);
            this.notifyInteractionPotentialChanged();
        }
    }

    public double getEpsilon() {
        return this.m_ljPotentialCalculator.getEpsilon();
    }

    public int getBondingState() {
        return this.m_bondingState;
    }

    public void reset() {
        if (this.m_fixedAtom == null || this.m_fixedAtom.getType() != DEFAULT_ATOM_TYPE || this.m_movableAtom == null || this.m_movableAtom.getType() != DEFAULT_ATOM_TYPE) {
            this.setBothAtomTypes(DEFAULT_ATOM_TYPE);
        } else {
            this.resetMovableAtomPos();
        }
        this.m_motionPaused = false;
    }

    public void resetMovableAtomPos() {
        if (this.m_movableAtom != null) {
            this.m_movableAtom.setPosition(this.m_ljPotentialCalculator.calculateMinimumForceDistance(), 0.0);
            this.m_movableAtom.setVx(0.0);
            this.m_movableAtom.setAx(0.0);
        }
    }

    public void addListener(Listener listener) {
        if (this.m_listeners.contains(listener)) {
            return;
        }
        this.m_listeners.add(listener);
    }

    public void setMotionPaused(boolean bl) {
        this.m_motionPaused = bl;
        this.m_movableAtom.setVx(0.0);
        if (!bl) {
            this.m_potentialWhenAtomReleased = this.m_ljPotentialCalculator.calculatePotentialEnergy(this.m_movableAtom.getPositionReference().distance(this.m_fixedAtom.getPositionReference()));
        }
    }

    public boolean getMotionPaused() {
        return this.m_motionPaused;
    }

    public void releaseBond() {
        if (this.m_bondingState == 1) {
            this.m_vibrationCounter = 0;
        }
        this.m_bondingState = 0;
    }

    private void handleClockTicked(ClockEvent clockEvent) {
        try {
            this.m_shadowMovableAtom = (StatesOfMatterAtom)this.m_movableAtom.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return;
        }
        this.updateTimeStep();
        for (int i = 0; i < 8; ++i) {
            this.updateForces();
            if (this.m_bondingState == 2) continue;
            this.updateAtomMotion();
        }
        this.syncMovableAtomWithDummy();
        if (this.m_movableAtom.getType() == AtomType.OXYGEN && this.m_fixedAtom.getType() == AtomType.OXYGEN) {
            switch (this.m_bondingState) {
                case 0: {
                    if (!(this.m_movableAtom.getVx() > 100.0) || !(this.m_movableAtom.getPositionReference().distance(this.m_fixedAtom.getPositionReference()) < this.m_fixedAtom.getRadius() * 2.5)) break;
                    this.m_bondingState = 1;
                    this.startFixedAtomVibration();
                    break;
                }
                case 1: {
                    if (!(this.m_attractiveForce > this.m_repulsiveForce)) break;
                    this.m_movableAtom.setAx(0.0);
                    this.m_movableAtom.setVx(0.0);
                    this.m_minPotentialDistance = this.m_ljPotentialCalculator.calculateMinimumForceDistance();
                    this.m_bondedOscillationRightDistance = this.m_minPotentialDistance + 0.06 * this.m_movableAtom.getRadius();
                    this.m_bondedOscillationLeftDistance = this.approximateEquivalentPotentialDistance(this.m_bondedOscillationRightDistance);
                    this.m_bondingState = 2;
                    this.stepFixedAtomVibration();
                    break;
                }
                case 2: {
                    this.m_movableAtom.setAx(0.0);
                    this.m_movableAtom.setVx(0.0);
                    if (this.m_movableAtom.getPositionReference().getX() > this.m_minPotentialDistance) {
                        this.m_movableAtom.setPosition(this.m_bondedOscillationLeftDistance, 0.0);
                    } else {
                        this.m_movableAtom.setPosition(this.m_bondedOscillationRightDistance, 0.0);
                    }
                    if (!this.isFixedAtomVibrating()) break;
                    this.stepFixedAtomVibration();
                    break;
                }
                default: {
                    System.err.println(this.getClass().getName() + " - Error: Unrecognized bonding state.");
                    assert (false);
                    this.m_bondingState = 0;
                }
            }
        }
    }

    private void updateTimeStep() {
        this.m_timeStep = this.m_clock.getDt() / 1000.0 / 8.0;
    }

    private void syncMovableAtomWithDummy() {
        this.m_movableAtom.setAx(this.m_shadowMovableAtom.getAx());
        this.m_movableAtom.setVx(this.m_shadowMovableAtom.getVx());
        this.m_movableAtom.setPosition(this.m_shadowMovableAtom.getX(), this.m_shadowMovableAtom.getY());
    }

    private void updateForces() {
        double d = this.m_shadowMovableAtom.getPositionReference().distance(new Point2D.Double(0.0, 0.0));
        if (d < (this.m_fixedAtom.getRadius() + this.m_movableAtom.getRadius()) / 8.0) {
            d = (this.m_fixedAtom.getRadius() + this.m_movableAtom.getRadius()) / 8.0;
        }
        this.m_attractiveForce = this.m_ljPotentialCalculator.calculateAttractiveLjForce(d);
        this.m_repulsiveForce = this.m_ljPotentialCalculator.calculateRepulsiveLjForce(d);
    }

    private void updateAtomMotion() {
        double d = this.m_shadowMovableAtom.getMass() * 1.6605402E-27;
        double d2 = (this.m_repulsiveForce - this.m_attractiveForce) / d;
        this.m_shadowMovableAtom.setAx(d2);
        if (!this.m_motionPaused) {
            this.m_shadowMovableAtom.setVx(this.m_shadowMovableAtom.getVx() + d2 * this.m_timeStep);
            double d3 = this.m_shadowMovableAtom.getPositionReference().getX() + this.m_shadowMovableAtom.getVx() * this.m_timeStep;
            this.m_shadowMovableAtom.setPosition(d3, 0.0);
        }
    }

    private void startFixedAtomVibration() {
        this.m_vibrationCounter = 30;
    }

    private void stepFixedAtomVibration() {
        if (this.m_vibrationCounter > 0) {
            double d = 1.0;
            if (this.m_vibrationCounter < 7) {
                d = (double)this.m_vibrationCounter / 7.5;
            }
            if (this.m_fixedAtom.getPositionReference().getX() != 0.0) {
                this.m_fixedAtom.setPosition(0.0, 0.0);
            } else {
                double d2 = (this.m_rand.nextDouble() * 2.0 - 1.0) * this.m_potentialWhenAtomReleased * 5.0E21 * d;
                double d3 = (this.m_rand.nextDouble() * 2.0 - 1.0) * this.m_potentialWhenAtomReleased * 5.0E21 * d;
                this.m_fixedAtom.setPosition(d2, d3);
            }
            --this.m_vibrationCounter;
        } else if (this.m_fixedAtom.getPositionReference().getX() != 0.0 || this.m_fixedAtom.getPositionReference().getY() != 0.0) {
            this.m_fixedAtom.setPosition(0.0, 0.0);
        }
    }

    private double approximateEquivalentPotentialDistance(double d) {
        if (d < this.m_ljPotentialCalculator.calculateMinimumForceDistance()) {
            System.err.println(this.getClass().getName() + "- Error: Distance value out of range.");
            return 0.0;
        }
        double d2 = d - this.m_ljPotentialCalculator.getSigma();
        double d3 = d2 / 100.0;
        double d4 = this.m_ljPotentialCalculator.calculateLjPotential(d);
        double d5 = this.m_ljPotentialCalculator.calculateMinimumForceDistance();
        for (int i = 0; i < 100 && !(this.m_ljPotentialCalculator.calculateLjPotential(d5) > d4); ++i) {
            d5 -= d3;
        }
        return d5;
    }

    private boolean isFixedAtomVibrating() {
        return this.m_vibrationCounter > 0;
    }

    private void notifyFixedAtomAdded(StatesOfMatterAtom statesOfMatterAtom) {
        for (Listener listener : this.m_listeners) {
            listener.fixedAtomAdded(statesOfMatterAtom);
        }
    }

    private void notifyMovableAtomAdded(StatesOfMatterAtom statesOfMatterAtom) {
        for (Listener listener : this.m_listeners) {
            listener.movableAtomAdded(statesOfMatterAtom);
        }
    }

    private void notifyFixedAtomRemoved(StatesOfMatterAtom statesOfMatterAtom) {
        for (Listener listener : this.m_listeners) {
            listener.fixedAtomRemoved(statesOfMatterAtom);
        }
    }

    private void notifyMovableAtomRemoved(StatesOfMatterAtom statesOfMatterAtom) {
        for (Listener listener : this.m_listeners) {
            listener.movableAtomRemoved(statesOfMatterAtom);
        }
    }

    private void notifyInteractionPotentialChanged() {
        for (Listener listener : this.m_listeners) {
            listener.interactionPotentialChanged();
        }
    }

    private void notifyFixedAtomDiameterChanged() {
        for (Listener listener : this.m_listeners) {
            listener.fixedAtomDiameterChanged();
        }
    }

    private void notifyMovableAtomDiameterChanged() {
        for (Listener listener : this.m_listeners) {
            listener.movableAtomDiameterChanged();
        }
    }

    public ConstantDtClock getClock() {
        return this.m_clock;
    }

    public static class Adapter
    implements Listener {
        public void fixedAtomAdded(StatesOfMatterAtom statesOfMatterAtom) {
        }

        public void movableAtomAdded(StatesOfMatterAtom statesOfMatterAtom) {
        }

        public void fixedAtomRemoved(StatesOfMatterAtom statesOfMatterAtom) {
        }

        public void movableAtomRemoved(StatesOfMatterAtom statesOfMatterAtom) {
        }

        public void interactionPotentialChanged() {
        }

        public void fixedAtomDiameterChanged() {
        }

        public void movableAtomDiameterChanged() {
        }
    }

    public static interface Listener {
        public void fixedAtomAdded(StatesOfMatterAtom var1);

        public void movableAtomAdded(StatesOfMatterAtom var1);

        public void fixedAtomRemoved(StatesOfMatterAtom var1);

        public void movableAtomRemoved(StatesOfMatterAtom var1);

        public void interactionPotentialChanged();

        public void fixedAtomDiameterChanged();

        public void movableAtomDiameterChanged();
    }
}

