/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.developer;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.ModuleEvent;
import edu.colorado.phet.common.phetcommon.application.ModuleObserver;
import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.statesofmatter.control.GravityControlPanel;
import edu.colorado.phet.statesofmatter.model.MultipleParticleModel;
import edu.colorado.phet.statesofmatter.model.particle.StatesOfMatterAtom;
import edu.colorado.phet.statesofmatter.module.phasechanges.PhaseChangesModule;
import edu.colorado.phet.statesofmatter.module.solidliquidgas.SolidLiquidGasModule;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StatesOfMaterDeveloperControlsDialog
extends PaintImmediateDialog {
    private static final DecimalFormat NUMBER_FORMATTER = new DecimalFormat("##0.000");
    private final PhetApplication m_app;
    private MultipleParticleModel m_model;
    private LinearValueControl m_temperatureControl;
    private JLabel m_containerWidthInfo;
    private JLabel m_containerHeightInfo;
    private JLabel m_numParticles;

    public StatesOfMaterDeveloperControlsDialog(Frame frame, PhetApplication phetApplication) {
        super(frame, "Developer Controls");
        this.setResizable(false);
        this.setModal(false);
        this.m_app = phetApplication;
        Module module = this.m_app.getActiveModule();
        if (module instanceof SolidLiquidGasModule) {
            this.m_model = ((SolidLiquidGasModule)module).getMultiParticleModel();
        } else if (module instanceof PhaseChangesModule) {
            this.m_model = ((PhaseChangesModule)module).getMultiParticleModel();
        }
        this.m_app.addModuleObserver(new ModuleObserver(){

            public void moduleAdded(ModuleEvent moduleEvent) {
            }

            public void activeModuleChanged(ModuleEvent moduleEvent) {
                StatesOfMaterDeveloperControlsDialog.this.dispose();
            }

            public void moduleRemoved(ModuleEvent moduleEvent) {
            }
        });
        this.m_model.addListener(new MultipleParticleModel.Adapter(){

            public void temperatureChanged() {
                StatesOfMaterDeveloperControlsDialog.this.m_temperatureControl.setValue(StatesOfMaterDeveloperControlsDialog.this.m_model.getTemperatureSetPoint());
            }

            public void resetOccurred() {
                StatesOfMaterDeveloperControlsDialog.this.updateAdditionalInfo();
            }

            public void particleAdded(StatesOfMatterAtom statesOfMatterAtom) {
                StatesOfMaterDeveloperControlsDialog.this.updateAdditionalInfo();
            }
        });
        JPanel jPanel = this.createInputPanel();
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.setFillHorizontal();
        verticalLayoutPanel.add(jPanel);
        this.setContentPane(verticalLayoutPanel);
        this.pack();
        SwingUtils.centerDialogInParent(this);
    }

    private JPanel createInputPanel() {
        ThermostatSelectionPanel thermostatSelectionPanel = new ThermostatSelectionPanel();
        this.m_temperatureControl = new LinearValueControl(1.0E-4, 50.0, "Temperature", "#.###", "Control");
        this.m_temperatureControl.setUpDownArrowDelta(0.05);
        this.m_temperatureControl.setTextFieldEditable(true);
        this.m_temperatureControl.setFont(new PhetFont(0, 14));
        this.m_temperatureControl.setTickPattern("0");
        this.m_temperatureControl.setMajorTickSpacing(100.0);
        this.m_temperatureControl.setMinorTickSpacing(10.0);
        this.m_temperatureControl.setBorder(BorderFactory.createEtchedBorder());
        this.m_temperatureControl.setValue(this.m_model.getTemperatureSetPoint());
        this.m_temperatureControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Module module = StatesOfMaterDeveloperControlsDialog.this.m_app.getActiveModule();
                if (module instanceof SolidLiquidGasModule) {
                    ((SolidLiquidGasModule)module).getMultiParticleModel().setTemperature(StatesOfMaterDeveloperControlsDialog.this.m_temperatureControl.getValue());
                } else if (module instanceof PhaseChangesModule) {
                    ((PhaseChangesModule)module).getMultiParticleModel().setTemperature(StatesOfMaterDeveloperControlsDialog.this.m_temperatureControl.getValue());
                }
            }
        });
        GravityControlPanel gravityControlPanel = new GravityControlPanel(this.m_model);
        JPanel jPanel = new JPanel();
        this.m_containerWidthInfo = new JLabel();
        jPanel.add(this.m_containerWidthInfo);
        this.m_containerHeightInfo = new JLabel();
        jPanel.add(this.m_containerHeightInfo);
        this.m_numParticles = new JLabel();
        jPanel.add(this.m_numParticles);
        BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, "Additional Info", 1, 2, new PhetFont(1, 14), Color.BLACK);
        jPanel.setBorder(titledBorder);
        this.updateAdditionalInfo();
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel2);
        easyGridBagLayout.setInsets(new Insets(3, 5, 3, 5));
        jPanel2.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(thermostatSelectionPanel, n++, n2);
        easyGridBagLayout.addComponent(this.m_temperatureControl, n++, n2);
        easyGridBagLayout.addComponent(gravityControlPanel, n++, n2);
        easyGridBagLayout.addComponent(jPanel, n++, n2);
        return jPanel2;
    }

    private void updateAdditionalInfo() {
        this.m_containerWidthInfo.setText("Lx = " + NUMBER_FORMATTER.format(this.m_model.getNormalizedContainerWidth()));
        this.m_containerHeightInfo.setText("Ly = " + NUMBER_FORMATTER.format(this.m_model.getNormalizedContainerHeight()));
        this.m_numParticles.setText("N = " + this.m_model.getNumMolecules());
    }

    private class ThermostatSelectionPanel
    extends JPanel {
        private final JRadioButton m_noThermostatRadioButton;
        private final JRadioButton m_isokineticThermostatRadioButton;
        private final JRadioButton m_andersenThermostatRadioButton;
        private final JRadioButton m_adaptiveThermostatRadioButton;

        ThermostatSelectionPanel() {
            this.setLayout(new GridLayout(0, 1));
            BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, "Thermostat Type", 1, 2, new PhetFont(1, 14), Color.BLACK);
            this.setBorder(titledBorder);
            this.m_andersenThermostatRadioButton = new JRadioButton("Andersen Thermostat");
            this.m_andersenThermostatRadioButton.setFont(new PhetFont(0, 14));
            this.m_andersenThermostatRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StatesOfMaterDeveloperControlsDialog.this.m_model.setThermostatType(2);
                }
            });
            this.m_noThermostatRadioButton = new JRadioButton("No Thermostat");
            this.m_noThermostatRadioButton.setFont(new PhetFont(0, 14));
            this.m_noThermostatRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StatesOfMaterDeveloperControlsDialog.this.m_model.setThermostatType(0);
                }
            });
            this.m_isokineticThermostatRadioButton = new JRadioButton("Isokinetic Thermostat");
            this.m_isokineticThermostatRadioButton.setFont(new PhetFont(0, 14));
            this.m_isokineticThermostatRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StatesOfMaterDeveloperControlsDialog.this.m_model.setThermostatType(1);
                }
            });
            this.m_adaptiveThermostatRadioButton = new JRadioButton("Adaptive Thermostat");
            this.m_adaptiveThermostatRadioButton.setFont(new PhetFont(0, 14));
            this.m_adaptiveThermostatRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StatesOfMaterDeveloperControlsDialog.this.m_model.setThermostatType(3);
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.m_noThermostatRadioButton);
            buttonGroup.add(this.m_isokineticThermostatRadioButton);
            buttonGroup.add(this.m_andersenThermostatRadioButton);
            buttonGroup.add(this.m_adaptiveThermostatRadioButton);
            switch (StatesOfMaterDeveloperControlsDialog.this.m_model.getThermostatType()) {
                case 0: {
                    this.m_noThermostatRadioButton.setSelected(true);
                    break;
                }
                case 2: {
                    this.m_andersenThermostatRadioButton.setSelected(true);
                    break;
                }
                case 1: {
                    this.m_isokineticThermostatRadioButton.setSelected(true);
                    break;
                }
                case 3: {
                    this.m_adaptiveThermostatRadioButton.setSelected(true);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.add(this.m_noThermostatRadioButton);
            this.add(this.m_isokineticThermostatRadioButton);
            this.add(this.m_andersenThermostatRadioButton);
            this.add(this.m_adaptiveThermostatRadioButton);
        }
    }
}

