/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.control;

import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.AbstractSlider;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.AbstractValueControl;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.ILayoutStrategy;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.statesofmatter.StatesOfMatterStrings;
import edu.colorado.phet.statesofmatter.model.MultipleParticleModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GravityControlPanel
extends JPanel {
    private static final Font LABEL_FONT = new PhetFont(14, true);
    private final LinearValueControl m_gravityControl;
    private final MultipleParticleModel m_model;

    public GravityControlPanel(MultipleParticleModel multipleParticleModel) {
        this.m_model = multipleParticleModel;
        this.setLayout(new GridLayout(0, 1));
        BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, StatesOfMatterStrings.GRAVITY_CONTROL_TITLE, 1, 2, new PhetFont(1, 14), Color.GRAY);
        this.setBorder(titledBorder);
        this.m_gravityControl = new LinearValueControl(0.0, 0.4, "", "0", "", new GravitySliderLayoutStrategy());
        this.m_gravityControl.setValue(this.m_model.getGravitationalAcceleration());
        this.m_gravityControl.setUpDownArrowDelta(0.01);
        this.m_gravityControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GravityControlPanel.this.m_model.setGravitationalAcceleration(GravityControlPanel.this.m_gravityControl.getValue());
            }
        });
        Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
        JLabel jLabel = new JLabel(StatesOfMatterStrings.GRAVITY_CONTROL_NONE);
        jLabel.setFont(LABEL_FONT);
        hashtable.put(this.m_gravityControl.getMinimum(), jLabel);
        JLabel jLabel2 = new JLabel(StatesOfMatterStrings.GRAVITY_CONTROL_LOTS);
        jLabel2.setFont(LABEL_FONT);
        hashtable.put(this.m_gravityControl.getMaximum(), jLabel2);
        this.m_gravityControl.setTickLabels(hashtable);
        this.m_model.addListener(new MultipleParticleModel.Adapter(){

            public void resetOccurred() {
                GravityControlPanel.this.m_gravityControl.setValue(GravityControlPanel.this.m_model.getGravitationalAcceleration());
            }
        });
        this.add(this.m_gravityControl);
    }

    public class GravitySliderLayoutStrategy
    implements ILayoutStrategy {
        public void doLayout(AbstractValueControl abstractValueControl) {
            AbstractSlider abstractSlider = abstractValueControl.getSlider();
            EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(abstractValueControl);
            abstractValueControl.setLayout(easyGridBagLayout);
            easyGridBagLayout.addFilledComponent(abstractSlider, 1, 0, 2);
        }
    }
}

