/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.util.IProguardKeepClass;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.PhetLookAndFeel;
import edu.colorado.phet.statesofmatter.StatesOfMatterConstants;
import edu.colorado.phet.statesofmatter.module.atomicinteractions.AtomicInteractionsModule;
import edu.colorado.phet.statesofmatter.module.phasechanges.PhaseChangesModule;
import edu.colorado.phet.statesofmatter.module.solidliquidgas.SolidLiquidGasModule;
import edu.colorado.phet.statesofmatter.view.AbstractStatesOfMatterApplication;

public class StatesOfMatterApplication
extends AbstractStatesOfMatterApplication
implements IProguardKeepClass {
    public StatesOfMatterApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
    }

    private void initModules() {
        PhetFrame phetFrame = this.getPhetFrame();
        this.addModule(new SolidLiquidGasModule());
        this.addModule(new PhaseChangesModule(true));
        this.addModule(new AtomicInteractionsModule(false));
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new StatesOfMatterApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "states-of-matter", "states-of-matter");
        PhetLookAndFeel phetLookAndFeel = new PhetLookAndFeel();
        phetLookAndFeel.setBackgroundColor(StatesOfMatterConstants.CONTROL_PANEL_COLOR);
        phetApplicationConfig.setLookAndFeel(phetLookAndFeel);
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

