/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.slider;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.common.piccolophet.nodes.slider.KnobNode;
import edu.colorado.phet.common.piccolophet.nodes.slider.SliderNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VSliderNode
extends SliderNode {
    protected PhetPPath trackNode;
    protected PNode knobNode;
    protected final PNode rootNode = new PNode();
    public final double trackLength;
    public final double trackThickness;

    public void setTrackFillPaint(Paint paint) {
        this.trackNode.setPaint(paint);
    }

    public VSliderNode(IUserComponent iUserComponent, final double d, final double d2, double d3, double d4, final SettableProperty<Double> settableProperty, final ObservableProperty<Boolean> observableProperty) {
        super(iUserComponent, d, d2, settableProperty);
        this.trackLength = d4;
        this.trackThickness = d3;
        this.addChild(this.rootNode);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, d3, d4);
        this.trackNode = new PhetPPath(double_, new GradientPaint(0.0f, 0.0f, Color.gray, 0.0f, (float)d4, Color.white, false), new BasicStroke(1.0f), Color.BLACK);
        this.rootNode.addChild(this.trackNode);
        this.knobNode = new ZeroOffsetNode((PNode)new KnobNode(26.0, new KnobNode.ColorScheme(new Color(115, 217, 255))){
            {
                super(d, colorScheme);
                this.rotate(4.71238898038469);
                observableProperty.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setEnabled(bl);
                    }
                });
            }
        }){
            {
                super(pNode);
                settableProperty.addObserver(new VoidFunction1<Double>(){

                    @Override
                    public void apply(Double d) {
                        double d2 = VSliderNode.this.getViewY(d);
                        this.setOffset(VSliderNode.this.trackNode.getFullBounds().getWidth() / 2.0 - this.getFullBounds().getWidth() / 2.0, d2 - this.getFullBounds().getHeight() / 2.0);
                    }
                });
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new PDragSequenceEventHandler(){
                    private Point2D startPoint;
                    public Double startValue;

                    public void startDrag(PInputEvent pInputEvent) {
                        super.startDrag(pInputEvent);
                        VSliderNode.this.dragStarted();
                        this.startPoint = pInputEvent.getPositionRelativeTo(VSliderNode.this);
                        this.startValue = (Double)settableProperty.get();
                    }

                    public void drag(PInputEvent pInputEvent) {
                        super.drag(pInputEvent);
                        VSliderNode.this.dragged();
                        Point2D point2D = pInputEvent.getPositionRelativeTo(VSliderNode.this);
                        ImmutableVector2D immutableVector2D = new ImmutableVector2D(this.startPoint, point2D);
                        Point2D point2D2 = VSliderNode.this.trackNode.localToGlobal(new Point2D.Double(0.0, 0.0));
                        Point2D point2D3 = VSliderNode.this.trackNode.localToGlobal(VSliderNode.this.createEndPoint());
                        ImmutableVector2D immutableVector2D2 = new ImmutableVector2D(point2D2, point2D3).getNormalizedInstance();
                        double d = immutableVector2D.dot(immutableVector2D2);
                        double d2 = (d - d2) / VSliderNode.this.trackNode.getFullBounds().getHeight() * d;
                        settableProperty.set(MathUtil.clamp(d, this.startValue + d2, d2));
                    }

                    protected void endDrag(PInputEvent pInputEvent) {
                        super.endDrag(pInputEvent);
                        VSliderNode.this.dragEnded();
                    }
                });
            }
        };
        Rectangle2D rectangle2D = this.getKnobRect(d);
        Rectangle2D rectangle2D2 = this.getKnobRect(d2);
        PhetPPath phetPPath = new PhetPPath(rectangle2D.createUnion(rectangle2D2), null, null, null){
            {
                this.setPickable(false);
                this.setChildrenPickable(false);
            }
        };
        this.rootNode.addChild(phetPPath);
        this.rootNode.addChild(this.knobNode);
        this.adjustOrigin();
    }

    private Rectangle2D getKnobRect(double d) {
        PBounds pBounds = this.knobNode.getFullBounds();
        double d2 = this.trackNode.getFullBounds().getWidth() / 2.0 - this.knobNode.getFullBounds().getWidth() / 2.0;
        double d3 = this.getViewY(d) - this.knobNode.getFullBounds().getHeight() / 2.0;
        ((Rectangle2D)pBounds).setRect(d2, d3, ((RectangularShape)pBounds).getWidth(), ((RectangularShape)pBounds).getHeight());
        return pBounds;
    }

    protected Point2D.Double createEndPoint() {
        return new Point2D.Double(0.0, this.trackNode.getFullBounds().getHeight());
    }

    protected double getViewY(double d) {
        return new Function.LinearFunction(this.max, this.min, this.trackNode.getFullBounds().getMinY(), this.trackNode.getFullBounds().getHeight()).evaluate(d);
    }

    public void addLabel(double d, PNode pNode) {
        this.rootNode.addChild(pNode);
        pNode.setOffset(this.knobNode.getFullBounds().getWidth() / 2.0 + this.trackThickness / 2.0, this.getViewY(d) - pNode.getFullBounds().getHeight() / 2.0);
        this.adjustOrigin();
    }

    protected void adjustOrigin() {
        this.removeAllChildren();
        this.addChild(new ZeroOffsetNode(this.rootNode));
    }
}

