/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.view;

import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.util.PiccoloUtils;
import edu.colorado.phet.solublesalts.model.Shaker;
import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.model.Vessel;
import edu.colorado.phet.solublesalts.model.WaterSource;
import edu.colorado.phet.solublesalts.module.SolubleSaltsModule;
import edu.colorado.phet.solublesalts.view.FaucetGraphic;
import edu.colorado.phet.solublesalts.view.ShakerGraphic;
import edu.colorado.phet.solublesalts.view.StoveGraphic;
import edu.colorado.phet.solublesalts.view.VesselGraphic;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.Point2D;

public class WorldNode
extends PNode {
    private VesselGraphic vesselGraphic;

    public WorldNode(SolubleSaltsModule solubleSaltsModule, PhetPCanvas phetPCanvas) {
        SolubleSaltsModel solubleSaltsModel = (SolubleSaltsModel)solubleSaltsModule.getModel();
        double d = 1.0;
        this.vesselGraphic = new VesselGraphic(solubleSaltsModel.getVessel(), solubleSaltsModule);
        this.addChild(this.vesselGraphic);
        StoveGraphic stoveGraphic = new StoveGraphic();
        Point2D point2D = PiccoloUtils.getBorderPoint(this.vesselGraphic, 5);
        ((PNode)stoveGraphic).setOffset(point2D.getX(), point2D.getY() + 50.0);
        Shaker shaker = solubleSaltsModel.getShaker();
        ShakerGraphic shakerGraphic = new ShakerGraphic(shaker);
        shakerGraphic.setRegistrationPoint(shakerGraphic.getFullBounds().getWidth() / 3.0, shakerGraphic.getFullBounds().getHeight() / 2.0);
        shakerGraphic.rotateInPlace(-0.7853981633974483);
        shakerGraphic.setOffset(shaker.getPosition().getX(), shaker.getPosition().getY());
        shakerGraphic.setScale(0.8 * d);
        this.addChild(shakerGraphic);
        WaterSource waterSource = solubleSaltsModel.getFaucet();
        Vessel vessel = solubleSaltsModel.getVessel();
        double d2 = 1.3 * d;
        FaucetGraphic faucetGraphic = new FaucetGraphic(phetPCanvas, 2, 2, waterSource, vessel.getLocation().getY() + vessel.getDepth());
        faucetGraphic.setScale(d2);
        faucetGraphic.setOffset(solubleSaltsModel.getFaucet().getPosition());
        this.addChild(faucetGraphic);
        faucetGraphic.moveInBackOf(this.vesselGraphic);
        FaucetGraphic faucetGraphic2 = new FaucetGraphic(phetPCanvas, 1, 1, solubleSaltsModel.getDrain(), 800.0);
        faucetGraphic2.setScale(d2);
        faucetGraphic2.setOffset(solubleSaltsModel.getDrain().getPosition());
        this.addChild(faucetGraphic2);
    }
}

