/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.view;

import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.RegisterablePNode;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.solublesalts.model.Shaker;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Cursor;
import java.awt.geom.Point2D;

public class ShakerGraphic
extends RegisterablePNode {
    private Shaker shaker;

    public ShakerGraphic(Shaker shaker) {
        this.shaker = shaker;
        PImage pImage = PImageFactory.create("soluble-salts/images/shaker.png");
        this.addChild(pImage);
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseEntered(PInputEvent pInputEvent) {
                PhetPCanvas phetPCanvas = (PhetPCanvas)pInputEvent.getComponent();
                phetPCanvas.setCursor(new Cursor(8));
            }

            public void mouseExited(PInputEvent pInputEvent) {
                PhetPCanvas phetPCanvas = (PhetPCanvas)pInputEvent.getComponent();
                phetPCanvas.setCursor(Cursor.getDefaultCursor());
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                Shaker shaker = ShakerGraphic.this.shaker;
                double d = pInputEvent.getDelta().getHeight();
                Point2D point2D = ShakerGraphic.this.getOffset();
                double d2 = point2D.getY() + d;
                if (d2 <= shaker.getMaxY() && d2 >= shaker.getMinY()) {
                    ShakerGraphic.this.setOffset(point2D.getX(), point2D.getY() + d);
                    shaker.shake(d);
                }
                if (d < 0.0) {
                    shaker.reset();
                }
            }

            public void mousePressed(PInputEvent pInputEvent) {
                ShakerGraphic.this.shaker.reset();
            }
        });
    }
}

