/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.view;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.RegisterablePNode;
import edu.colorado.phet.solublesalts.SolubleSaltsConfig;
import edu.colorado.phet.solublesalts.model.Spigot;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FaucetGraphic
extends RegisterablePNode
implements Spigot.ChangeListener {
    private static final Color WATER_COLOR = SolubleSaltsConfig.WATER_COLOR;
    private Rectangle waterShape;
    private Spigot spigot;
    private double streamMaxY;
    private PPath waterGraphic;
    private JSlider flowSlider;

    public FaucetGraphic(PSwingCanvas pSwingCanvas, int n, int n2, Spigot spigot, double d) {
        Cloneable cloneable;
        spigot.addChangeListener(this);
        this.spigot = spigot;
        this.streamMaxY = d;
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageLoader.loadBufferedImage("soluble-salts/images/faucet-gold-rt.gif");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Point2D point2D = null;
        switch (n2) {
            case 2: {
                this.setRegistrationPoint(13.0, 77.0);
                break;
            }
            case 1: {
                this.setRegistrationPoint(bufferedImage.getWidth(), 40.0);
                point2D = new Point2D.Double(12.0, 77.0);
                break;
            }
            default: {
                throw new RuntimeException("Invalid registration");
            }
        }
        if (n == 2) {
            cloneable = AffineTransform.getScaleInstance(-1.0, 1.0);
            ((AffineTransform)cloneable).translate(-bufferedImage.getWidth(null), 0.0);
            point2D = new Point2D.Double(this.getRegistrationPoint().getX(), this.getRegistrationPoint().getY());
            point2D = ((AffineTransform)cloneable).transform(point2D, null);
            bufferedImage = BufferedImageUtils.flipX(bufferedImage);
            this.setRegistrationPoint((double)bufferedImage.getWidth() - this.getRegistrationPoint().getX(), this.getRegistrationPoint().getY());
        }
        cloneable = new PImage(bufferedImage);
        this.addChild((PNode)cloneable);
        this.waterShape = new Rectangle(0, 0, 0, 0);
        this.waterGraphic = new PPath(this.waterShape);
        this.waterGraphic.setOffset(point2D);
        this.waterGraphic.setPaint(WATER_COLOR);
        this.waterGraphic.setStrokePaint(null);
        this.addChild(this.waterGraphic);
        this.flowSlider = new JSlider(0, (int)spigot.getMaxFlow(), 0);
        this.flowSlider.setPaintTicks(true);
        this.flowSlider.setBackground(Color.black);
        this.flowSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FaucetGraphic.this.spigot.setFlow(FaucetGraphic.this.flowSlider.getValue());
            }
        });
        this.flowSlider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                FaucetGraphic.this.flowSlider.setValue(0);
            }
        });
        this.flowSlider.setPreferredSize(new Dimension((int)((PNode)cloneable).getWidth() / 2, 15));
        PSwing pSwing = new PSwing(this.flowSlider);
        pSwing.setOffset(22.0, 35.0);
        pSwing.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseEntered(PInputEvent pInputEvent) {
                PhetPCanvas phetPCanvas = (PhetPCanvas)pInputEvent.getComponent();
                phetPCanvas.setCursor(new Cursor(10));
            }

            public void mouseExited(PInputEvent pInputEvent) {
                PhetPCanvas phetPCanvas = (PhetPCanvas)pInputEvent.getComponent();
                phetPCanvas.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.addChild(pSwing);
        this.update();
    }

    public void stateChanged(Spigot.ChangeEvent changeEvent) {
        this.update();
    }

    public void update() {
        double d = Math.abs(this.spigot.getFlow() * 20.0 / this.spigot.getMaxFlow());
        this.waterShape.setBounds(-((int)d / 2), 0, (int)d, (int)((this.streamMaxY - this.getYOffset()) / this.getScale()));
        this.waterGraphic.setPathTo(this.waterShape);
        this.repaint();
    }
}

