/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.view;

import edu.colorado.phet.solublesalts.model.crystal.Bond;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;

public class BondGraphic
extends PNode
implements Bond.ChangeListener {
    static Color openColor = Color.green;
    static Color closedColor = Color.black;
    private PPath bondLine;

    public BondGraphic(Bond bond) {
        this.createGraphic(bond);
        bond.addChangeListener(this);
    }

    private void createGraphic(Bond bond) {
        if (bond == null) {
            throw new IllegalArgumentException();
        }
        if (this.bondLine != null) {
            this.removeChild(this.bondLine);
            this.bondLine = null;
        }
        if (bond.getOrigin() != null) {
            Color color;
            Line2D.Double double_;
            BasicStroke basicStroke = new BasicStroke(2.0f);
            if (bond.isOpen()) {
                double_ = new Line2D.Double(bond.getOrigin().getPosition(), bond.getOpenPosition());
                color = openColor;
            } else {
                double_ = new Line2D.Double(bond.getOrigin().getPosition(), bond.getDestination().getPosition());
                color = closedColor;
            }
            if (bond.isDebugEnabled()) {
                color = Color.red;
            }
            this.bondLine = new PPath(double_, basicStroke);
            this.bondLine.setPaint(color);
            this.bondLine.setStrokePaint(color);
            this.addChild(this.bondLine);
            if (bond.isOpen()) {
                Ellipse2D.Double double_2 = new Ellipse2D.Double(bond.getOpenPosition().getX(), bond.getOpenPosition().getY(), 2.0, 2.0);
                PPath pPath = new PPath(double_2);
                pPath.setStrokePaint(Color.blue);
            }
        }
    }

    public void stateChanged(Bond.ChangeEvent changeEvent) {
        if (changeEvent.getBond() == null || !(changeEvent.getBond() instanceof Bond)) {
            throw new IllegalArgumentException();
        }
        this.createGraphic(changeEvent.getBond());
    }
}

