/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.module;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.solublesalts.SolubleSaltResources;
import edu.colorado.phet.solublesalts.SolubleSaltsConfig;
import edu.colorado.phet.solublesalts.WiggleMe_org;
import edu.colorado.phet.solublesalts.control.SodiumChlorideControlPanel;
import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.model.ion.IonEvent;
import edu.colorado.phet.solublesalts.model.ion.IonListener;
import edu.colorado.phet.solublesalts.module.SolubleSaltsModule;
import java.awt.Color;
import java.awt.geom.Point2D;

public class SodiumChlorideModule
extends SolubleSaltsModule {
    public SodiumChlorideModule(IClock iClock, String string) {
        super(string, iClock, new SolubleSaltsConfig.Calibration(1.7342E-25, 5.0E-23, 1.0E-23, 5.0E-24));
        this.setControlPanel(new SodiumChlorideControlPanel(this));
        ((SolubleSaltsModel)this.getModel()).setCurrentSalt(SolubleSaltsConfig.DEFAULT_SALT);
        final SolubleSaltsModel solubleSaltsModel = (SolubleSaltsModel)this.getModel();
        double d = solubleSaltsModel.getShaker().getPosition().getX() - 200.0;
        double d2 = solubleSaltsModel.getShaker().getPosition().getY() - 100.0;
        final WiggleMe_org wiggleMe_org = new WiggleMe_org(SolubleSaltResources.getString("WiggleMe.message"), new Point2D.Double(d, d2), 50.0, new Color(30, 100, 60));
        solubleSaltsModel.addModelElement(wiggleMe_org);
        this.getFullScaleCanvasNode().addChild(wiggleMe_org);
        wiggleMe_org.setVisible(true);
        solubleSaltsModel.addIonListener(new IonListener(){

            public void ionAdded(IonEvent ionEvent) {
                solubleSaltsModel.removeModelElement(wiggleMe_org);
                wiggleMe_org.setVisible(false);
            }

            public void ionRemoved(IonEvent ionEvent) {
            }
        });
    }
}

