/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model.salt;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.solublesalts.model.crystal.Lattice;
import edu.colorado.phet.solublesalts.model.crystal.OneToOneLattice;
import edu.colorado.phet.solublesalts.model.crystal.ThreeToOneLattice;
import edu.colorado.phet.solublesalts.model.crystal.ThreeToTwoLattice;
import edu.colorado.phet.solublesalts.model.crystal.TwoToOneLattice;
import edu.colorado.phet.solublesalts.model.ion.ConfigurableAnion;
import edu.colorado.phet.solublesalts.model.ion.ConfigurableCation;
import edu.colorado.phet.solublesalts.model.salt.Salt;
import java.util.ArrayList;

public class ConfigurableSalt
extends Salt {
    private static Lattice lattice = new OneToOneLattice(16.0);
    private static ArrayList components = new ArrayList();

    public static void configure() {
        components.clear();
        int n = MathUtil.getLeastCommonMultiple(ConfigurableCation.getClassCharge(), -ConfigurableAnion.getClassCharge());
        components.add(new Salt.Component(ConfigurableCation.class, new Integer(n / ConfigurableCation.getClassCharge())));
        components.add(new Salt.Component(ConfigurableAnion.class, new Integer(n / -ConfigurableAnion.getClassCharge())));
        double d = 16.0;
        block0 : switch (ConfigurableAnion.getClassCharge()) {
            case -1: {
                switch (ConfigurableCation.getClassCharge()) {
                    case 1: {
                        lattice = new OneToOneLattice(d);
                        break block0;
                    }
                    case 2: {
                        lattice = new TwoToOneLattice(ConfigurableCation.class, ConfigurableAnion.class, d);
                        break block0;
                    }
                    case 3: {
                        lattice = new ThreeToOneLattice(ConfigurableCation.class, ConfigurableAnion.class, d);
                        break block0;
                    }
                }
                throw new RuntimeException("No lattice defined for ratio of ions in salt");
            }
            case -2: {
                switch (ConfigurableCation.getClassCharge()) {
                    case 1: {
                        lattice = new TwoToOneLattice(ConfigurableAnion.class, ConfigurableCation.class, d);
                        break block0;
                    }
                    case 2: {
                        lattice = new OneToOneLattice(d);
                        break block0;
                    }
                    case 3: {
                        lattice = new ThreeToTwoLattice(ConfigurableCation.class, ConfigurableAnion.class, d);
                        break block0;
                    }
                }
                throw new RuntimeException("No lattice defined for ratio of ions in salt");
            }
            case -3: {
                switch (ConfigurableCation.getClassCharge()) {
                    case 1: {
                        lattice = new ThreeToOneLattice(ConfigurableAnion.class, ConfigurableCation.class, d);
                        break block0;
                    }
                    case 2: {
                        lattice = new ThreeToTwoLattice(ConfigurableAnion.class, ConfigurableCation.class, d);
                        break block0;
                    }
                    case 3: {
                        lattice = new OneToOneLattice(d);
                        break block0;
                    }
                }
                throw new RuntimeException("No lattice defined for ratio of ions in salt");
            }
            default: {
                throw new RuntimeException("No lattice defined for ratio of ions in salt");
            }
        }
    }

    public ConfigurableSalt() {
        super(components, lattice, ConfigurableCation.class, ConfigurableAnion.class, 1.0E-12);
    }

    static {
        components.add(new Salt.Component(ConfigurableAnion.class, new Integer(1)));
        components.add(new Salt.Component(ConfigurableCation.class, new Integer(1)));
    }
}

