/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model.crystal;

import edu.colorado.phet.common.collision.Collidable;
import edu.colorado.phet.common.collision.CollidableAdapter;
import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.solublesalts.model.Atom;
import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.model.Vessel;
import edu.colorado.phet.solublesalts.model.crystal.Lattice;
import edu.colorado.phet.solublesalts.model.crystal.Node;
import edu.colorado.phet.solublesalts.model.ion.Ion;
import edu.colorado.phet.solublesalts.model.ion.IonFactory;
import edu.colorado.phet.solublesalts.model.salt.Salt;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class Crystal
extends Body
implements Collidable {
    private static EventChannel instanceLifetimeEventChannel = new EventChannel(InstanceLifetimeListener.class);
    protected static InstanceLifetimeListener instanceLifetimeListenerProxy = (InstanceLifetimeListener)instanceLifetimeEventChannel.getListenerProxy();
    private static Random random = new Random(System.currentTimeMillis());
    private static double dissociationLikelihood;
    private SolubleSaltsModel model;
    private Salt salt;
    private CollidableAdapter collidableAdapter;
    private Point2D cm = new Point2D.Double();
    private ArrayList ions = new ArrayList();
    private Lattice lattice;
    private Vector noBindList = new Vector();
    private Rectangle2D waterBounds;
    private Ion[] boundaryIons = new Ion[4];
    private boolean isBound;

    public static void setDissociationLikelihood(double d) {
        dissociationLikelihood = d;
    }

    public static void addInstanceLifetimeListener(InstanceLifetimeListener instanceLifetimeListener) {
        instanceLifetimeEventChannel.addListener(instanceLifetimeListener);
    }

    public Crystal(SolubleSaltsModel solubleSaltsModel, Lattice lattice, Ion ion) {
        ArrayList<Ion> arrayList = new ArrayList<Ion>();
        arrayList.add(ion);
        this.init(lattice, solubleSaltsModel, arrayList, ion);
    }

    private Crystal(SolubleSaltsModel solubleSaltsModel, Lattice lattice, List list, Ion ion) {
        this.init(lattice, solubleSaltsModel, list, ion);
    }

    public Crystal(SolubleSaltsModel solubleSaltsModel, Lattice lattice, List list) {
        this.init(lattice, solubleSaltsModel, list, (Ion)list.get(0));
        Ion ion = null;
        double d = Double.MIN_VALUE;
        for (int i = 0; i < list.size(); ++i) {
            Ion ion2 = (Ion)list.get(i);
            if (!(ion2.getPosition().getY() + ion2.getRadius() > d)) continue;
            d = ion2.getPosition().getY() + ion2.getRadius();
            ion = ion2;
        }
        if (ion == null) {
            throw new RuntimeException("seed == null");
        }
        this.trackExtremities();
        this.setSeed(ion);
    }

    private void init(Lattice lattice, SolubleSaltsModel solubleSaltsModel, List list, Ion ion) {
        int n;
        Cloneable cloneable;
        this.lattice = (Lattice)lattice.clone();
        this.model = solubleSaltsModel;
        this.salt = solubleSaltsModel.getCurrentSalt();
        lattice.setBounds(solubleSaltsModel.getBounds());
        Salt.Component[] componentArray = this.salt.getComponents();
        Class clazz = null;
        Class clazz2 = null;
        if (componentArray[0].getLatticeUnitFraction() > componentArray[1].getLatticeUnitFraction()) {
            clazz = componentArray[0].getIonClass();
            clazz2 = componentArray[1].getIonClass();
        } else {
            clazz = componentArray[1].getIonClass();
            clazz2 = componentArray[0].getIonClass();
        }
        ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
        ArrayList<Ion> arrayList2 = new ArrayList<Ion>();
        for (int i = 0; i < list.size(); ++i) {
            cloneable = (Ion)list.get(i);
            if (cloneable.getClass() == clazz2) {
                arrayList2.add((Ion)cloneable);
                continue;
            }
            if (cloneable.getClass() == clazz) {
                arrayList.add(cloneable);
                continue;
            }
            throw new RuntimeException("ion with 0 charge");
        }
        ArrayList arrayList3 = new ArrayList();
        cloneable = solubleSaltsModel.getCurrentSalt().getNumAnionsInUnit() < solubleSaltsModel.getCurrentSalt().getNumCationsInUnit() ? arrayList : arrayList2;
        ArrayList<Ion> arrayList4 = cloneable == arrayList ? arrayList2 : arrayList;
        Iterator iterator = cloneable.iterator();
        Iterator iterator2 = arrayList4.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            arrayList3.add(iterator.next());
            arrayList3.add(iterator2.next());
        }
        while (iterator.hasNext()) {
            arrayList3.add(iterator.next());
        }
        while (iterator2.hasNext()) {
            arrayList3.add(iterator2.next());
        }
        ArrayList<Ion> arrayList5 = new ArrayList<Ion>();
        for (n = 0; n < arrayList3.size(); ++n) {
            Ion ion2 = (Ion)arrayList3.get(n);
            if (this.addIon(ion2)) continue;
            arrayList5.add(ion2);
        }
        n = 10;
        int n2 = 0;
        block5: for (int i = 0; i <= n && !arrayList5.isEmpty(); ++i) {
            n2 = i;
            for (int j = 0; j < arrayList5.size(); ++j) {
                Ion ion3 = (Ion)arrayList5.get(j);
                if (!this.addIon(ion3)) continue;
                arrayList5.remove(ion3);
                continue block5;
            }
        }
        if (n2 >= n) {
            throw new RuntimeException("maxRetries exceeded");
        }
        this.setWaterBounds(solubleSaltsModel.getVessel());
        instanceLifetimeListenerProxy.instanceCreated(new InstanceLifetimeEvent(this));
        this.setSeed(ion);
        if (this.collidableAdapter == null) {
            this.collidableAdapter = new CollidableAdapter(this);
        }
    }

    public Object clone() {
        ArrayList<Ion> arrayList = new ArrayList<Ion>();
        IonFactory ionFactory = new IonFactory();
        Ion ion = null;
        for (int i = 0; i < this.ions.size(); ++i) {
            Ion ion2 = (Ion)this.ions.get(i);
            Ion ion3 = ionFactory.create(ion2.getClass(), new Point2D.Double(ion2.getPosition().getX(), ion2.getPosition().getY()), new MutableVector2D(ion2.getVelocity()), new MutableVector2D(ion2.getAcceleration()));
            if (this.getSeed() == ion2) {
                ion = ion3;
            }
            arrayList.add(ion3);
            this.model.addModelElement(ion3);
        }
        Crystal crystal = new Crystal(this.model, this.lattice, arrayList, ion);
        this.trackExtremities();
        crystal.setVelocity(new MutableVector2D(this.getVelocity()));
        crystal.setAcceleration(new MutableVector2D(this.getAcceleration()));
        return crystal;
    }

    private void trackExtremities() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double d4 = -1.7976931348623157E308;
        Ion ion = null;
        Ion ion2 = null;
        Ion ion3 = null;
        Ion ion4 = null;
        for (int i = 0; i < this.ions.size(); ++i) {
            Ion ion5 = (Ion)this.ions.get(i);
            if (ion5.getPosition().getY() < d) {
                d = ion5.getPosition().getY();
                ion = ion5;
            }
            if (ion5.getPosition().getX() < d2) {
                d2 = ion5.getPosition().getX();
                ion4 = ion5;
            }
            if (ion5.getPosition().getY() > d4) {
                d4 = ion5.getPosition().getY();
                ion3 = ion5;
            }
            if (!(ion5.getPosition().getX() > d3)) continue;
            d3 = ion5.getPosition().getX();
            ion2 = ion5;
        }
        this.boundaryIons[0] = ion;
        this.boundaryIons[2] = ion2;
        this.boundaryIons[1] = ion3;
        this.boundaryIons[3] = ion4;
    }

    public Ion getExtremeIon(int n) {
        return this.boundaryIons[n];
    }

    public void setWaterBounds(Vessel vessel) {
        this.waterBounds = vessel.getWater().getBounds();
        this.lattice.setBounds(this.waterBounds);
    }

    public Point2D getPosition() {
        return this.lattice.getSeed().getPosition();
    }

    public void leaveModel() {
        instanceLifetimeListenerProxy.instanceDestroyed(new InstanceLifetimeEvent(this));
    }

    private void updateCm() {
        this.cm.setLocation(0.0, 0.0);
        for (int i = 0; i < this.ions.size(); ++i) {
            Atom atom = (Atom)this.ions.get(i);
            this.cm.setLocation(this.cm.getX() + atom.getPosition().getX(), this.cm.getY() + atom.getPosition().getY());
        }
        this.cm.setLocation(this.cm.getX() / (double)this.ions.size(), this.cm.getY() / (double)this.ions.size());
    }

    public boolean isBound() {
        return this.isBound;
    }

    public void setBound(boolean bl) {
        this.isBound = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.ions.size(); ++i) {
            Ion ion = (Ion)this.ions.get(i);
            String string = new String("ion: type = " + ion.getClass() + "  position = " + ion.getPosition() + "\n");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public boolean addIonNextToIon(Ion ion, Ion ion2) {
        boolean bl = false;
        if (this.noBindList.contains(ion)) {
            return false;
        }
        if (ion.getCharge() * ion2.getCharge() < 0.0) {
            Node node = this.lattice.getNode(ion2);
            if (node == null) {
                throw new RuntimeException("nodeB = null");
            }
            boolean bl2 = this.lattice.addAtIonNode(ion, ion2);
            if (bl2) {
                this.ions.add(ion);
                ion.bindTo(this);
                this.updateCm();
                bl = true;
                for (int i = 0; i < this.ions.size(); ++i) {
                    Ion ion3 = (Ion)this.ions.get(i);
                    if (!(Math.abs(ion3.getPosition().getX() - ion.getPosition().getX()) < 2.0) || !(Math.abs(ion3.getPosition().getY() - ion.getPosition().getY()) < 2.0) || ion3 == ion) continue;
                    this.removeIon(ion);
                    ion.unbindFrom(this);
                    bl = false;
                    this.updateCm();
                }
            }
            this.trackExtremities();
            if (bl && !this.waterBounds.contains(ion.getPosition())) {
                throw new RuntimeException("!waterBounds.contains( ionA.getPosition() )");
            }
        }
        return bl;
    }

    public boolean addIon(Ion ion) {
        boolean bl = false;
        if (this.noBindList.contains(ion)) {
            System.out.println("Crystal.addIon: on nobind list");
            return false;
        }
        bl = this.lattice.add(ion);
        if (bl) {
            this.ions.add(ion);
            ion.bindTo(this);
            this.updateCm();
        }
        for (int i = 0; i < this.ions.size(); ++i) {
            Ion ion2 = (Ion)this.ions.get(i);
            if (!(Math.abs(ion2.getPosition().getX() - ion.getPosition().getX()) < 2.0) || !(Math.abs(ion2.getPosition().getY() - ion.getPosition().getY()) < 2.0) || ion2 == ion) continue;
            System.out.println("Crystal.addIon");
        }
        this.trackExtremities();
        return bl;
    }

    public void removeIon(Ion ion) {
        this.getIons().remove(ion);
        this.lattice.removeIon(ion);
        if (this.getIons().size() == 0) {
            instanceLifetimeListenerProxy.instanceDestroyed(new InstanceLifetimeEvent(this));
        }
        this.trackExtremities();
    }

    public void releaseIon(double d) {
        Class clazz = this.model.getPreferredTypeOfIonToRelease();
        Ion ion = this.lattice.getBestIonToRelease(this.getIons(), clazz);
        if (ion == this.getSeed() && this.ions.size() > 1) {
            throw new RuntimeException("ionToRelease == getSeed() && ions.size() > 1");
        }
        if (ion == null) {
            throw new RuntimeException("no ion found to release");
        }
        Thread thread = new Thread(new NoBindTimer(ion));
        thread.start();
        MutableVector2D mutableVector2D = this.determineReleaseVelocity(ion);
        ion.setVelocity(mutableVector2D);
        ion.unbindFrom(this);
        this.removeIon(ion);
        if (this.getIons().size() == 0) {
            this.leaveModel();
        }
    }

    private MutableVector2D determineReleaseVelocity(Ion ion) {
        MutableVector2D mutableVector2D = null;
        if (ion == this.getSeed()) {
            return ion.getVelocity();
        }
        List list = this.lattice.getOpenNeighboringSites(ion);
        if (list.size() == 0) {
            double d = random.nextDouble() * Math.PI * 2.0;
            mutableVector2D = new MutableVector2D(ion.getVelocity().magnitude(), 0.0).rotate(d);
            return mutableVector2D;
        }
        double d = Double.MIN_VALUE;
        double d2 = Double.MAX_VALUE;
        if (list.size() > 1) {
            double d3;
            Object object;
            for (int i = 0; i < list.size() - 1; ++i) {
                object = (Point2D)list.get(i);
                MutableVector2D mutableVector2D2 = new MutableVector2D(((Point2D)object).getX() - ion.getPosition().getX(), ((Point2D)object).getY() - ion.getPosition().getY());
                double d4 = (mutableVector2D2.getAngle() + Math.PI * 2) % (Math.PI * 2);
                for (int j = i + 1; j < list.size(); ++j) {
                    Point2D point2D = (Point2D)list.get(j);
                    MutableVector2D mutableVector2D3 = new MutableVector2D(point2D.getX() - ion.getPosition().getX(), point2D.getY() - ion.getPosition().getY());
                    d3 = (mutableVector2D3.getAngle() + Math.PI * 2) % (Math.PI * 2);
                    if (!(Math.abs(d3 - d4) < Math.PI)) continue;
                    double d5 = random.nextDouble() * (d3 - d4) + d4;
                    mutableVector2D = new MutableVector2D(ion.getVelocity().magnitude(), 0.0).rotate(d5);
                    return mutableVector2D;
                }
            }
            Point2D point2D = (Point2D)list.get(0);
            object = new MutableVector2D(point2D.getX() - ion.getPosition().getX(), point2D.getY() - ion.getPosition().getY());
            double d6 = (((AbstractVector2D)object).getAngle() + Math.PI * 2) % (Math.PI * 2);
            Point2D point2D2 = (Point2D)list.get(1);
            MutableVector2D mutableVector2D4 = new MutableVector2D(point2D2.getX() - ion.getPosition().getX(), point2D2.getY() - ion.getPosition().getY());
            double d7 = (mutableVector2D4.getAngle() + Math.PI * 2) % (Math.PI * 2);
            d3 = random.nextDouble() * (d7 - d6) + d6;
            mutableVector2D = new MutableVector2D(ion.getVelocity().magnitude(), 0.0).rotate(d3);
            return mutableVector2D;
        }
        Point2D point2D = (Point2D)list.get(0);
        MutableVector2D mutableVector2D5 = new MutableVector2D(point2D.getX() - ion.getPosition().getX(), point2D.getY() - ion.getPosition().getY());
        double d8 = (mutableVector2D5.getAngle() + Math.PI * 2) % (Math.PI * 2);
        d = d8 > d ? d8 : d;
        d2 = d8 < d2 ? d8 : d2;
        d8 = random.nextDouble() * (d - d2) + d2;
        mutableVector2D = new MutableVector2D(ion.getVelocity().magnitude(), 0.0).rotate(d8);
        if (mutableVector2D.magnitude() < 1.0E-4) {
            System.out.println("Crystal.determineReleaseVelocity < 0.0001");
        }
        return mutableVector2D;
    }

    public void translate(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            System.out.println("Crystal.translate");
        }
        for (int i = 0; i < this.ions.size(); ++i) {
            Ion ion = (Ion)this.ions.get(i);
            ion.translate(d, d2);
        }
        super.translate(d, d2);
    }

    public Atom getSeed() {
        return this.lattice.getSeed();
    }

    public void setSeed(Ion ion) {
        this.lattice.setSeed(ion);
        this.collidableAdapter = new CollidableAdapter(this);
    }

    public ArrayList getIons() {
        return this.ions;
    }

    public boolean isInWater(Rectangle2D rectangle2D) {
        boolean bl = true;
        Point2D.Double double_ = new Point2D.Double();
        Ion ion = this.getExtremeIon(2);
        Ion ion2 = this.getExtremeIon(3);
        Ion ion3 = this.getExtremeIon(0);
        Ion ion4 = this.getExtremeIon(1);
        bl &= ion.getPosition().getX() < rectangle2D.getMaxX();
        bl &= ion2.getPosition().getX() > rectangle2D.getMinX();
        bl &= ion4.getPosition().getY() < rectangle2D.getMaxY();
        double d = this.getVelocity().getY() > 0.0 ? 2.0 * ion3.getRadius() : 0.0;
        return bl &= ion3.getPosition().getY() - d > rectangle2D.getMinY();
    }

    public void stepInTime(double d) {
        if (this.isInWater(this.waterBounds) && random.nextDouble() < dissociationLikelihood) {
            this.releaseIon(d);
        }
        if (this.collidableAdapter == null) {
            System.out.println("Crystal.stepInTime");
        }
        this.collidableAdapter.stepInTime(d);
        super.stepInTime(d);
    }

    public static class InstanceLifetimeEvent
    extends EventObject {
        public InstanceLifetimeEvent(Object object) {
            super(object);
        }

        public Crystal getInstance() {
            return (Crystal)this.getSource();
        }
    }

    public static interface InstanceLifetimeListener
    extends EventListener {
        public void instanceCreated(InstanceLifetimeEvent var1);

        public void instanceDestroyed(InstanceLifetimeEvent var1);
    }

    private class NoBindTimer
    implements Runnable {
        private Ion ion;

        public NoBindTimer(Ion ion) {
            this.ion = ion;
            Crystal.this.noBindList.add(ion);
        }

        public void run() {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            Crystal.this.noBindList.remove(this.ion);
        }
    }
}

