/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model;

import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.model.Spigot;
import edu.colorado.phet.solublesalts.model.Vessel;

public class WaterSource
extends Spigot
implements Vessel.ChangeListener {
    public WaterSource(SolubleSaltsModel solubleSaltsModel) {
        super(solubleSaltsModel);
        solubleSaltsModel.getVessel().addChangeListener(this);
    }

    public void stepInTime(double d) {
        if (this.getFlow() != 0.0) {
            Vessel vessel = this.getModel().getVessel();
            double d2 = vessel.getWidth();
            double d3 = vessel.getWaterLevel() + this.getFlow() / d2;
            vessel.setWaterLevel(d3);
        }
    }

    public void stateChanged(Vessel.ChangeEvent changeEvent) {
        Vessel vessel = changeEvent.getVessel();
        if (vessel.getWaterLevel() >= vessel.getDepth()) {
            this.setFlow(0.0);
        }
    }
}

