/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model;

import edu.colorado.phet.common.collision.SphericalBody;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.Particle;
import edu.colorado.phet.solublesalts.SolubleSaltsConfig;
import edu.colorado.phet.solublesalts.model.ISugarMolecule;
import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.model.Vessel;
import edu.colorado.phet.solublesalts.model.crystal.Crystal;
import edu.colorado.phet.solublesalts.model.ion.Ion;
import edu.colorado.phet.solublesalts.model.ion.IonFactory;
import edu.colorado.phet.solublesalts.model.salt.Salt;
import edu.colorado.phet.solublesalts.model.salt.StrontiumPhosphate;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;

public class Shaker
extends Particle {
    private Random random = new Random(System.currentTimeMillis());
    private SolubleSaltsModel model;
    private double orientation = 0.7853981633974483;
    private double openingLength;
    private Salt currentSalt = SolubleSaltsConfig.DEFAULT_SALT;
    private double maxY;
    private double minY;
    private double maxShakeDistance = 100.0;
    boolean enabledBasedOnVolume = true;
    private boolean enabledBasedOnMax = true;
    boolean done;

    public Shaker(final SolubleSaltsModel solubleSaltsModel) {
        this.model = solubleSaltsModel;
        this.openingLength = 80.0;
        this.maxY = solubleSaltsModel.getVessel().getLocation().getY();
        this.minY = this.maxY - this.maxShakeDistance;
        solubleSaltsModel.getVessel().addChangeListener(new Vessel.ChangeListener(){

            public void stateChanged(Vessel.ChangeEvent changeEvent) {
                Vessel vessel = changeEvent.getVessel();
                double d = vessel.getLocation().getY() + vessel.getDepth() - solubleSaltsModel.getDrain().getPosition().getY();
                Shaker.this.enabledBasedOnVolume = vessel.getWaterLevel() > d;
            }
        });
    }

    public void setCurrentSalt(Salt salt) {
        this.currentSalt = salt;
    }

    public Salt getCurrentSalt() {
        return this.currentSalt;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMinY() {
        return this.minY;
    }

    public void reset() {
        this.done = false;
    }

    public void shake(double d) {
        if (!this.enabledBasedOnVolume || !this.enabledBasedOnMax) {
            return;
        }
        this.setPosition(this.getPosition().getX(), this.getPosition().getY() + d);
        if (!this.done && d > 0.0) {
            this.done = true;
            this.shakeCrystal();
        }
    }

    private MutableVector2D getCrystalVelocity() {
        double d = 1.5707963267948966 + this.random.nextDouble() * Math.PI / 6.0 * (double)MathUtil.nextRandomSign();
        MutableVector2D mutableVector2D = new MutableVector2D(3.0, 0.0);
        mutableVector2D.rotate(d);
        return mutableVector2D;
    }

    private int getNumLatticeUnits() {
        int n = 3;
        int n2 = 10;
        int n3 = this.random.nextInt(n2 - n) + n;
        if (this.getCurrentSalt() instanceof StrontiumPhosphate) {
            n3 /= 2;
        }
        if (this.getCurrentSalt() instanceof ISugarMolecule) {
            n3 = this.random.nextDouble() < 0.5 ? 3 : 4;
        }
        return n3;
    }

    public void shakeCrystal() {
        double d = this.random.nextDouble() * this.openingLength * (double)MathUtil.nextRandomSign() - this.openingLength / 2.0;
        MutableVector2D mutableVector2D = this.getCrystalVelocity();
        int n = this.getNumLatticeUnits();
        double d2 = this.getPosition().getY() + d * Math.sin(this.orientation);
        IonFactory ionFactory = new IonFactory();
        int n2 = this.getCurrentSalt() instanceof StrontiumPhosphate ? 2 : 1;
        SphericalBody sphericalBody = null;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4;
            ArrayList<SphericalBody> arrayList = new ArrayList<SphericalBody>();
            double d3 = this.getPosition().getX() + (d += (double)(++n3 * 35)) * Math.cos(this.orientation);
            Point2D.Double double_ = new Point2D.Double(d3, d2);
            for (n4 = 0; n4 < n; ++n4) {
                for (Salt.Component component : this.currentSalt.getComponents()) {
                    for (int j = 0; j < component.getLatticeUnitFraction(); ++j) {
                        sphericalBody = ionFactory.create(component.getIonClass(), double_, mutableVector2D, new MutableVector2D());
                        arrayList.add(sphericalBody);
                    }
                }
            }
            for (n4 = 0; n4 < arrayList.size(); ++n4) {
                Ion ion = (Ion)arrayList.get(n4);
                ion.setPosition(this.getPosition().getX() + sphericalBody.getRadius() * this.random.nextDouble() * (double)(this.random.nextBoolean() ? 1 : -1), this.getPosition().getY() - sphericalBody.getRadius() * (this.random.nextDouble() + 0.1));
                this.model.addModelElement(ion);
            }
            Crystal crystal = new Crystal(this.model, this.currentSalt.getLattice(), arrayList);
            crystal.setVelocity(mutableVector2D);
        }
    }
}

