/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.solublesalts.model.Vessel;
import java.util.Random;

public class RandomWalk {
    private Random random = new Random();
    private double theta = 30.0;
    private Vessel vessel;

    public RandomWalk(Vessel vessel) {
        this.vessel = vessel;
    }

    public MutableVector2D apply(Body body) {
        if (body.getVelocity().magnitude() != 0.0 && this.vessel.getWater().getBounds().contains(body.getPosition())) {
            double d = this.random.nextDouble() * Math.toRadians(this.theta) * (double)MathUtil.nextRandomSign();
            body.setVelocity(body.getVelocity().rotate(d));
        }
        return body.getVelocity();
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double d) {
        this.theta = d;
    }
}

