/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model;

import edu.colorado.phet.common.collision.Collidable;
import edu.colorado.phet.common.collision.SphereBoxExpert;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.model.Vessel;
import edu.colorado.phet.solublesalts.model.ion.Chlorine;
import edu.colorado.phet.solublesalts.model.ion.Ion;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class IonVesselCollisionExpert {
    private static double DEFAULT_MIN_DIST_TO_LIKE_ION = new Chlorine(new Point2D.Double(), new MutableVector2D(), new MutableVector2D()).getRadius() * 4.0;
    private SphereBoxExpert sphereBoxExpert = new SphereBoxExpert();
    private SolubleSaltsModel model;
    private double minDistToLikeIon = DEFAULT_MIN_DIST_TO_LIKE_ION;

    public IonVesselCollisionExpert(SolubleSaltsModel solubleSaltsModel) {
        this.model = solubleSaltsModel;
    }

    public boolean detectAndDoCollision(Collidable collidable, Collidable collidable2) {
        boolean bl = false;
        Ion ion = null;
        Vessel vessel = null;
        if (this.applies(collidable, collidable2) && !(vessel = (Vessel)(collidable instanceof Vessel ? collidable : collidable2)).isOutside((ion = (Ion)(collidable instanceof Ion ? collidable : collidable2)).getPosition()) && (this.areInContact((Collidable)ion, vessel.getWater()) || this.areInContact(ion, vessel)) && !ion.isBound()) {
            bl = this.handleIonVesselCollision(ion, vessel);
        }
        return bl;
    }

    private boolean handleIonVesselCollision(Ion ion, Vessel vessel) {
        boolean bl = this.model.isNucleationEnabled();
        double d = this.minDistToLikeIon;
        List<Ion> list = this.model.getIons();
        for (int i = 0; i < list.size() && bl; ++i) {
            Ion ion2 = list.get(i);
            if (!ion2.isBound() || !(ion2.getPosition().distance(ion.getPosition()) < d)) continue;
            bl = false;
        }
        if (bl && vessel.getIonStickAffinity().stick(ion, vessel)) {
            vessel.bind(ion);
        }
        boolean bl2 = this.sphereBoxExpert.detectAndDoCollision(ion, vessel.getWater());
        return bl2;
    }

    public boolean areInContact(Collidable collidable, Collidable collidable2) {
        return this.sphereBoxExpert.areInContact(collidable, collidable2);
    }

    private boolean areInContact(Ion ion, Vessel vessel) {
        Rectangle2D rectangle2D = vessel.getShape();
        Point2D point2D = ion.getPosition();
        double d = ion.getRadius();
        boolean bl = point2D.getX() + d >= rectangle2D.getMaxX() || point2D.getX() - d <= rectangle2D.getMinX() || point2D.getY() + d >= rectangle2D.getMaxY();
        return bl;
    }

    public boolean applies(Collidable collidable, Collidable collidable2) {
        return collidable instanceof Ion && collidable2 instanceof Vessel || collidable2 instanceof Ion && collidable instanceof Vessel;
    }
}

