/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.solublesalts.model.Drain;
import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.model.Spigot;
import edu.colorado.phet.solublesalts.model.Vessel;
import edu.colorado.phet.solublesalts.model.ion.Ion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IonFlowManager
implements Spigot.ChangeListener,
Vessel.ChangeListener {
    public static double SPEED_FACTOR = 0.2;
    private SolubleSaltsModel model;
    private double lastDepth;
    private double lastChange;
    private Map unadjustedVelocities = new HashMap();

    public IonFlowManager(SolubleSaltsModel solubleSaltsModel) {
        this.model = solubleSaltsModel;
        solubleSaltsModel.getVessel().addChangeListener(this);
        solubleSaltsModel.getDrain().addChangeListener(this);
    }

    public void stateChanged(Vessel.ChangeEvent changeEvent) {
        double d = changeEvent.getVessel().getWaterLevel();
        double d2 = d - this.lastDepth;
        this.lastDepth = d;
        if (d2 < 0.0 && d2 != this.lastChange) {
            double d3;
            this.lastChange = d2;
            List<Ion> list = this.model.getIons();
            Drain drain = this.model.getDrain();
            Vessel vessel = changeEvent.getVessel();
            double d4 = Double.MIN_VALUE;
            for (int i = 0; i < list.size(); ++i) {
                Ion ion = list.get(i);
                d3 = ion.getPosition().distanceSq(drain.getPosition());
                if (!(d3 > d4)) continue;
                d4 = d3;
            }
            double d5 = Math.sqrt(d4);
            d3 = this.model.getVessel().getLocation().getY() + this.model.getVessel().getDepth() - this.model.getDrain().getPosition().getY();
            double d6 = vessel.getWaterLevel() - d3;
            d6 = d6 > 0.0 ? d6 : vessel.getWaterLevel();
            double d7 = d6 / -d2;
            double d8 = d5 / d7;
            for (int i = 0; i < list.size(); ++i) {
                Ion ion = list.get(i);
                if (ion.isBound() || !vessel.getWater().getBounds().contains(ion.getPosition())) continue;
                if (this.unadjustedVelocities.get(ion) == null) {
                    this.unadjustedVelocities.put(ion, new MutableVector2D(ion.getVelocity()));
                }
                double d9 = Math.atan2(drain.getPosition().getY() - ion.getPosition().getY(), drain.getPosition().getX() - ion.getPosition().getX());
                MutableVector2D mutableVector2D = new MutableVector2D(d8, 0.0);
                mutableVector2D.rotate(d9);
                double d10 = changeEvent.isFromFaucet() ? Math.min(mutableVector2D.getX(), ion.getVelocity().getX()) : ion.getVelocity().getX();
                double d11 = Math.max(mutableVector2D.getY(), ion.getVelocity().getY());
                ion.setVelocity(d10, d11);
            }
        }
    }

    public void stateChanged(Spigot.ChangeEvent changeEvent) {
        if (changeEvent.getSpigot().getFlow() == 0.0) {
            Set set = this.unadjustedVelocities.keySet();
            for (Ion ion : set) {
                MutableVector2D mutableVector2D = (MutableVector2D)this.unadjustedVelocities.get(ion);
                MutableVector2D mutableVector2D2 = ion.getVelocity();
                mutableVector2D2.normalize().scale(mutableVector2D.magnitude());
            }
            this.unadjustedVelocities.clear();
        }
    }
}

