/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model;

import edu.colorado.phet.common.collision.Collidable;
import edu.colorado.phet.common.collision.SphereBoxExpert;
import edu.colorado.phet.solublesalts.model.Vessel;
import edu.colorado.phet.solublesalts.model.crystal.Crystal;
import edu.colorado.phet.solublesalts.model.ion.Ion;
import java.awt.geom.Rectangle2D;

public class CrystalVesselCollisionExpert {
    private SphereBoxExpert sphereBoxExpert = new SphereBoxExpert();

    public boolean detectAndDoCollision(Collidable collidable, Collidable collidable2) {
        boolean bl = false;
        Crystal crystal = null;
        Vessel vessel = null;
        if (this.applies(collidable, collidable2)) {
            crystal = (Crystal)(collidable instanceof Crystal ? collidable : collidable2);
            vessel = (Vessel)(collidable instanceof Vessel ? collidable : collidable2);
            if (crystal.getVelocity().magnitudeSquared() != 0.0) {
                Ion ion;
                Ion ion2;
                double d = 0.0;
                double d2 = 0.0;
                Rectangle2D rectangle2D = vessel.getShape();
                Ion ion3 = crystal.getExtremeIon(2);
                if (ion3.getPosition().getX() + ion3.getRadius() >= rectangle2D.getMaxX()) {
                    d = vessel.getWater().getMaxX() - ion3.getPosition().getX() - ion3.getRadius();
                    this.handleCrystalVesselCollision(ion3);
                    bl = true;
                }
                if ((ion2 = crystal.getExtremeIon(1)).getPosition().getY() + ion2.getRadius() >= rectangle2D.getMaxY()) {
                    d2 = vessel.getWater().getMaxY() - ion2.getPosition().getY() - ion2.getRadius();
                    this.handleCrystalVesselCollision(ion2);
                    bl = true;
                }
                if ((ion = crystal.getExtremeIon(3)).getPosition().getX() - ion.getRadius() <= rectangle2D.getMinX()) {
                    d = vessel.getWater().getMinX() - ion.getPosition().getX() + ion.getRadius();
                    this.handleCrystalVesselCollision(ion);
                    bl = true;
                }
                if (bl) {
                    crystal.setVelocity(0.0, 0.0);
                    crystal.setVelocity(0.0, 0.0);
                    crystal.setAcceleration(0.0, 0.0);
                    crystal.setAcceleration(0.0, 0.0);
                    crystal.translate(d, d2);
                    crystal.setBound(true);
                }
            }
        }
        return bl;
    }

    private void handleCrystalVesselCollision(Ion ion) {
        ion.getBindingCrystal().setVelocity(0.0, 0.0);
        ion.getBindingCrystal().setAcceleration(0.0, 0.0);
        ion.getBindingCrystal().setSeed(ion);
    }

    public boolean applies(Collidable collidable, Collidable collidable2) {
        return collidable instanceof Crystal && collidable2 instanceof Vessel || collidable2 instanceof Crystal && collidable instanceof Vessel;
    }
}

