/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model;

import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.model.crystal.Crystal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class CrystalTracker
implements Crystal.InstanceLifetimeListener {
    private SolubleSaltsModel model;
    private HashMap crystalMap = new HashMap();

    public CrystalTracker(SolubleSaltsModel solubleSaltsModel) {
        this.model = solubleSaltsModel;
    }

    public void instanceCreated(Crystal.InstanceLifetimeEvent instanceLifetimeEvent) {
        this.crystalAdded(instanceLifetimeEvent.getInstance());
    }

    public void instanceDestroyed(Crystal.InstanceLifetimeEvent instanceLifetimeEvent) {
        this.crystalRemoved(instanceLifetimeEvent.getInstance());
    }

    private void crystalAdded(Crystal crystal) {
        ArrayList<Crystal> arrayList = (ArrayList<Crystal>)this.crystalMap.get(crystal.getClass());
        if (arrayList == null) {
            arrayList = new ArrayList<Crystal>();
            this.crystalMap.put(crystal.getClass(), arrayList);
        }
        arrayList.add(crystal);
        this.model.addModelElement(crystal);
    }

    private void crystalRemoved(Crystal crystal) {
        List list = (List)this.crystalMap.get(crystal.getClass());
        list.remove(crystal);
        this.model.removeModelElement(crystal);
    }

    public List getCrystals() {
        ArrayList arrayList = new ArrayList();
        Collection collection = this.crystalMap.values();
        for (List list : collection) {
            arrayList.addAll(list);
        }
        return arrayList;
    }
}

