/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.control;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.solublesalts.SolubleSaltResources;
import edu.colorado.phet.solublesalts.SolubleSaltsConfig;
import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.model.Vessel;
import edu.colorado.phet.solublesalts.model.affinity.RandomAffinity;
import edu.colorado.phet.solublesalts.model.crystal.Crystal;
import edu.colorado.phet.solublesalts.module.SolubleSaltsModule;
import edu.colorado.phet.solublesalts.util.DefaultGridBagConstraints;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class SolubleSaltsControlPanel
extends ControlPanel {
    private ModelSlider vesselIonStickSlider;
    private ModelSlider dissociationSlider;
    private JPanel concentrationPanel;
    private JPanel waterLevelControlPanel;
    private JButton releaseButton;
    private SolubleSaltsModule module;

    protected abstract JPanel makeSaltSelectionPanel(SolubleSaltsModel var1);

    public SolubleSaltsControlPanel(final Module module) {
        this.module = (SolubleSaltsModule)module;
        final SolubleSaltsModel solubleSaltsModel = (SolubleSaltsModel)module.getModel();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), SolubleSaltResources.getString("ControlLabels.Salt")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)this.makeSaltSelectionPanel(solubleSaltsModel), gridBagConstraints);
        this.addControlFullWidth(jPanel);
        this.makeDebugControls(solubleSaltsModel);
        JButton jButton = new JButton(SolubleSaltResources.getString("ControlLabels.reset"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SolubleSaltsControlPanel.this.getModule().reset();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        this.addControl(jPanel2);
        this.releaseButton = new JButton("Release ion");
        this.releaseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = solubleSaltsModel.crystalTracker.getCrystals();
                for (int i = 0; i < list.size(); ++i) {
                    Crystal crystal = (Crystal)list.get(i);
                    crystal.releaseIon(module.getClock().getSimulationTimeChange());
                }
            }
        });
        this.releaseButton.setVisible(false);
        this.addControl(this.releaseButton);
        this.setDebugControlsVisible(SolubleSaltsConfig.DEBUG);
    }

    private void makeDebugControls(final SolubleSaltsModel solubleSaltsModel) {
        this.concentrationPanel = this.makeConcentrationPanel(solubleSaltsModel);
        this.addControl(this.concentrationPanel);
        this.vesselIonStickSlider = new ModelSlider("Lattice stick likelihood", "", 0.0, 1.0, 0.0, new DecimalFormat("0.00"));
        this.vesselIonStickSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                solubleSaltsModel.getVessel().setIonStickAffinity(new RandomAffinity(SolubleSaltsControlPanel.this.vesselIonStickSlider.getValue()));
            }
        });
        this.vesselIonStickSlider.setValue(SolubleSaltsConfig.DEFAULT_LATTICE_STICK_LIKELIHOOD);
        solubleSaltsModel.getVessel().setIonStickAffinity(new RandomAffinity(this.vesselIonStickSlider.getValue()));
        this.vesselIonStickSlider.setNumMajorTicks(5);
        this.dissociationSlider = new ModelSlider("Lattice dissociation likelihood", "", 0.0, 1.0, 0.0, new DecimalFormat("0.000"));
        this.dissociationSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Crystal.setDissociationLikelihood(SolubleSaltsControlPanel.this.dissociationSlider.getValue());
            }
        });
        this.dissociationSlider.setValue(SolubleSaltsConfig.DEFAULT_LATTICE_DISSOCIATION_LIKELIHOOD);
        Crystal.setDissociationLikelihood(this.dissociationSlider.getValue());
        this.dissociationSlider.setNumMajorTicks(5);
        this.addControl(this.vesselIonStickSlider);
        this.addControl(this.dissociationSlider);
        this.waterLevelControlPanel = this.makeWaterLevelPanel(solubleSaltsModel);
        this.addControl(this.waterLevelControlPanel);
        this.addControlFullWidth(new WaterLevelReadout(solubleSaltsModel.getVessel()));
    }

    private JPanel makeConcentrationPanel(final SolubleSaltsModel solubleSaltsModel) {
        final DecimalFormat decimalFormat = new DecimalFormat("0.00E00");
        final ModelSlider modelSlider = new ModelSlider("Ksp", "", 0.0, 3.0E-16, 0.0);
        modelSlider.setSliderLabelFormat(decimalFormat);
        modelSlider.setTextFieldFormat(decimalFormat);
        modelSlider.setNumMajorTicks(3);
        modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                solubleSaltsModel.setKsp(modelSlider.getValue());
            }
        });
        solubleSaltsModel.addChangeListener(new SolubleSaltsModel.ChangeAdapter(){

            public void stateChanged(SolubleSaltsModel.ChangeEvent changeEvent) {
                double d = solubleSaltsModel.getCurrentSalt().getKsp();
                modelSlider.setValue(d);
            }
        });
        final JTextField jTextField = new JTextField(8);
        solubleSaltsModel.addModelElement(new ModelElement(){

            public void stepInTime(double d) {
                double d2 = solubleSaltsModel.getConcentrationFactor();
                jTextField.setText(decimalFormat.format(d2));
            }
        });
        final ModelSlider modelSlider2 = new ModelSlider("Calibration Factor", "", 1.0E-16, 0.01, SolubleSaltsConfig.CONCENTRATION_CALIBRATION_FACTOR, decimalFormat);
        modelSlider2.setSliderLabelFormat(decimalFormat);
        modelSlider2.setTextFieldFormat(decimalFormat);
        modelSlider2.setNumMajorTicks(3);
        modelSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SolubleSaltsConfig.CONCENTRATION_CALIBRATION_FACTOR = modelSlider2.getValue();
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Concentration"));
        DefaultGridBagConstraints defaultGridBagConstraints = new DefaultGridBagConstraints();
        defaultGridBagConstraints.gridwidth = 2;
        jPanel.add((Component)modelSlider, defaultGridBagConstraints);
        defaultGridBagConstraints.gridwidth = 1;
        defaultGridBagConstraints.gridy = 1;
        defaultGridBagConstraints.anchor = 13;
        jPanel.add((Component)new JLabel("Conc. factor:"), defaultGridBagConstraints);
        defaultGridBagConstraints.gridx = 1;
        defaultGridBagConstraints.anchor = 17;
        jPanel.add((Component)jTextField, defaultGridBagConstraints);
        defaultGridBagConstraints.gridx = 0;
        defaultGridBagConstraints.gridy = 2;
        defaultGridBagConstraints.gridwidth = 2;
        jPanel.add((Component)modelSlider2, defaultGridBagConstraints);
        return jPanel;
    }

    private JPanel makeWaterLevelPanel(final SolubleSaltsModel solubleSaltsModel) {
        JPanel jPanel = new JPanel();
        final ModelSlider modelSlider = new ModelSlider("Water level", "", 0.0, solubleSaltsModel.getVessel().getDepth(), solubleSaltsModel.getVessel().getWaterLevel());
        modelSlider.setTextFieldFormat(new DecimalFormat("#"));
        modelSlider.setNumMajorTicks(6);
        modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                solubleSaltsModel.getVessel().setWaterLevel(modelSlider.getValue() * ((SolubleSaltsControlPanel)SolubleSaltsControlPanel.this).module.getCalibration().volumeCalibrationFactor);
            }
        });
        jPanel.add(modelSlider);
        return jPanel;
    }

    public void setDebugControlsVisible(boolean bl) {
        this.vesselIonStickSlider.setVisible(bl);
        this.dissociationSlider.setVisible(bl);
        this.concentrationPanel.setVisible(bl);
        this.waterLevelControlPanel.setVisible(bl);
        this.releaseButton.setVisible(bl);
        this.revalidate();
    }

    protected SolubleSaltsModule getModule() {
        return this.module;
    }

    private class WaterLevelReadout
    extends JPanel
    implements Vessel.ChangeListener {
        JTextField readout;
        DecimalFormat format;

        public WaterLevelReadout(Vessel vessel) {
            super(new GridBagLayout());
            this.format = new DecimalFormat("0.00E0");
            this.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), SolubleSaltResources.getString("ControlLabels.Water")));
            vessel.addChangeListener(this);
            DefaultGridBagConstraints defaultGridBagConstraints = new DefaultGridBagConstraints();
            defaultGridBagConstraints.insets = new Insets(0, 5, 0, 5);
            JLabel jLabel = new JLabel(SolubleSaltResources.getString("ControlLabels.Volume") + ":", 4);
            this.add((Component)jLabel, defaultGridBagConstraints);
            this.readout = new JTextField(6);
            this.readout.setHorizontalAlignment(4);
            this.setReadoutValue(vessel);
            this.readout.setEditable(false);
            ++defaultGridBagConstraints.gridx;
            this.add((Component)this.readout, defaultGridBagConstraints);
            JLabel jLabel2 = new JLabel(SolubleSaltResources.getString("ControlLabels.liters") + " (" + SolubleSaltResources.getString("ControlLabels.liters.abbreviation") + ")");
            ++defaultGridBagConstraints.gridx;
            this.add((Component)jLabel2, defaultGridBagConstraints);
        }

        public void stateChanged(Vessel.ChangeEvent changeEvent) {
            this.setReadoutValue(changeEvent.getVessel());
        }

        private void setReadoutValue(Vessel vessel) {
            this.readout.setText(this.format.format(vessel.getWaterLevel() * ((SolubleSaltsControlPanel)SolubleSaltsControlPanel.this).module.getCalibration().volumeCalibrationFactor));
        }
    }
}

