/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.control;

import edu.colorado.phet.solublesalts.SolubleSaltResources;
import edu.colorado.phet.solublesalts.control.SaltSpinnerPanel;
import edu.colorado.phet.solublesalts.control.SolubleSaltsControlPanel;
import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.model.salt.CuprousIodide;
import edu.colorado.phet.solublesalts.model.salt.MercuryBromide;
import edu.colorado.phet.solublesalts.model.salt.Salt;
import edu.colorado.phet.solublesalts.model.salt.SilverArsenate;
import edu.colorado.phet.solublesalts.model.salt.SilverBromide;
import edu.colorado.phet.solublesalts.model.salt.StrontiumPhosphate;
import edu.colorado.phet.solublesalts.model.salt.ThallousSulfide;
import edu.colorado.phet.solublesalts.module.SolubleSaltsModule;
import edu.colorado.phet.solublesalts.util.DefaultGridBagConstraints;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class RealSaltsControlPanel
extends SolubleSaltsControlPanel {
    protected static HashMap saltMap = new HashMap();

    public RealSaltsControlPanel(SolubleSaltsModule solubleSaltsModule) {
        super(solubleSaltsModule);
    }

    protected JPanel makeSaltSelectionPanel(final SolubleSaltsModel solubleSaltsModel) {
        final JComboBox<Object> jComboBox = new JComboBox<Object>(saltMap.keySet().toArray());
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Salt salt = (Salt)saltMap.get(jComboBox.getSelectedItem());
                solubleSaltsModel.setCurrentSalt(salt);
                RealSaltsControlPanel.this.getModule().reset();
                RealSaltsControlPanel.this.revalidate();
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints defaultGridBagConstraints = new DefaultGridBagConstraints();
        defaultGridBagConstraints.anchor = 10;
        defaultGridBagConstraints.gridx = 0;
        jPanel.add(jComboBox, defaultGridBagConstraints);
        defaultGridBagConstraints.anchor = 17;
        ++defaultGridBagConstraints.gridy;
        SaltSpinnerPanel saltSpinnerPanel = new SaltSpinnerPanel(solubleSaltsModel);
        jPanel.add((Component)saltSpinnerPanel, defaultGridBagConstraints);
        Salt salt = (Salt)saltMap.get(jComboBox.getSelectedItem());
        solubleSaltsModel.setCurrentSalt(salt);
        this.revalidate();
        return jPanel;
    }

    static {
        saltMap.put(SolubleSaltResources.getString("Salt.silverBromide"), new SilverBromide());
        saltMap.put(SolubleSaltResources.getString("Salt.copperIodide"), new CuprousIodide());
        saltMap.put(SolubleSaltResources.getString("Salt.thalliumSulfide"), new ThallousSulfide());
        saltMap.put(SolubleSaltResources.getString("Salt.silverArsenate"), new SilverArsenate());
        saltMap.put(SolubleSaltResources.getString("Salt.strontiumPhosphate"), new StrontiumPhosphate());
        saltMap.put(SolubleSaltResources.getString("Salt.mercuryBromide"), new MercuryBromide());
    }
}

