/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.control;

import edu.colorado.phet.solublesalts.SolubleSaltResources;
import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.util.DefaultGridBagConstraints;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class KspControl
extends JPanel {
    private JSpinner mantissaSpinner;
    private JSpinner oomSpinner;
    private SolubleSaltsModel model;
    private double maxExponent = 1.0E-12;
    private double minExponent = -40.0;
    private double defaultExponent = -12.0;

    public KspControl(SolubleSaltsModel solubleSaltsModel) {
        this.model = solubleSaltsModel;
        this.mantissaSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 10.0, 0.1));
        this.mantissaSpinner.setPreferredSize(new Dimension(45, (int)this.mantissaSpinner.getPreferredSize().getHeight()));
        this.mantissaSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                KspControl.this.setKsp();
            }
        });
        this.oomSpinner = new JSpinner(new SpinnerNumberModel(this.defaultExponent, this.minExponent, this.maxExponent, 1.0));
        this.oomSpinner.setPreferredSize(new Dimension(45, (int)this.oomSpinner.getPreferredSize().getHeight()));
        this.oomSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                KspControl.this.setKsp();
            }
        });
        this.setKsp();
        this.setBorder(new TitledBorder(SolubleSaltResources.getString("ControlLabels.ksp")));
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints defaultGridBagConstraints = new DefaultGridBagConstraints();
        defaultGridBagConstraints.anchor = 13;
        defaultGridBagConstraints.gridx = 0;
        defaultGridBagConstraints.gridy = 0;
        this.add((Component)this.mantissaSpinner, defaultGridBagConstraints);
        defaultGridBagConstraints.gridx = 1;
        this.add((Component)new JLabel(" E "), defaultGridBagConstraints);
        defaultGridBagConstraints.gridx = 2;
        defaultGridBagConstraints.anchor = 17;
        this.add((Component)this.oomSpinner, defaultGridBagConstraints);
    }

    private void setKsp() {
        this.model.setKsp(this.getKsp());
    }

    public double getKsp() {
        double d = (Double)this.mantissaSpinner.getValue();
        double d2 = (Double)this.oomSpinner.getValue();
        double d3 = d * Math.pow(10.0, d2);
        return d3;
    }
}

