/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.control;

import edu.colorado.phet.solublesalts.SolubleSaltResources;
import edu.colorado.phet.solublesalts.control.KspControl;
import edu.colorado.phet.solublesalts.control.SaltSpinnerPanel;
import edu.colorado.phet.solublesalts.control.SolubleSaltsControlPanel;
import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.model.ion.ConfigurableAnion;
import edu.colorado.phet.solublesalts.model.ion.ConfigurableCation;
import edu.colorado.phet.solublesalts.model.salt.ConfigurableSalt;
import edu.colorado.phet.solublesalts.module.ConfigurableSaltModule;
import edu.colorado.phet.solublesalts.util.DefaultGridBagConstraints;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ConfigurableSaltControlPanel
extends SolubleSaltsControlPanel {
    public ConfigurableSaltControlPanel(ConfigurableSaltModule configurableSaltModule) {
        super(configurableSaltModule);
    }

    protected JPanel makeSaltSelectionPanel(final SolubleSaltsModel solubleSaltsModel) {
        SaltSpinnerPanel saltSpinnerPanel = new SaltSpinnerPanel(solubleSaltsModel);
        final KspControl kspControl = new KspControl(solubleSaltsModel);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1, 1, 3, 1);
        final JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        JLabel jLabel = new JLabel(SolubleSaltResources.getString("ControlLabels.CationCharge") + ": ");
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(jSpinner, "+#");
        jSpinner.setEditor(numberEditor);
        jSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ConfigurableCation.setClassCharge((Integer)jSpinner.getValue());
                ConfigurableSalt.configure();
                solubleSaltsModel.setCurrentSalt(new ConfigurableSalt());
                ConfigurableSaltControlPanel.this.getModule().reset();
                solubleSaltsModel.setKsp(kspControl.getKsp());
            }
        });
        JLabel jLabel2 = new JLabel(SolubleSaltResources.getString("ControlLabels.AnionCharge") + ": ");
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(-1, -3, -1, 1);
        final JSpinner jSpinner2 = new JSpinner(spinnerNumberModel2);
        spinnerNumberModel2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ConfigurableAnion.setClassCharge((Integer)jSpinner2.getValue());
                ConfigurableSalt.configure();
                solubleSaltsModel.setCurrentSalt(new ConfigurableSalt());
                ConfigurableSaltControlPanel.this.getModule().reset();
                solubleSaltsModel.setKsp(kspControl.getKsp());
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints defaultGridBagConstraints = new DefaultGridBagConstraints();
        defaultGridBagConstraints.weightx = 0.5;
        defaultGridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel, defaultGridBagConstraints);
        defaultGridBagConstraints.gridx = 1;
        defaultGridBagConstraints.anchor = 17;
        jPanel.add((Component)jSpinner, defaultGridBagConstraints);
        defaultGridBagConstraints.gridy = 1;
        defaultGridBagConstraints.gridx = 0;
        defaultGridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel2, defaultGridBagConstraints);
        defaultGridBagConstraints.gridx = 1;
        defaultGridBagConstraints.anchor = 17;
        jPanel.add((Component)jSpinner2, defaultGridBagConstraints);
        defaultGridBagConstraints.anchor = 10;
        defaultGridBagConstraints.gridx = 0;
        ++defaultGridBagConstraints.gridy;
        defaultGridBagConstraints.gridwidth = 2;
        jPanel.add((Component)kspControl, defaultGridBagConstraints);
        defaultGridBagConstraints.anchor = 17;
        ++defaultGridBagConstraints.gridy;
        jPanel.add((Component)saltSpinnerPanel, defaultGridBagConstraints);
        return jPanel;
    }
}

