/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.solublesalts.SolubleSaltResources;
import edu.colorado.phet.solublesalts.SolubleSaltsConfig;
import edu.colorado.phet.solublesalts.control.DeveloperMenuSetup;
import edu.colorado.phet.solublesalts.module.ConfigurableSaltModule;
import edu.colorado.phet.solublesalts.module.RealSaltsModule;
import edu.colorado.phet.solublesalts.module.SodiumChlorideModule;
import edu.colorado.phet.solublesalts.view.IonGraphic;
import java.awt.Color;
import javax.swing.UIManager;

public class SolubleSaltsApplication
extends PiccoloPhetApplication {
    public SolubleSaltsApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        RealSaltsModule realSaltsModule = new RealSaltsModule(new SolubleSaltsClock());
        ConfigurableSaltModule configurableSaltModule = new ConfigurableSaltModule(new SolubleSaltsClock());
        SodiumChlorideModule sodiumChlorideModule = new SodiumChlorideModule(new SolubleSaltsClock(), SolubleSaltResources.getString("Module.sodiumChloride"));
        this.setModules(new Module[]{sodiumChlorideModule, realSaltsModule, configurableSaltModule});
        if (this.isDeveloperControlsEnabled()) {
            DeveloperMenuSetup.setup(this.getPhetFrame().getDeveloperMenu(), this.getPhetFrame());
        }
    }

    public static void main(final String[] stringArray) {
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "soluble-salts");
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                Object object;
                for (int i = 0; i < stringArray.length; ++i) {
                    object = stringArray[i];
                    if (((String)object).equals("-b")) {
                        IonGraphic.showBondIndicators(true);
                    }
                    if (((String)object).startsWith("-w")) {
                        SolubleSaltsConfig.DEFAULT_WATER_LEVEL = Integer.parseInt(((String)object).substring(3));
                    }
                    if (((String)object).equals("-o")) {
                        SolubleSaltsConfig.ONE_CRYSTAL_ONLY = true;
                    }
                    if (((String)object).startsWith("-s=")) {
                        SolubleSaltsConfig.DEFAULT_LATTICE_STICK_LIKELIHOOD = Double.parseDouble(((String)object).substring(3));
                    }
                    if (((String)object).startsWith("-d=")) {
                        SolubleSaltsConfig.DEFAULT_LATTICE_DISSOCIATION_LIKELIHOOD = Double.parseDouble(((String)object).substring(3));
                    }
                    if (((String)object).startsWith("-c=")) {
                        SolubleSaltsConfig.CONCENTRATION_CALIBRATION_FACTOR = Double.parseDouble(((String)object).substring(3));
                    }
                    if (!((String)object).startsWith("debug=")) continue;
                    SolubleSaltsConfig.DEBUG = true;
                }
                Color color = new Color(230, 250, 255);
                object = new Color(220, 220, 220);
                UIManager.put("Panel.background", color);
                UIManager.put("MenuBar.background", object);
                UIManager.put("Menu.background", object);
                UIManager.put("TabbedPane.background", color);
                UIManager.put("TabbedPane.selected", color);
                SolubleSaltsApplication solubleSaltsApplication = new SolubleSaltsApplication(phetApplicationConfig);
                return solubleSaltsApplication;
            }
        });
    }

    public static class SolubleSaltsClock
    extends SwingClock {
        public SolubleSaltsClock() {
            super(40, 1.0);
        }
    }
}

