/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.collision;

import edu.colorado.phet.common.collision.Collidable;
import edu.colorado.phet.common.collision.CollidableAdapter;
import edu.colorado.phet.common.mechanics.Body;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Box2D
extends Body
implements Collidable {
    private Point2D corner1;
    private Point2D corner2;
    private Point2D center;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private double leftWallVx = 0.0;
    private double minimumWidth = 100.0;
    private CollidableAdapter collidableAdapter = new CollidableAdapter(this);
    private Rectangle2D.Double bounds = new Rectangle2D.Double();
    private double width0 = 40.0;

    public Box2D() {
        this(new Point2D.Double(), new Point2D.Double());
    }

    public Box2D(Point2D point2D, Point2D point2D2) {
        this.setState(point2D, point2D2);
        this.setMass(Double.POSITIVE_INFINITY);
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.setState(new Point2D.Double(d, d2), new Point2D.Double(d3, d4));
    }

    public Rectangle2D getBounds() {
        this.bounds.setRect(this.minX, this.minY, this.getWidth(), this.getHeight());
        return this.bounds;
    }

    private void setState(Point2D point2D, Point2D point2D2) {
        this.corner1 = point2D;
        this.corner2 = point2D2;
        this.maxX = Math.max(point2D.getX(), point2D2.getX());
        this.maxY = Math.max(point2D.getY(), point2D2.getY());
        this.minX = Math.max(Math.min(Math.min(point2D.getX(), point2D2.getX()), this.maxX - this.minimumWidth), this.width0);
        this.minY = Math.min(point2D.getY(), point2D2.getY());
        this.center = new Point2D.Double((this.maxX + this.minX) / 2.0, (this.maxY + this.minY) / 2.0);
        this.setPosition(new Point2D.Double(this.minX, this.minY));
        this.notifyObservers();
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getWidth() {
        return Math.abs(this.corner2.getX() - this.corner1.getX());
    }

    public double getHeight() {
        return Math.abs(this.corner2.getY() - this.corner1.getY());
    }

    public double getLeftWallVx() {
        return this.leftWallVx;
    }
}

