/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PStack;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.event.EventListenerList;

public class PPickPath
implements PInputEventListener {
    public static PPickPath CURRENT_PICK_PATH;
    private static double[] PTS;
    private PStack nodeStack;
    private PStack transformStack;
    private PStack pickBoundsStack = new PStack();
    private PCamera topCamera;
    private PCamera bottomCamera;
    private HashMap excludedNodes;

    public PPickPath(PCamera pCamera, PBounds pBounds) {
        this.topCamera = pCamera;
        this.nodeStack = new PStack();
        this.transformStack = new PStack();
        this.pickBoundsStack.push(pBounds);
        CURRENT_PICK_PATH = this;
    }

    public PBounds getPickBounds() {
        return (PBounds)this.pickBoundsStack.peek();
    }

    public boolean acceptsNode(PNode pNode) {
        if (this.excludedNodes != null) {
            return !this.excludedNodes.containsKey(pNode);
        }
        return true;
    }

    public void pushNode(PNode pNode) {
        this.nodeStack.push(pNode);
    }

    public void popNode(PNode pNode) {
        this.nodeStack.pop();
    }

    public PNode getPickedNode() {
        return (PNode)this.nodeStack.peek();
    }

    public PCamera getTopCamera() {
        return this.topCamera;
    }

    public PCamera getBottomCamera() {
        if (this.bottomCamera == null) {
            for (int i = this.nodeStack.size() - 1; i >= 0; --i) {
                PNode pNode = (PNode)this.nodeStack.get(i);
                if (!(pNode instanceof PCamera)) continue;
                this.bottomCamera = (PCamera)pNode;
                return this.bottomCamera;
            }
        }
        return this.bottomCamera;
    }

    public PStack getNodeStackReference() {
        return this.nodeStack;
    }

    public void pushTransform(PAffineTransform pAffineTransform) {
        this.transformStack.push(new PTuple(this.getPickedNode(), pAffineTransform));
        if (pAffineTransform != null) {
            Rectangle2D rectangle2D = (Rectangle2D)this.getPickBounds().clone();
            pAffineTransform.inverseTransform(rectangle2D, rectangle2D);
            this.pickBoundsStack.push(rectangle2D);
        }
    }

    public void popTransform(PAffineTransform pAffineTransform) {
        this.transformStack.pop();
        if (pAffineTransform != null) {
            this.pickBoundsStack.pop();
        }
    }

    public PAffineTransform getPathTransformTo(PNode pNode) {
        PAffineTransform pAffineTransform = new PAffineTransform();
        int n = this.transformStack.size();
        for (int i = 0; i < n; ++i) {
            PTuple pTuple = (PTuple)this.transformStack.get(i);
            if (pTuple.transform != null) {
                pAffineTransform.concatenate(pTuple.transform);
            }
            if (pNode != pTuple.node) continue;
            return pAffineTransform;
        }
        throw new RuntimeException("Node could not be found on pick path");
    }

    public void processEvent(PInputEvent pInputEvent, int n) {
        pInputEvent.setPath(this);
        for (int i = this.nodeStack.size() - 1; i >= 0; --i) {
            PNode pNode = (PNode)this.nodeStack.get(i);
            EventListenerList eventListenerList = pNode.getListenerList();
            if (eventListenerList == null) continue;
            EventListener[] eventListenerArray = eventListenerList.getListeners(PInputEventListener.class);
            for (int j = 0; j < eventListenerArray.length; ++j) {
                PInputEventListener pInputEventListener = (PInputEventListener)eventListenerArray[j];
                pInputEventListener.processEvent(pInputEvent, n);
            }
        }
    }

    public Point2D canvasToLocal(Point2D point2D, PNode pNode) {
        try {
            return this.getPathTransformTo(pNode).inverseTransform(point2D, point2D);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
            return null;
        }
    }

    public Dimension2D canvasToLocal(Dimension2D dimension2D, PNode pNode) {
        return this.getPathTransformTo(pNode).inverseTransform(dimension2D, dimension2D);
    }

    static {
        PTS = new double[4];
    }

    private static class PTuple {
        public PNode node;
        public PAffineTransform transform;

        public PTuple(PNode pNode, PAffineTransform pAffineTransform) {
            this.node = pNode;
            this.transform = pAffineTransform;
        }
    }
}

