/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Point2D;

public class PPanEventHandler
extends PDragSequenceEventHandler {
    private boolean autopan;
    private double minAutopanSpeed = 250.0;
    private double maxAutopanSpeed = 750.0;

    public PPanEventHandler() {
        this.setEventFilter(new PInputEventFilter(16));
        this.setAutopan(true);
    }

    protected void drag(PInputEvent pInputEvent) {
        super.drag(pInputEvent);
        this.pan(pInputEvent);
    }

    protected void pan(PInputEvent pInputEvent) {
        PCamera pCamera = pInputEvent.getCamera();
        Point2D point2D = pInputEvent.getPosition();
        if (pCamera.getViewBounds().contains(point2D)) {
            PDimension pDimension = pInputEvent.getDelta();
            pCamera.translateView(pDimension.getWidth(), pDimension.getHeight());
        }
    }

    public void setAutopan(boolean bl) {
        this.autopan = bl;
    }

    protected void dragActivityStep(PInputEvent pInputEvent) {
        if (!this.autopan) {
            return;
        }
        PCamera pCamera = pInputEvent.getCamera();
        PBounds pBounds = pCamera.getBoundsReference();
        Point2D point2D = pInputEvent.getPositionRelativeTo(pCamera);
        int n = pBounds.outcode(point2D);
        PDimension pDimension = new PDimension();
        if ((n & 2) != 0) {
            pDimension.height = this.validatePanningSpeed(-1.0 - 0.5 * Math.abs(point2D.getY() - pBounds.getY()));
        } else if ((n & 8) != 0) {
            pDimension.height = this.validatePanningSpeed(1.0 + 0.5 * Math.abs(point2D.getY() - (pBounds.getY() + pBounds.getHeight())));
        }
        if ((n & 4) != 0) {
            pDimension.width = this.validatePanningSpeed(1.0 + 0.5 * Math.abs(point2D.getX() - (pBounds.getX() + pBounds.getWidth())));
        } else if ((n & 1) != 0) {
            pDimension.width = this.validatePanningSpeed(-1.0 - 0.5 * Math.abs(point2D.getX() - pBounds.getX()));
        }
        pCamera.localToView(pDimension);
        if (pDimension.width != 0.0 || pDimension.height != 0.0) {
            pCamera.translateView(pDimension.width, pDimension.height);
        }
    }

    protected double validatePanningSpeed(double d) {
        double d2 = this.minAutopanSpeed / (double)(1000L / this.getDragActivity().getStepRate());
        double d3 = this.maxAutopanSpeed / (double)(1000L / this.getDragActivity().getStepRate());
        boolean bl = d < 0.0;
        if ((d = Math.abs(d)) < d2) {
            d = d2;
        }
        if (d > d3) {
            d = d3;
        }
        if (bl) {
            d = -d;
        }
        return d;
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("minAutopanSpeed=" + this.minAutopanSpeed);
        stringBuffer.append(",maxAutopanSpeed=" + this.maxAutopanSpeed);
        if (this.autopan) {
            stringBuffer.append(",autopan");
        }
        stringBuffer.append(',');
        stringBuffer.append(super.paramString());
        return stringBuffer.toString();
    }
}

